/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.publishing.dataprotection;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.persisting.keyvalue.KeyValueStore;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import io.fluxcapacitor.javaclient.publishing.dataprotection.DropProtectedData;
import io.fluxcapacitor.javaclient.publishing.dataprotection.ProtectData;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerInterceptor;
import java.beans.ConstructorProperties;
import java.lang.reflect.AccessibleObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataProtectionInterceptor
implements DispatchInterceptor,
HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DataProtectionInterceptor.class);
    public static String METADATA_KEY = "$protectedData";
    private final KeyValueStore keyValueStore;
    private final Serializer serializer;

    @Override
    public Function<Message, SerializedMessage> interceptDispatch(Function<Message, SerializedMessage> function, MessageType messageType) {
        return m -> {
            HashMap<String, String> protectedFields = new HashMap<String, String>();
            if (m.getMetadata().containsKey((Object)METADATA_KEY)) {
                protectedFields.putAll((Map)m.getMetadata().get(METADATA_KEY, Map.class));
            } else {
                Object payload = m.getPayload();
                ReflectionUtils.getAnnotatedFields(m.getPayload(), ProtectData.class).forEach(field -> {
                    Object value = ReflectionUtils.getProperty((AccessibleObject)field, (Object)payload);
                    if (value != null) {
                        String key = UUID.randomUUID().toString();
                        this.keyValueStore.store(key, value, Guarantee.STORED);
                        protectedFields.put(field.getName(), key);
                    }
                });
                if (!protectedFields.isEmpty()) {
                    m.getMetadata().put(METADATA_KEY, protectedFields);
                }
            }
            if (!protectedFields.isEmpty()) {
                Object payloadCopy = this.serializer.deserialize(this.serializer.serialize(m.getPayload()));
                protectedFields.forEach((name, key) -> ReflectionUtils.setField((String)name, (Object)payloadCopy, null));
                m = m.withPayload(payloadCopy);
            }
            return (SerializedMessage)function.apply((Message)m);
        };
    }

    @Override
    public Function<DeserializingMessage, Object> interceptHandling(Function<DeserializingMessage, Object> function, Handler<DeserializingMessage> handler, String consumer) {
        return m -> {
            if (m.getMetadata().containsKey((Object)METADATA_KEY)) {
                Object payload = m.getPayload();
                Map protectedFields = (Map)m.getMetadata().get(METADATA_KEY, Map.class);
                boolean dropProtectedData = handler.getMethod(m).isAnnotationPresent(DropProtectedData.class);
                protectedFields.forEach((fieldName, key) -> {
                    try {
                        ReflectionUtils.setField((String)fieldName, (Object)payload, this.keyValueStore.get((String)key));
                    }
                    catch (Exception e) {
                        log.warn("Failed to set field {}", fieldName, (Object)e);
                    }
                    if (dropProtectedData) {
                        this.keyValueStore.delete((String)key);
                    }
                });
            }
            return function.apply((DeserializingMessage)m);
        };
    }

    @ConstructorProperties(value={"keyValueStore", "serializer"})
    public DataProtectionInterceptor(KeyValueStore keyValueStore, Serializer serializer) {
        this.keyValueStore = keyValueStore;
        this.serializer = serializer;
    }
}

