/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.filter.LevelFilter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.filter.Filter;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.logging.ConsoleError;
import io.fluxcapacitor.javaclient.common.logging.ConsoleWarning;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluxCapacitorLogbackAppender
extends AppenderBase<ILoggingEvent> {
    private static final Logger log = LoggerFactory.getLogger(FluxCapacitorLogbackAppender.class);

    public static void attach() {
        Context loggerContext = (Context)LoggerFactory.getILoggerFactory();
        FluxCapacitorLogbackAppender appender = new FluxCapacitorLogbackAppender();
        LevelFilter filter = new LevelFilter();
        filter.setLevel(Level.WARN);
        appender.addFilter((Filter)filter);
        appender.setContext(loggerContext);
        appender.start();
        ch.qos.logback.classic.Logger rootLogger = FluxCapacitorLogbackAppender.getRootLogger();
        rootLogger.addAppender((Appender)appender);
    }

    public static void detach() {
        ch.qos.logback.classic.Logger rootLogger = FluxCapacitorLogbackAppender.getRootLogger();
        Iterator iterator = rootLogger.iteratorForAppenders();
        ArrayList<Appender> appenders = new ArrayList<Appender>();
        while (iterator.hasNext()) {
            Appender appender = (Appender)iterator.next();
            if (!(appender instanceof FluxCapacitorLogbackAppender)) continue;
            appenders.add(appender);
        }
        appenders.forEach(arg_0 -> ((ch.qos.logback.classic.Logger)rootLogger).detachAppender(arg_0));
    }

    protected void append(ILoggingEvent event) {
        try {
            Optional<Throwable> throwable = Optional.ofNullable((ThrowableProxy)event.getThrowableProxy()).map(ThrowableProxy::getThrowable);
            Metadata metadata = Optional.ofNullable(DeserializingMessage.getCurrent()).map(d -> d.getSerializedObject().getMetadata()).orElse(Metadata.empty());
            metadata = metadata.with(new Object[]{"stackTrace", String.format("[%s] %s %s - %s%s", event.getThreadName(), event.getLevel(), event.getLoggerName(), event.getFormattedMessage(), throwable.map(e -> "\n" + ExceptionUtils.getStackTrace((Throwable)e)).orElse("")), "level", event.getLevel().toString(), "loggerName", event.getLoggerName()});
            if (throwable.isPresent()) {
                Throwable e2 = throwable.get();
                metadata = metadata.with(new Object[]{"error", e2.getClass().getSimpleName(), "errorMessage", StringUtils.isBlank((CharSequence)e2.getMessage()) ? event.getFormattedMessage() : e2.getMessage()});
                StackTraceElement[] stackTraceElements = Optional.ofNullable(e2.getStackTrace()).filter(s -> ((StackTraceElement[])s).length > 0).orElse(null);
                if (stackTraceElements != null) {
                    metadata = metadata.with("traceElement", (Object)stackTraceElements[0].toString());
                }
            } else {
                metadata = metadata.with("errorMessage", (Object)event.getFormattedMessage());
            }
            FluxCapacitor.get().errorGateway().report(event.getLevel() == Level.WARN ? new ConsoleWarning() : new ConsoleError(), metadata);
        }
        catch (Throwable e3) {
            log.info("Failed to publish console error", e3);
        }
    }

    private static ch.qos.logback.classic.Logger getRootLogger() {
        return (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
    }
}

