/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.configuration.spring;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.common.serialization.jackson.JacksonSerializer;
import io.fluxcapacitor.javaclient.common.serialization.upcasting.UpcastInspector;
import io.fluxcapacitor.javaclient.configuration.DefaultFluxCapacitor;
import io.fluxcapacitor.javaclient.configuration.FluxCapacitorBuilder;
import io.fluxcapacitor.javaclient.configuration.client.Client;
import io.fluxcapacitor.javaclient.configuration.client.InMemoryClient;
import io.fluxcapacitor.javaclient.configuration.client.WebSocketClient;
import io.fluxcapacitor.javaclient.configuration.spring.ConditionalOnMissingBean;
import io.fluxcapacitor.javaclient.persisting.caching.Cache;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.UserProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;

@Configuration
public class FluxCapacitorSpringConfig
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(FluxCapacitorSpringConfig.class);
    private final ApplicationContext context;
    private final List<Object> springBeans = new CopyOnWriteArrayList<Object>();
    private final AtomicReference<Registration> handlerRegistration = new AtomicReference();

    @Autowired
    protected FluxCapacitorSpringConfig(ApplicationContext context) {
        this.context = context;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        this.springBeans.add(bean);
        return bean;
    }

    @EventListener
    public void handle(ContextRefreshedEvent event) {
        FluxCapacitor fluxCapacitor = (FluxCapacitor)this.context.getBean(FluxCapacitor.class);
        this.handlerRegistration.updateAndGet(r -> r == null ? fluxCapacitor.registerHandlers(this.springBeans) : r);
        if (Thread.getDefaultUncaughtExceptionHandler() == null) {
            Thread.setDefaultUncaughtExceptionHandler((t, e) -> log.error("Uncaught exception", e));
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public Serializer serializer() {
        ArrayList upcasters = new ArrayList();
        for (String beanName : this.context.getBeanDefinitionNames()) {
            Optional.ofNullable(this.context.getType(beanName)).filter(UpcastInspector::hasAnnotatedMethods).ifPresent(t -> upcasters.add(this.context.getAutowireCapableBeanFactory().getBean(beanName)));
        }
        return this.getBean(ObjectMapper.class).map(objectMapper -> new JacksonSerializer((ObjectMapper)objectMapper, upcasters)).orElse(new JacksonSerializer(upcasters));
    }

    @Bean
    @ConditionalOnMissingBean
    public FluxCapacitorBuilder fluxCapacitorBuilder(Serializer serializer, Optional<UserProvider> userProvider, Optional<Cache> cache) {
        FluxCapacitorBuilder builder = DefaultFluxCapacitor.builder().disableShutdownHook().replaceSerializer(serializer).replaceSnapshotSerializer(serializer).makeApplicationInstance(true);
        userProvider.ifPresent(builder::registerUserSupplier);
        cache.ifPresent(builder::replaceCache);
        return builder;
    }

    @Bean
    @ConditionalOnMissingBean
    public FluxCapacitor fluxCapacitor(FluxCapacitorBuilder builder) {
        Client client = this.getBean(Client.class).orElseGet(() -> this.getBean(WebSocketClient.Properties.class).map(WebSocketClient::newInstance).orElseGet(() -> {
            log.info("Using in-memory Flux Capacitor client");
            return InMemoryClient.newInstance();
        }));
        return builder.build(client);
    }

    protected <T> Optional<T> getBean(Class<T> type) {
        return this.context.getBeansOfType(type).values().stream().findFirst();
    }
}

