/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.modeling;

import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.tracking.handling.validation.ValidationUtils;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public interface AggregateRoot<T> {
    public static final String AGGREGATE_ID_METADATA_KEY = "$aggregateId";
    public static final String AGGREGATE_TYPE_METADATA_KEY = "$aggregateType";

    public String id();

    public Class<T> type();

    public T get();

    public String lastEventId();

    public Long lastEventIndex();

    public Instant timestamp();

    public AggregateRoot<T> previous();

    default public AggregateRoot<T> playBackToEvent(String eventId) {
        return this.playBackToCondition(aggregate -> Objects.equals(eventId, aggregate.lastEventId())).orElseThrow(() -> new IllegalStateException(String.format("Could not load aggregate %s of type %s for event %s. Aggregate (%s) started at event %s", this.id(), this.type().getSimpleName(), eventId, this, this.lastEventId())));
    }

    default public Optional<AggregateRoot<T>> playBackToCondition(Predicate<AggregateRoot<T>> condition) {
        AggregateRoot<T> result;
        for (result = this; result != null && !condition.test(result); result = result.previous()) {
        }
        return Optional.ofNullable(result);
    }

    public AggregateRoot<T> apply(Message var1);

    default public AggregateRoot<T> apply(Object event) {
        return this.apply(new Message(event));
    }

    default public AggregateRoot<T> apply(Object event, Metadata metadata) {
        return this.apply(new Message(event, metadata));
    }

    public AggregateRoot<T> update(UnaryOperator<T> var1);

    default public <E extends Exception> AggregateRoot<T> assertLegal(Object command) throws E {
        ValidationUtils.assertLegal(command, this);
        return this;
    }

    public <E extends Exception> AggregateRoot<T> assertLegal(Object ... var1) throws E;

    default public <E extends Exception> AggregateRoot<T> assertThat(Validator<T, E> validator) throws E {
        validator.validate(this.get());
        return this;
    }

    default public <E extends Exception> AggregateRoot<T> ensure(Predicate<T> check, Function<T, E> errorProvider) throws E {
        if (!check.test(this.get())) {
            throw (Exception)errorProvider.apply(this.get());
        }
        return this;
    }

    @FunctionalInterface
    public static interface Validator<T, E extends Exception> {
        public void validate(T var1) throws E;
    }
}

