/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking;

import io.fluxcapacitor.common.TimingUtils;
import io.fluxcapacitor.javaclient.common.exception.FunctionalException;
import io.fluxcapacitor.javaclient.tracking.ErrorHandler;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryingErrorHandler
implements ErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(RetryingErrorHandler.class);
    private final int retries;
    private final Duration delay;
    private final Predicate<Exception> errorFilter;
    private final boolean throwOnFailure;
    private final boolean logFunctionalErrors;

    public static RetryingErrorHandler forAnyError() {
        return new RetryingErrorHandler(e -> true);
    }

    public RetryingErrorHandler(Predicate<Exception> errorFilter) {
        this(5, Duration.ofSeconds(2L), errorFilter, false, true);
    }

    @Override
    public void handleError(Exception error, String errorMessage, Runnable retryFunction) throws Exception {
        if (!this.errorFilter.test(error)) {
            this.logError(String.format("%s. Not retrying, %s", errorMessage, this.throwOnFailure ? "propagating error" : "continuing."), error);
            if (this.throwOnFailure) {
                throw error;
            }
            return;
        }
        this.logError(String.format("%s. Retrying up to %s times.", errorMessage, this.retries), error);
        AtomicInteger remainingRetries = new AtomicInteger(this.retries);
        boolean success = TimingUtils.retryOnFailure((Runnable)retryFunction, (Duration)this.delay, e -> this.errorFilter.test((Exception)e) && remainingRetries.decrementAndGet() > 0);
        if (success) {
            log.info("Message handling was successful on retry");
        } else {
            if (this.throwOnFailure) {
                this.logMessage("Propagating error", this.isTechnicalError(error));
                throw error;
            }
            this.logMessage(String.format("%s. Not retrying any further. Continuing with next handler.", errorMessage), this.isTechnicalError(error));
        }
    }

    protected void logError(String errorMessage, Exception error) {
        if (this.isTechnicalError(error)) {
            log.error("{}. Continuing...", (Object)errorMessage, (Object)error);
        } else if (this.logFunctionalErrors) {
            log.warn("{}. Continuing...", (Object)errorMessage, (Object)error);
        }
    }

    protected void logMessage(String errorMessage, boolean severe) {
        if (severe) {
            log.error(errorMessage);
        } else if (this.logFunctionalErrors) {
            log.warn(errorMessage);
        }
    }

    protected boolean isTechnicalError(Exception error) {
        return !(error instanceof FunctionalException);
    }

    @ConstructorProperties(value={"retries", "delay", "errorFilter", "throwOnFailure", "logFunctionalErrors"})
    public RetryingErrorHandler(int retries, Duration delay, Predicate<Exception> errorFilter, boolean throwOnFailure, boolean logFunctionalErrors) {
        this.retries = retries;
        this.delay = delay;
        this.errorFilter = errorFilter;
        this.throwOnFailure = throwOnFailure;
        this.logFunctionalErrors = logFunctionalErrors;
    }
}

