/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common;

import io.fluxcapacitor.javaclient.tracking.handling.LocalHandler;
import java.lang.reflect.Executable;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientUtils {
    private static final Logger log = LoggerFactory.getLogger(ClientUtils.class);

    public static void waitForResults(Duration maxDuration, Collection<? extends Future<?>> futures) {
        Instant deadline = Instant.now().plus(maxDuration);
        for (Future<?> f : futures) {
            try {
                f.get(Math.max(0L, Duration.between(Instant.now(), deadline).toMillis()), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn("Thread was interrupted before receiving all expected results", (Throwable)e);
                return;
            }
            catch (TimeoutException e) {
                log.warn("Timed out before having received all expected results", (Throwable)e);
                return;
            }
            catch (ExecutionException executionException) {
            }
        }
    }

    public static void tryRun(Runnable task) {
        try {
            task.run();
        }
        catch (Exception e) {
            log.warn("Task {} failed", (Object)task, (Object)e);
        }
    }

    public static boolean isLocalHandlerMethod(Class<?> target, Executable method) {
        LocalHandler localHandler = method.getAnnotation(LocalHandler.class);
        if (localHandler == null) {
            localHandler = target.getAnnotation(LocalHandler.class);
        }
        return localHandler != null && localHandler.value();
    }
}

