/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.configuration;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.ClientUtils;
import io.fluxcapacitor.javaclient.common.IdentityProvider;
import io.fluxcapacitor.javaclient.common.UuidFactory;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.MessageSerializer;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.common.serialization.jackson.JacksonSerializer;
import io.fluxcapacitor.javaclient.configuration.FluxCapacitorBuilder;
import io.fluxcapacitor.javaclient.configuration.client.Client;
import io.fluxcapacitor.javaclient.modeling.AggregateRepository;
import io.fluxcapacitor.javaclient.modeling.CompositeAggregateRepository;
import io.fluxcapacitor.javaclient.persisting.caching.Cache;
import io.fluxcapacitor.javaclient.persisting.caching.CachingAggregateRepository;
import io.fluxcapacitor.javaclient.persisting.caching.DefaultCache;
import io.fluxcapacitor.javaclient.persisting.caching.SelectiveCache;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.DefaultAggregateRepository;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.DefaultEventSourcingHandlerFactory;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.DefaultEventStore;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.DefaultSnapshotRepository;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.EventStore;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.EventStoreSerializer;
import io.fluxcapacitor.javaclient.persisting.keyvalue.DefaultKeyValueStore;
import io.fluxcapacitor.javaclient.persisting.keyvalue.KeyValueStore;
import io.fluxcapacitor.javaclient.persisting.search.DefaultDocumentStore;
import io.fluxcapacitor.javaclient.persisting.search.DocumentSerializer;
import io.fluxcapacitor.javaclient.persisting.search.DocumentStore;
import io.fluxcapacitor.javaclient.publishing.CommandGateway;
import io.fluxcapacitor.javaclient.publishing.DefaultCommandGateway;
import io.fluxcapacitor.javaclient.publishing.DefaultErrorGateway;
import io.fluxcapacitor.javaclient.publishing.DefaultEventGateway;
import io.fluxcapacitor.javaclient.publishing.DefaultGenericGateway;
import io.fluxcapacitor.javaclient.publishing.DefaultMetricsGateway;
import io.fluxcapacitor.javaclient.publishing.DefaultQueryGateway;
import io.fluxcapacitor.javaclient.publishing.DefaultRequestHandler;
import io.fluxcapacitor.javaclient.publishing.DefaultResultGateway;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import io.fluxcapacitor.javaclient.publishing.ErrorGateway;
import io.fluxcapacitor.javaclient.publishing.EventGateway;
import io.fluxcapacitor.javaclient.publishing.GenericGateway;
import io.fluxcapacitor.javaclient.publishing.MetricsGateway;
import io.fluxcapacitor.javaclient.publishing.QueryGateway;
import io.fluxcapacitor.javaclient.publishing.RequestHandler;
import io.fluxcapacitor.javaclient.publishing.ResultGateway;
import io.fluxcapacitor.javaclient.publishing.correlation.CorrelatingInterceptor;
import io.fluxcapacitor.javaclient.publishing.dataprotection.DataProtectionInterceptor;
import io.fluxcapacitor.javaclient.publishing.routing.MessageRoutingInterceptor;
import io.fluxcapacitor.javaclient.scheduling.DefaultScheduler;
import io.fluxcapacitor.javaclient.scheduling.Scheduler;
import io.fluxcapacitor.javaclient.scheduling.SchedulingInterceptor;
import io.fluxcapacitor.javaclient.tracking.BatchInterceptor;
import io.fluxcapacitor.javaclient.tracking.ConsumerConfiguration;
import io.fluxcapacitor.javaclient.tracking.DefaultTracking;
import io.fluxcapacitor.javaclient.tracking.Tracking;
import io.fluxcapacitor.javaclient.tracking.TrackingException;
import io.fluxcapacitor.javaclient.tracking.handling.DefaultHandlerFactory;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerInterceptor;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerRegistry;
import io.fluxcapacitor.javaclient.tracking.handling.LocalHandlerRegistry;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.AuthenticatingInterceptor;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.UserProvider;
import io.fluxcapacitor.javaclient.tracking.handling.errorreporting.ErrorReportingInterceptor;
import io.fluxcapacitor.javaclient.tracking.handling.validation.ValidatingInterceptor;
import io.fluxcapacitor.javaclient.tracking.metrics.HandlerMonitor;
import io.fluxcapacitor.javaclient.tracking.metrics.TrackerMonitor;
import java.beans.ConstructorProperties;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFluxCapacitor
implements FluxCapacitor {
    private static final Logger log = LoggerFactory.getLogger(DefaultFluxCapacitor.class);
    private final Map<MessageType, ? extends Tracking> trackingSupplier;
    private final CommandGateway commandGateway;
    private final QueryGateway queryGateway;
    private final EventGateway eventGateway;
    private final ResultGateway resultGateway;
    private final ErrorGateway errorGateway;
    private final MetricsGateway metricsGateway;
    private final AggregateRepository aggregateRepository;
    private final EventStore eventStore;
    private final KeyValueStore keyValueStore;
    private final DocumentStore documentStore;
    private final Scheduler scheduler;
    private final UserProvider userProvider;
    private final Cache cache;
    private final Serializer serializer;
    private final AtomicReference<Clock> clock = new AtomicReference<Clock>(Clock.systemUTC());
    private final AtomicReference<IdentityProvider> identityProvider = new AtomicReference<UuidFactory>(new UuidFactory());
    private final Client client;
    private final Runnable shutdownHandler;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Collection<Runnable> cleanupTasks = new CopyOnWriteArrayList<Runnable>();

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Tracking tracking(MessageType messageType) {
        return Optional.ofNullable(this.trackingSupplier.get(messageType)).orElseThrow(() -> new TrackingException(String.format("Tracking is not supported for type %s", messageType)));
    }

    @Override
    public void withClock(@NonNull Clock clock) {
        if (clock == null) {
            throw new NullPointerException("clock is marked non-null but is null");
        }
        this.clock.set(clock);
    }

    @Override
    public Clock clock() {
        return this.clock.get();
    }

    @Override
    public void withIdentityProvider(@NonNull IdentityProvider identityProvider) {
        if (identityProvider == null) {
            throw new NullPointerException("identityProvider is marked non-null but is null");
        }
        this.identityProvider.set(identityProvider);
    }

    @Override
    public IdentityProvider identityProvider() {
        return this.identityProvider.get();
    }

    @Override
    public Registration beforeShutdown(Runnable task) {
        this.cleanupTasks.add(task);
        return () -> this.cleanupTasks.remove(task);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            log.info("Initiating controlled shutdown");
            this.cleanupTasks.forEach(ClientUtils::tryRun);
            this.shutdownHandler.run();
            if (FluxCapacitor.applicationInstance.get() == this) {
                FluxCapacitor.applicationInstance.set(null);
            }
            log.info("Completed shutdown");
        }
    }

    @ConstructorProperties(value={"trackingSupplier", "commandGateway", "queryGateway", "eventGateway", "resultGateway", "errorGateway", "metricsGateway", "aggregateRepository", "eventStore", "keyValueStore", "documentStore", "scheduler", "userProvider", "cache", "serializer", "client", "shutdownHandler"})
    protected DefaultFluxCapacitor(Map<MessageType, ? extends Tracking> trackingSupplier, CommandGateway commandGateway, QueryGateway queryGateway, EventGateway eventGateway, ResultGateway resultGateway, ErrorGateway errorGateway, MetricsGateway metricsGateway, AggregateRepository aggregateRepository, EventStore eventStore, KeyValueStore keyValueStore, DocumentStore documentStore, Scheduler scheduler, UserProvider userProvider, Cache cache, Serializer serializer, Client client, Runnable shutdownHandler) {
        this.trackingSupplier = trackingSupplier;
        this.commandGateway = commandGateway;
        this.queryGateway = queryGateway;
        this.eventGateway = eventGateway;
        this.resultGateway = resultGateway;
        this.errorGateway = errorGateway;
        this.metricsGateway = metricsGateway;
        this.aggregateRepository = aggregateRepository;
        this.eventStore = eventStore;
        this.keyValueStore = keyValueStore;
        this.documentStore = documentStore;
        this.scheduler = scheduler;
        this.userProvider = userProvider;
        this.cache = cache;
        this.serializer = serializer;
        this.client = client;
        this.shutdownHandler = shutdownHandler;
    }

    public Map<MessageType, ? extends Tracking> trackingSupplier() {
        return this.trackingSupplier;
    }

    @Override
    public CommandGateway commandGateway() {
        return this.commandGateway;
    }

    @Override
    public QueryGateway queryGateway() {
        return this.queryGateway;
    }

    @Override
    public EventGateway eventGateway() {
        return this.eventGateway;
    }

    @Override
    public ResultGateway resultGateway() {
        return this.resultGateway;
    }

    @Override
    public ErrorGateway errorGateway() {
        return this.errorGateway;
    }

    @Override
    public MetricsGateway metricsGateway() {
        return this.metricsGateway;
    }

    @Override
    public AggregateRepository aggregateRepository() {
        return this.aggregateRepository;
    }

    @Override
    public EventStore eventStore() {
        return this.eventStore;
    }

    @Override
    public KeyValueStore keyValueStore() {
        return this.keyValueStore;
    }

    @Override
    public DocumentStore documentStore() {
        return this.documentStore;
    }

    @Override
    public Scheduler scheduler() {
        return this.scheduler;
    }

    @Override
    public UserProvider userProvider() {
        return this.userProvider;
    }

    @Override
    public Cache cache() {
        return this.cache;
    }

    @Override
    public Serializer serializer() {
        return this.serializer;
    }

    @Override
    public Client client() {
        return this.client;
    }

    public Runnable shutdownHandler() {
        return this.shutdownHandler;
    }

    public AtomicBoolean closed() {
        return this.closed;
    }

    public Collection<Runnable> cleanupTasks() {
        return this.cleanupTasks;
    }

    public static class Builder
    implements FluxCapacitorBuilder {
        private Serializer serializer;
        private Serializer snapshotSerializer;
        private DocumentSerializer documentSerializer;
        private final Map<MessageType, List<ConsumerConfiguration>> consumerConfigurations;
        private final List<ParameterResolver<? super DeserializingMessage>> parameterResolvers;
        private final Map<MessageType, DispatchInterceptor> dispatchInterceptors;
        private final Map<MessageType, HandlerInterceptor> handlerInterceptors;
        private final Map<MessageType, List<BatchInterceptor>> batchInterceptors;
        private DispatchInterceptor messageRoutingInterceptor;
        private SchedulingInterceptor schedulingInterceptor;
        private Cache cache;
        private boolean disableErrorReporting;
        private boolean disableMessageCorrelation;
        private boolean disablePayloadValidation;
        private boolean disableDataProtection;
        private boolean disableAutomaticAggregateCaching;
        private boolean disableShutdownHook;
        private boolean collectTrackingMetrics;
        private boolean makeApplicationInstance;
        private UserProvider userProvider;

        public Builder() {
            this.snapshotSerializer = this.serializer = new JacksonSerializer();
            this.documentSerializer = (JacksonSerializer)this.serializer;
            this.consumerConfigurations = this.defaultConfigurations();
            this.parameterResolvers = new ArrayList<ParameterResolver<? super DeserializingMessage>>(DeserializingMessage.defaultParameterResolvers);
            this.dispatchInterceptors = Arrays.stream(MessageType.values()).collect(Collectors.toMap(Function.identity(), m -> (f, messageType) -> f));
            this.handlerInterceptors = Arrays.stream(MessageType.values()).collect(Collectors.toMap(Function.identity(), m -> (f, h, c) -> f));
            this.batchInterceptors = new HashMap<MessageType, List<BatchInterceptor>>();
            this.messageRoutingInterceptor = new MessageRoutingInterceptor();
            this.schedulingInterceptor = new SchedulingInterceptor();
            this.cache = new DefaultCache();
            this.userProvider = UserProvider.defaultUserSupplier;
        }

        protected Map<MessageType, List<ConsumerConfiguration>> defaultConfigurations() {
            return Collections.unmodifiableMap(Arrays.stream(MessageType.values()).collect(Collectors.toMap(Function.identity(), messageType -> new ArrayList<ConsumerConfiguration>(Collections.singletonList(ConsumerConfiguration.getDefault(messageType))))));
        }

        @Override
        public Builder replaceSerializer(@NonNull Serializer serializer) {
            if (serializer == null) {
                throw new NullPointerException("serializer is marked non-null but is null");
            }
            if (this.snapshotSerializer == this.serializer) {
                this.snapshotSerializer = serializer;
            }
            if (this.documentSerializer == this.serializer && serializer instanceof DocumentSerializer) {
                this.documentSerializer = (DocumentSerializer)((Object)serializer);
            }
            this.serializer = serializer;
            return this;
        }

        @Override
        public Builder replaceSnapshotSerializer(@NonNull Serializer serializer) {
            if (serializer == null) {
                throw new NullPointerException("serializer is marked non-null but is null");
            }
            this.snapshotSerializer = serializer;
            return this;
        }

        @Override
        public FluxCapacitorBuilder replaceDocumentSerializer(@NonNull DocumentSerializer documentSerializer) {
            if (documentSerializer == null) {
                throw new NullPointerException("documentSerializer is marked non-null but is null");
            }
            this.documentSerializer = documentSerializer;
            return this;
        }

        @Override
        public FluxCapacitorBuilder registerUserSupplier(@NonNull UserProvider userProvider) {
            if (userProvider == null) {
                throw new NullPointerException("userProvider is marked non-null but is null");
            }
            this.userProvider = userProvider;
            return this;
        }

        @Override
        public Builder configureDefaultConsumer(@NonNull MessageType messageType, @NonNull UnaryOperator<ConsumerConfiguration> updateFunction) {
            if (messageType == null) {
                throw new NullPointerException("messageType is marked non-null but is null");
            }
            if (updateFunction == null) {
                throw new NullPointerException("updateFunction is marked non-null but is null");
            }
            List<ConsumerConfiguration> configurations = this.consumerConfigurations.get(messageType);
            ConsumerConfiguration defaultConfiguration = configurations.get(configurations.size() - 1);
            ConsumerConfiguration updatedConfiguration = (ConsumerConfiguration)updateFunction.apply(defaultConfiguration);
            if (configurations.subList(0, configurations.size() - 1).stream().map(ConsumerConfiguration::getName).anyMatch(n -> Objects.equals(n, updatedConfiguration.getName()))) {
                throw new IllegalArgumentException(String.format("Consumer name %s is already in use", updatedConfiguration.getName()));
            }
            configurations.set(configurations.size() - 1, updatedConfiguration);
            return this;
        }

        @Override
        public Builder addConsumerConfiguration(@NonNull ConsumerConfiguration consumerConfiguration) {
            if (consumerConfiguration == null) {
                throw new NullPointerException("consumerConfiguration is marked non-null but is null");
            }
            List<ConsumerConfiguration> configurations = this.consumerConfigurations.get(consumerConfiguration.getMessageType());
            if (configurations.stream().map(ConsumerConfiguration::getName).anyMatch(n -> Objects.equals(n, consumerConfiguration.getName()))) {
                throw new IllegalArgumentException(String.format("Consumer name %s is already in use", consumerConfiguration.getName()));
            }
            configurations.add(configurations.size() - 1, consumerConfiguration);
            return this;
        }

        @Override
        public FluxCapacitorBuilder addBatchInterceptor(BatchInterceptor interceptor, MessageType ... forTypes) {
            Arrays.stream(forTypes.length == 0 ? MessageType.values() : forTypes).forEach(type -> this.batchInterceptors.computeIfAbsent((MessageType)type, t -> new ArrayList()).add(interceptor));
            return this;
        }

        @Override
        public Builder addDispatchInterceptor(@NonNull DispatchInterceptor interceptor, MessageType ... forTypes) {
            if (interceptor == null) {
                throw new NullPointerException("interceptor is marked non-null but is null");
            }
            Arrays.stream(forTypes.length == 0 ? MessageType.values() : forTypes).forEach(type -> this.dispatchInterceptors.computeIfPresent((MessageType)type, (t, i) -> i.merge(interceptor)));
            return this;
        }

        @Override
        public Builder addHandlerInterceptor(@NonNull HandlerInterceptor interceptor, MessageType ... forTypes) {
            if (interceptor == null) {
                throw new NullPointerException("interceptor is marked non-null but is null");
            }
            Arrays.stream(forTypes.length == 0 ? MessageType.values() : forTypes).forEach(type -> this.handlerInterceptors.computeIfPresent((MessageType)type, (t, i) -> i.merge(interceptor)));
            return this;
        }

        @Override
        public Builder replaceMessageRoutingInterceptor(@NonNull DispatchInterceptor messageRoutingInterceptor) {
            if (messageRoutingInterceptor == null) {
                throw new NullPointerException("messageRoutingInterceptor is marked non-null but is null");
            }
            this.messageRoutingInterceptor = messageRoutingInterceptor;
            return this;
        }

        @Override
        public FluxCapacitorBuilder replaceCache(@NonNull Cache cache) {
            if (cache == null) {
                throw new NullPointerException("cache is marked non-null but is null");
            }
            this.cache = cache;
            return this;
        }

        @Override
        public FluxCapacitorBuilder withAggregateCache(Class<?> aggregateType, Cache cache) {
            this.cache = new SelectiveCache(cache, SelectiveCache.aggregateSelector(aggregateType), this.cache);
            return this;
        }

        @Override
        public Builder addParameterResolver(@NonNull ParameterResolver<DeserializingMessage> parameterResolver) {
            if (parameterResolver == null) {
                throw new NullPointerException("parameterResolver is marked non-null but is null");
            }
            this.parameterResolvers.add(parameterResolver);
            return this;
        }

        @Override
        public FluxCapacitorBuilder disableErrorReporting() {
            this.disableErrorReporting = true;
            return this;
        }

        @Override
        public FluxCapacitorBuilder disableShutdownHook() {
            this.disableShutdownHook = true;
            return this;
        }

        @Override
        public Builder disableMessageCorrelation() {
            this.disableMessageCorrelation = true;
            return this;
        }

        @Override
        public Builder disablePayloadValidation() {
            this.disablePayloadValidation = true;
            return this;
        }

        @Override
        public FluxCapacitorBuilder disableDataProtection() {
            this.disableDataProtection = true;
            return this;
        }

        @Override
        public FluxCapacitorBuilder disableAutomaticAggregateCaching() {
            this.disableAutomaticAggregateCaching = true;
            return this;
        }

        @Override
        public FluxCapacitorBuilder enableTrackingMetrics() {
            this.collectTrackingMetrics = true;
            return this;
        }

        @Override
        public FluxCapacitorBuilder makeApplicationInstance(boolean makeApplicationInstance) {
            this.makeApplicationInstance = makeApplicationInstance;
            return this;
        }

        @Override
        public FluxCapacitor build(@NonNull Client client) {
            HandlerInterceptor interceptor;
            if (client == null) {
                throw new NullPointerException("client is marked non-null but is null");
            }
            HashMap<MessageType, DispatchInterceptor> dispatchInterceptors = new HashMap<MessageType, DispatchInterceptor>(this.dispatchInterceptors);
            HashMap<MessageType, HandlerInterceptor> handlerInterceptors = new HashMap<MessageType, HandlerInterceptor>(this.handlerInterceptors);
            HashMap<MessageType, List<BatchInterceptor>> batchInterceptors = new HashMap<MessageType, List<BatchInterceptor>>(this.batchInterceptors);
            HashMap<MessageType, List<ConsumerConfiguration>> consumerConfigurations = new HashMap<MessageType, List<ConsumerConfiguration>>(this.consumerConfigurations);
            DefaultKeyValueStore keyValueStore = new DefaultKeyValueStore(client.getKeyValueClient(), this.serializer);
            DefaultDocumentStore documentStore = new DefaultDocumentStore(client.getSearchClient(), this.documentSerializer);
            Arrays.stream(MessageType.values()).forEach(type -> dispatchInterceptors.computeIfPresent((MessageType)type, (t, i) -> i.merge(this.messageRoutingInterceptor)));
            if (this.userProvider != null) {
                interceptor = new AuthenticatingInterceptor(this.userProvider);
                Stream.of(MessageType.COMMAND, MessageType.QUERY, MessageType.SCHEDULE).forEach(arg_0 -> Builder.lambda$build$17(dispatchInterceptors, (AuthenticatingInterceptor)interceptor, handlerInterceptors, arg_0));
            }
            if (!this.disableDataProtection) {
                interceptor = new DataProtectionInterceptor(keyValueStore, this.serializer);
                Stream.of(MessageType.COMMAND, MessageType.EVENT, MessageType.QUERY, MessageType.RESULT, MessageType.SCHEDULE).forEach(arg_0 -> Builder.lambda$build$20(dispatchInterceptors, (DataProtectionInterceptor)interceptor, handlerInterceptors, arg_0));
            }
            if (!this.disableMessageCorrelation) {
                CorrelatingInterceptor correlatingInterceptor = new CorrelatingInterceptor();
                Arrays.stream(MessageType.values()).forEach(type -> dispatchInterceptors.compute((MessageType)type, (t, i) -> correlatingInterceptor.merge((DispatchInterceptor)i)));
            }
            if (!this.disablePayloadValidation) {
                Stream.of(MessageType.COMMAND, MessageType.QUERY).forEach(type -> handlerInterceptors.computeIfPresent((MessageType)type, (t, i) -> i.merge(new ValidatingInterceptor())));
            }
            dispatchInterceptors.computeIfPresent(MessageType.SCHEDULE, (t, i) -> i.merge(this.schedulingInterceptor));
            handlerInterceptors.computeIfPresent(MessageType.SCHEDULE, (t, i) -> i.merge(this.schedulingInterceptor));
            if (this.collectTrackingMetrics) {
                TrackerMonitor batchInterceptor = new TrackerMonitor();
                HandlerMonitor handlerMonitor = new HandlerMonitor();
                Arrays.stream(MessageType.values()).forEach(type -> {
                    consumerConfigurations.computeIfPresent((MessageType)type, (t, list) -> t == MessageType.METRICS ? list : list.stream().map(c -> c.toBuilder().batchInterceptor(batchInterceptor).build()).collect(Collectors.toList()));
                    handlerInterceptors.compute((MessageType)type, (t, i) -> t == MessageType.METRICS ? i : handlerMonitor.merge((HandlerInterceptor)i));
                });
            }
            DefaultEventSourcingHandlerFactory eventSourcingHandlerFactory = new DefaultEventSourcingHandlerFactory(this.parameterResolvers);
            EventStoreSerializer eventStoreSerializer = new EventStoreSerializer(this.serializer, (DispatchInterceptor)dispatchInterceptors.get(MessageType.EVENT));
            DefaultEventStore eventStore = new DefaultEventStore(client.getEventStoreClient(), eventStoreSerializer, this.localHandlerRegistry(MessageType.EVENT, handlerInterceptors));
            DefaultSnapshotRepository snapshotRepository = new DefaultSnapshotRepository(client.getKeyValueClient(), this.snapshotSerializer);
            AggregateRepository aggregateRepository = new CompositeAggregateRepository(new DefaultAggregateRepository(eventStore, snapshotRepository, this.cache, documentStore, eventStoreSerializer, eventSourcingHandlerFactory));
            if (!this.disableAutomaticAggregateCaching) {
                aggregateRepository = new CachingAggregateRepository(aggregateRepository, eventSourcingHandlerFactory, this.cache, client, this.serializer);
            }
            DefaultErrorGateway errorGateway = new DefaultErrorGateway(client.getGatewayClient(MessageType.ERROR), this.messageSerializer(MessageType.ERROR, dispatchInterceptors), this.localHandlerRegistry(MessageType.ERROR, handlerInterceptors));
            if (!this.disableErrorReporting) {
                ErrorReportingInterceptor interceptor2 = new ErrorReportingInterceptor(errorGateway);
                Arrays.stream(MessageType.values()).forEach(type -> handlerInterceptors.compute((MessageType)type, (t, i) -> interceptor2.merge((HandlerInterceptor)i)));
            }
            DefaultResultGateway resultGateway = new DefaultResultGateway(client.getGatewayClient(MessageType.RESULT), this.messageSerializer(MessageType.RESULT, dispatchInterceptors));
            DefaultRequestHandler requestHandler = new DefaultRequestHandler(this.serializer, client);
            DefaultCommandGateway commandGateway = new DefaultCommandGateway(this.createRequestGateway(client, MessageType.COMMAND, requestHandler, dispatchInterceptors, handlerInterceptors));
            DefaultQueryGateway queryGateway = new DefaultQueryGateway(this.createRequestGateway(client, MessageType.QUERY, requestHandler, dispatchInterceptors, handlerInterceptors));
            DefaultEventGateway eventGateway = new DefaultEventGateway(client.getGatewayClient(MessageType.EVENT), this.messageSerializer(MessageType.EVENT, dispatchInterceptors), this.localHandlerRegistry(MessageType.EVENT, handlerInterceptors));
            DefaultMetricsGateway metricsGateway = new DefaultMetricsGateway(client.getGatewayClient(MessageType.METRICS), this.messageSerializer(MessageType.METRICS, dispatchInterceptors));
            batchInterceptors.forEach((type, interceptors) -> consumerConfigurations.computeIfPresent((MessageType)type, (t, configs) -> configs.stream().map(c -> c.toBuilder().batchInterceptors((Collection<? extends BatchInterceptor>)interceptors).build()).collect(Collectors.toList())));
            Map<MessageType, Tracking> trackingMap = Arrays.stream(MessageType.values()).collect(Collectors.toMap(Function.identity(), m -> new DefaultTracking((MessageType)m, client, resultGateway, (List)consumerConfigurations.get(m), this.serializer, new DefaultHandlerFactory((MessageType)m, (HandlerInterceptor)handlerInterceptors.get(m == MessageType.NOTIFICATION ? MessageType.EVENT : m), this.parameterResolvers))));
            DefaultScheduler scheduler = new DefaultScheduler(client.getSchedulingClient(), this.messageSerializer(MessageType.SCHEDULE, dispatchInterceptors), this.localHandlerRegistry(MessageType.SCHEDULE, handlerInterceptors));
            Runnable shutdownHandler = () -> {
                ForkJoinPool.commonPool().invokeAll(trackingMap.values().stream().map(t -> () -> {
                    t.close();
                    return null;
                }).collect(Collectors.toList()));
                requestHandler.close();
                client.shutDown();
            };
            FluxCapacitor fluxCapacitor = this.doBuild(trackingMap, commandGateway, queryGateway, eventGateway, resultGateway, errorGateway, metricsGateway, aggregateRepository, eventStore, keyValueStore, documentStore, scheduler, this.userProvider, this.cache, this.serializer, client, shutdownHandler);
            if (this.makeApplicationInstance) {
                FluxCapacitor.applicationInstance.set(fluxCapacitor);
            }
            if (!this.disableShutdownHook) {
                Runtime.getRuntime().addShutdownHook(new Thread(fluxCapacitor::close));
            }
            return fluxCapacitor;
        }

        protected FluxCapacitor doBuild(Map<MessageType, ? extends Tracking> trackingSupplier, CommandGateway commandGateway, QueryGateway queryGateway, EventGateway eventGateway, ResultGateway resultGateway, ErrorGateway errorGateway, MetricsGateway metricsGateway, AggregateRepository aggregateRepository, EventStore eventStore, KeyValueStore keyValueStore, DocumentStore documentStore, Scheduler scheduler, UserProvider userProvider, Cache cache, Serializer serializer, Client client, Runnable shutdownHandler) {
            return new DefaultFluxCapacitor(trackingSupplier, commandGateway, queryGateway, eventGateway, resultGateway, errorGateway, metricsGateway, aggregateRepository, eventStore, keyValueStore, documentStore, scheduler, userProvider, cache, serializer, client, shutdownHandler);
        }

        protected GenericGateway createRequestGateway(Client client, MessageType messageType, RequestHandler requestHandler, Map<MessageType, DispatchInterceptor> dispatchInterceptors, Map<MessageType, HandlerInterceptor> handlerInterceptors) {
            return new DefaultGenericGateway(client.getGatewayClient(messageType), requestHandler, this.messageSerializer(messageType, dispatchInterceptors), this.localHandlerRegistry(messageType, handlerInterceptors));
        }

        protected MessageSerializer messageSerializer(MessageType messageType, Map<MessageType, DispatchInterceptor> dispatchInterceptors) {
            return new MessageSerializer(this.serializer, dispatchInterceptors.get(messageType), messageType);
        }

        protected HandlerRegistry localHandlerRegistry(MessageType messageType, Map<MessageType, HandlerInterceptor> handlerInterceptors) {
            LocalHandlerRegistry result = new LocalHandlerRegistry(messageType, new DefaultHandlerFactory(messageType, handlerInterceptors.get(messageType), this.parameterResolvers), this.serializer);
            return messageType == MessageType.EVENT ? result.merge(new LocalHandlerRegistry(MessageType.NOTIFICATION, new DefaultHandlerFactory(MessageType.NOTIFICATION, handlerInterceptors.get(MessageType.EVENT), this.parameterResolvers), this.serializer)) : result;
        }

        private static /* synthetic */ void lambda$build$20(Map dispatchInterceptors, DataProtectionInterceptor interceptor, Map handlerInterceptors, MessageType type) {
            dispatchInterceptors.computeIfPresent(type, (t, i) -> i.merge(interceptor));
            handlerInterceptors.computeIfPresent(type, (t, i) -> i.merge(interceptor));
        }

        private static /* synthetic */ void lambda$build$17(Map dispatchInterceptors, AuthenticatingInterceptor interceptor, Map handlerInterceptors, MessageType type) {
            dispatchInterceptors.computeIfPresent(type, (t, i) -> i.merge(interceptor));
            handlerInterceptors.computeIfPresent(type, (t, i) -> i.merge(interceptor));
        }
    }
}

