/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.caching;

import io.fluxcapacitor.javaclient.modeling.AggregateRoot;
import io.fluxcapacitor.javaclient.persisting.caching.Cache;
import io.fluxcapacitor.javaclient.persisting.caching.DefaultCache;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public class SelectiveCache
implements Cache {
    private final Cache delegate;
    private final Predicate<Object> selector;
    private final Cache nextCache;

    public static Predicate<Object> aggregateSelector(Class<?> type) {
        return v -> {
            if (v instanceof AggregateRoot) {
                AggregateRoot aggregateRoot = (AggregateRoot)v;
                return Optional.ofNullable(aggregateRoot.get()).map(r -> type.isAssignableFrom(r.getClass())).orElseGet(() -> type.isAssignableFrom(aggregateRoot.type()));
            }
            return false;
        };
    }

    public SelectiveCache(Cache nextCache, Predicate<Object> selector) {
        this(new DefaultCache(), selector, nextCache);
    }

    @Override
    public void put(String id, Object value) {
        if (this.selector.test(value)) {
            this.delegate.put(id, value);
        } else {
            this.nextCache.put(id, value);
        }
    }

    @Override
    public <T> T get(String id, Function<? super String, T> mappingFunction) {
        T result = this.getIfPresent(id);
        if (result == null) {
            result = mappingFunction.apply(id);
            this.put(id, result);
        }
        return result;
    }

    @Override
    public <T> T getIfPresent(String id) {
        return (T)Optional.ofNullable(this.delegate.getIfPresent(id)).orElseGet(() -> this.nextCache.getIfPresent(id));
    }

    @Override
    public void invalidate(String id) {
        this.delegate.invalidate(id);
        this.nextCache.invalidate(id);
    }

    @Override
    public void invalidateAll() {
        this.delegate.invalidateAll();
        this.nextCache.invalidateAll();
    }

    @ConstructorProperties(value={"delegate", "selector", "nextCache"})
    public SelectiveCache(Cache delegate, Predicate<Object> selector, Cache nextCache) {
        this.delegate = delegate;
        this.selector = selector;
        this.nextCache = nextCache;
    }
}

