/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling.validation;

import io.fluxcapacitor.javaclient.common.exception.FunctionalException;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ElementKind;
import jakarta.validation.Path;
import java.beans.ConstructorProperties;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;

public class ValidationException
extends FunctionalException {
    private final SortedSet<String> violations;

    public ValidationException(Collection<? extends ConstraintViolation<?>> violations) {
        super(ValidationException.format(violations, false).stream().collect(Collectors.joining(System.lineSeparator())));
        this.violations = ValidationException.format(violations, true);
    }

    @ConstructorProperties(value={"message", "violations"})
    public ValidationException(String message, Set<String> violations) {
        super(message);
        this.violations = new TreeSet<String>(violations);
    }

    protected static SortedSet<String> format(Collection<? extends ConstraintViolation<?>> violations, boolean fullPath) {
        return violations.stream().map(v -> ValidationException.format(v, fullPath)).collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER)));
    }

    protected static String format(ConstraintViolation<?> v, boolean fullPath) {
        try {
            ConstraintDescriptorImpl constraintDescriptor = (ConstraintDescriptorImpl)v.getConstraintDescriptor();
            Method method = constraintDescriptor.getAnnotationType().getDeclaredMethod("message", new Class[0]);
            Object defaultMessage = method.getDefaultValue();
            if (!Objects.equals(defaultMessage, method.invoke((Object)constraintDescriptor.getAnnotation(), new Object[0]))) {
                return v.getMessage();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return String.format("%s %s", ValidationException.getPropertyPath(v, fullPath), v.getMessage());
    }

    protected static String getPropertyPath(ConstraintViolation<?> v, boolean full) {
        if (full) {
            return v.getPropertyPath().toString();
        }
        List path = StreamSupport.stream(v.getPropertyPath().spliterator(), false).collect(Collectors.toList());
        if ((path = path.stream().skip(Math.max(0, path.size() - 2)).collect(Collectors.toList())).isEmpty()) {
            return v.getPropertyPath().toString();
        }
        if (path.size() == 2) {
            Path.Node a = (Path.Node)path.get(0);
            Path.Node b = (Path.Node)path.get(1);
            return b.isInIterable() && b.getKind() != ElementKind.CONTAINER_ELEMENT ? b.getName() : String.format("%s %s", a.getName(), b.getKind() == ElementKind.CONTAINER_ELEMENT ? "element" : b.getName());
        }
        return ((Path.Node)path.get(0)).getName();
    }

    public SortedSet<String> getViolations() {
        return this.violations;
    }
}

