/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.serialization;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingObject;
import io.fluxcapacitor.javaclient.common.serialization.MessageFormatter;
import io.fluxcapacitor.javaclient.modeling.AggregateIdResolver;
import io.fluxcapacitor.javaclient.modeling.AggregateTypeResolver;
import io.fluxcapacitor.javaclient.scheduling.Schedule;
import io.fluxcapacitor.javaclient.tracking.handling.DeserializingMessageParameterResolver;
import io.fluxcapacitor.javaclient.tracking.handling.MessageParameterResolver;
import io.fluxcapacitor.javaclient.tracking.handling.MetadataParameterResolver;
import io.fluxcapacitor.javaclient.tracking.handling.PayloadParameterResolver;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.UserParameterResolver;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DeserializingMessage {
    private static final Logger log = LoggerFactory.getLogger(DeserializingMessage.class);
    public static MessageFormatter messageFormatter = MessageFormatter.DEFAULT;
    public static List<ParameterResolver<? super DeserializingMessage>> defaultParameterResolvers = Arrays.asList(new DeserializingMessageParameterResolver(), new MetadataParameterResolver(), new MessageParameterResolver(), new AggregateIdResolver(), new AggregateTypeResolver(), new UserParameterResolver(), new PayloadParameterResolver());
    private static final ThreadLocal<Collection<Runnable>> messageCompletionHandlers = new ThreadLocal();
    private static final ThreadLocal<Collection<Runnable>> batchCompletionHandlers = new ThreadLocal();
    private static final ThreadLocal<Map<Object, Object>> batchResources = new ThreadLocal();
    private static final ThreadLocal<DeserializingMessage> current = new ThreadLocal();
    private final DeserializingObject<byte[], SerializedMessage> delegate;
    private final MessageType messageType;

    public DeserializingMessage(SerializedMessage message, Function<Class<?>, Object> payload, MessageType messageType) {
        this(new DeserializingObject<byte[], SerializedMessage>(message, payload), messageType);
    }

    public void run(Consumer<DeserializingMessage> task) {
        this.apply(m -> {
            task.accept((DeserializingMessage)m);
            return null;
        });
    }

    public <T> T apply(Function<DeserializingMessage, T> action) {
        return DeserializingMessage.handleBatch(Stream.of(this)).map(action).collect(Collectors.toList()).get(0);
    }

    public Metadata getMetadata() {
        return this.delegate.getSerializedObject().getMetadata();
    }

    public Message toMessage() {
        if (this.getMetadata().containsKey(Schedule.scheduleIdMetadataKey)) {
            return new Schedule(this.delegate.getPayload(), this.getMetadata(), this.delegate.getSerializedObject().getMessageId(), Instant.ofEpochMilli(this.delegate.getSerializedObject().getTimestamp()), this.getMetadata().get(Schedule.scheduleIdMetadataKey), FluxCapacitor.currentClock().instant());
        }
        return new Message(this.delegate.getPayload(), this.getMetadata(), this.delegate.getSerializedObject().getMessageId(), Instant.ofEpochMilli(this.delegate.getSerializedObject().getTimestamp()));
    }

    public static DeserializingMessage getCurrent() {
        return current.get();
    }

    public static Registration whenBatchCompletes(Runnable handler) {
        if (current.get() == null) {
            try {
                Registration registration = Registration.noOp();
                return registration;
            }
            finally {
                handler.run();
            }
        }
        if (batchCompletionHandlers.get() == null) {
            batchCompletionHandlers.set(new ArrayList());
        }
        Collection<Runnable> handlers = batchCompletionHandlers.get();
        handlers.add(handler);
        return () -> handlers.remove(handler);
    }

    public static void whenMessageCompletes(Runnable handler) {
        if (current.get() == null) {
            handler.run();
            return;
        }
        if (messageCompletionHandlers.get() == null) {
            messageCompletionHandlers.set(new ArrayList());
        }
        Collection<Runnable> handlers = messageCompletionHandlers.get();
        handlers.add(handler);
    }

    public static Stream<DeserializingMessage> handleBatch(Stream<DeserializingMessage> batch) {
        return StreamSupport.stream(new MessageSpliterator(batch.spliterator()), false);
    }

    public static <K, V> V computeForBatch(K key, BiFunction<? super K, ? super V, ? extends V> function) {
        return DeserializingMessage.getResources().compute(key, function);
    }

    public static <K, V> V computeForBatchIfAbsent(K key, Function<? super K, ? extends V> function) {
        return DeserializingMessage.getResources().computeIfAbsent(key, function);
    }

    public static <V> V getBatchResource(Object key) {
        return (V)DeserializingMessage.getResources().get(key);
    }

    private static Map<Object, Object> getResources() {
        if (batchResources.get() == null) {
            batchResources.set(new HashMap());
        }
        return batchResources.get();
    }

    public String toString() {
        return (String)messageFormatter.apply(this);
    }

    private static void setCurrent(DeserializingMessage message) {
        current.set(message);
        if (message == null) {
            Optional.ofNullable(messageCompletionHandlers.get()).ifPresent(handlers -> {
                messageCompletionHandlers.remove();
                handlers.forEach(Runnable::run);
            });
        }
    }

    public DeserializingObject<byte[], SerializedMessage> getDelegate() {
        return this.delegate;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeserializingMessage)) {
            return false;
        }
        DeserializingMessage other = (DeserializingMessage)o;
        DeserializingObject<byte[], SerializedMessage> this$delegate = this.getDelegate();
        DeserializingObject<byte[], SerializedMessage> other$delegate = other.getDelegate();
        if (this$delegate == null ? other$delegate != null : !this$delegate.equals(other$delegate)) {
            return false;
        }
        MessageType this$messageType = this.getMessageType();
        MessageType other$messageType = other.getMessageType();
        return !(this$messageType == null ? other$messageType != null : !this$messageType.equals(other$messageType));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DeserializingObject<byte[], SerializedMessage> $delegate = this.getDelegate();
        result = result * 59 + ($delegate == null ? 43 : $delegate.hashCode());
        MessageType $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : $messageType.hashCode());
        return result;
    }

    @ConstructorProperties(value={"delegate", "messageType"})
    public DeserializingMessage(DeserializingObject<byte[], SerializedMessage> delegate, MessageType messageType) {
        this.delegate = delegate;
        this.messageType = messageType;
    }

    public <V> V getPayload() {
        return this.getDelegate().getPayload();
    }

    public <V> V getPayloadAs(Class<V> type) {
        return this.getDelegate().getPayloadAs(type);
    }

    public boolean isDeserialized() {
        return this.getDelegate().isDeserialized();
    }

    public String getType() {
        return this.getDelegate().getType();
    }

    public int getRevision() {
        return this.getDelegate().getRevision();
    }

    public SerializedMessage getSerializedObject() {
        return this.getDelegate().getSerializedObject();
    }

    public Class<?> getPayloadClass() {
        return this.getDelegate().getPayloadClass();
    }

    private static class MessageSpliterator
    extends Spliterators.AbstractSpliterator<DeserializingMessage> {
        private final Spliterator<DeserializingMessage> upStream;

        public MessageSpliterator(Spliterator<DeserializingMessage> upStream) {
            super(upStream.estimateSize(), upStream.characteristics());
            this.upStream = upStream;
        }

        @Override
        public boolean tryAdvance(Consumer<? super DeserializingMessage> action) {
            boolean hadNext = this.upStream.tryAdvance((? super T d) -> {
                DeserializingMessage previous = DeserializingMessage.getCurrent();
                try {
                    DeserializingMessage.setCurrent(d);
                    action.accept((DeserializingMessage)d);
                }
                finally {
                    DeserializingMessage.setCurrent(previous);
                }
            });
            if (!hadNext && DeserializingMessage.getCurrent() == null) {
                try {
                    Optional.ofNullable(batchCompletionHandlers.get()).ifPresent(handlers -> {
                        batchCompletionHandlers.remove();
                        handlers.forEach(Runnable::run);
                    });
                }
                finally {
                    batchResources.remove();
                    batchCompletionHandlers.remove();
                }
            }
            return hadNext;
        }
    }
}

