/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.configuration.client;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.serialization.compression.CompressionAlgorithm;
import io.fluxcapacitor.javaclient.common.websocket.ServiceUrlBuilder;
import io.fluxcapacitor.javaclient.configuration.client.AbstractClient;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.client.WebSocketEventStoreClient;
import io.fluxcapacitor.javaclient.persisting.keyvalue.client.WebsocketKeyValueClient;
import io.fluxcapacitor.javaclient.persisting.search.client.WebSocketSearchClient;
import io.fluxcapacitor.javaclient.publishing.client.WebsocketGatewayClient;
import io.fluxcapacitor.javaclient.scheduling.client.WebsocketSchedulingClient;
import io.fluxcapacitor.javaclient.tracking.client.WebsocketTrackingClient;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;

public class WebSocketClient
extends AbstractClient {
    private final Properties properties;

    public static WebSocketClient newInstance(Properties properties) {
        return new WebSocketClient(properties);
    }

    protected WebSocketClient(Properties properties) {
        super(properties.getName(), properties.getId(), type -> new WebsocketGatewayClient(ServiceUrlBuilder.producerUrl(type, properties), properties, (MessageType)type), type -> new WebsocketTrackingClient(ServiceUrlBuilder.consumerUrl(type, properties), properties, (MessageType)type), new WebSocketEventStoreClient(ServiceUrlBuilder.eventSourcingUrl(properties), properties), new WebsocketSchedulingClient(ServiceUrlBuilder.schedulingUrl(properties), properties), new WebsocketKeyValueClient(ServiceUrlBuilder.keyValueUrl(properties), properties), new WebSocketSearchClient(ServiceUrlBuilder.searchUrl(properties), properties));
        this.properties = properties;
    }

    @Override
    public void shutDown() {
        super.shutDown();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public static final class Properties {
        @NonNull
        private final String serviceBaseUrl;
        @NonNull
        private final String name;
        @NonNull
        private final String id;
        private final CompressionAlgorithm compression;
        private final int eventSourcingSessions;
        private final int keyValueSessions;
        private final int searchSessions;
        private final Map<MessageType, Integer> gatewaySessions;
        private final Map<MessageType, Integer> trackingSessions;
        private final String projectId;
        private final String typeFilter;

        Properties withGatewaySessions(MessageType messageType, int count) {
            HashMap<MessageType, Integer> config = new HashMap<MessageType, Integer>(this.gatewaySessions);
            config.put(messageType, count);
            return this.toBuilder().gatewaySessions(config).build();
        }

        Properties withTrackingSessions(MessageType messageType, int count) {
            HashMap<MessageType, Integer> config = new HashMap<MessageType, Integer>(this.trackingSessions);
            config.put(messageType, count);
            return this.toBuilder().trackingSessions(config).build();
        }

        private static Map<MessageType, Integer> defaultGatewaySessions() {
            return Arrays.stream(MessageType.values()).collect(Collectors.toMap(Function.identity(), t -> 1));
        }

        private static Map<MessageType, Integer> defaultTrackingSessions() {
            return Arrays.stream(MessageType.values()).collect(Collectors.toMap(Function.identity(), t -> 1));
        }

        private static String $default$id() {
            return UUID.randomUUID().toString();
        }

        private static CompressionAlgorithm $default$compression() {
            return CompressionAlgorithm.LZ4;
        }

        private static int $default$eventSourcingSessions() {
            return 2;
        }

        private static int $default$keyValueSessions() {
            return 2;
        }

        private static int $default$searchSessions() {
            return 2;
        }

        private static Map<MessageType, Integer> $default$gatewaySessions() {
            return Properties.defaultGatewaySessions();
        }

        private static Map<MessageType, Integer> $default$trackingSessions() {
            return Properties.defaultTrackingSessions();
        }

        @ConstructorProperties(value={"serviceBaseUrl", "name", "id", "compression", "eventSourcingSessions", "keyValueSessions", "searchSessions", "gatewaySessions", "trackingSessions", "projectId", "typeFilter"})
        Properties(@NonNull String serviceBaseUrl, @NonNull String name, @NonNull String id, CompressionAlgorithm compression, int eventSourcingSessions, int keyValueSessions, int searchSessions, Map<MessageType, Integer> gatewaySessions, Map<MessageType, Integer> trackingSessions, String projectId, String typeFilter) {
            if (serviceBaseUrl == null) {
                throw new NullPointerException("serviceBaseUrl is marked non-null but is null");
            }
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.serviceBaseUrl = serviceBaseUrl;
            this.name = name;
            this.id = id;
            this.compression = compression;
            this.eventSourcingSessions = eventSourcingSessions;
            this.keyValueSessions = keyValueSessions;
            this.searchSessions = searchSessions;
            this.gatewaySessions = gatewaySessions;
            this.trackingSessions = trackingSessions;
            this.projectId = projectId;
            this.typeFilter = typeFilter;
        }

        public static PropertiesBuilder builder() {
            return new PropertiesBuilder();
        }

        public PropertiesBuilder toBuilder() {
            return new PropertiesBuilder().serviceBaseUrl(this.serviceBaseUrl).name(this.name).id(this.id).compression(this.compression).eventSourcingSessions(this.eventSourcingSessions).keyValueSessions(this.keyValueSessions).searchSessions(this.searchSessions).gatewaySessions(this.gatewaySessions).trackingSessions(this.trackingSessions).projectId(this.projectId).typeFilter(this.typeFilter);
        }

        @NonNull
        public String getServiceBaseUrl() {
            return this.serviceBaseUrl;
        }

        @NonNull
        public String getName() {
            return this.name;
        }

        @NonNull
        public String getId() {
            return this.id;
        }

        public CompressionAlgorithm getCompression() {
            return this.compression;
        }

        public int getEventSourcingSessions() {
            return this.eventSourcingSessions;
        }

        public int getKeyValueSessions() {
            return this.keyValueSessions;
        }

        public int getSearchSessions() {
            return this.searchSessions;
        }

        public Map<MessageType, Integer> getGatewaySessions() {
            return this.gatewaySessions;
        }

        public Map<MessageType, Integer> getTrackingSessions() {
            return this.trackingSessions;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public String getTypeFilter() {
            return this.typeFilter;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Properties)) {
                return false;
            }
            Properties other = (Properties)o;
            if (this.getEventSourcingSessions() != other.getEventSourcingSessions()) {
                return false;
            }
            if (this.getKeyValueSessions() != other.getKeyValueSessions()) {
                return false;
            }
            if (this.getSearchSessions() != other.getSearchSessions()) {
                return false;
            }
            String this$serviceBaseUrl = this.getServiceBaseUrl();
            String other$serviceBaseUrl = other.getServiceBaseUrl();
            if (this$serviceBaseUrl == null ? other$serviceBaseUrl != null : !this$serviceBaseUrl.equals(other$serviceBaseUrl)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            CompressionAlgorithm this$compression = this.getCompression();
            CompressionAlgorithm other$compression = other.getCompression();
            if (this$compression == null ? other$compression != null : !this$compression.equals(other$compression)) {
                return false;
            }
            Map<MessageType, Integer> this$gatewaySessions = this.getGatewaySessions();
            Map<MessageType, Integer> other$gatewaySessions = other.getGatewaySessions();
            if (this$gatewaySessions == null ? other$gatewaySessions != null : !((Object)this$gatewaySessions).equals(other$gatewaySessions)) {
                return false;
            }
            Map<MessageType, Integer> this$trackingSessions = this.getTrackingSessions();
            Map<MessageType, Integer> other$trackingSessions = other.getTrackingSessions();
            if (this$trackingSessions == null ? other$trackingSessions != null : !((Object)this$trackingSessions).equals(other$trackingSessions)) {
                return false;
            }
            String this$projectId = this.getProjectId();
            String other$projectId = other.getProjectId();
            if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
                return false;
            }
            String this$typeFilter = this.getTypeFilter();
            String other$typeFilter = other.getTypeFilter();
            return !(this$typeFilter == null ? other$typeFilter != null : !this$typeFilter.equals(other$typeFilter));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getEventSourcingSessions();
            result = result * 59 + this.getKeyValueSessions();
            result = result * 59 + this.getSearchSessions();
            String $serviceBaseUrl = this.getServiceBaseUrl();
            result = result * 59 + ($serviceBaseUrl == null ? 43 : $serviceBaseUrl.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            CompressionAlgorithm $compression = this.getCompression();
            result = result * 59 + ($compression == null ? 43 : $compression.hashCode());
            Map<MessageType, Integer> $gatewaySessions = this.getGatewaySessions();
            result = result * 59 + ($gatewaySessions == null ? 43 : ((Object)$gatewaySessions).hashCode());
            Map<MessageType, Integer> $trackingSessions = this.getTrackingSessions();
            result = result * 59 + ($trackingSessions == null ? 43 : ((Object)$trackingSessions).hashCode());
            String $projectId = this.getProjectId();
            result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
            String $typeFilter = this.getTypeFilter();
            result = result * 59 + ($typeFilter == null ? 43 : $typeFilter.hashCode());
            return result;
        }

        public String toString() {
            return "WebSocketClient.Properties(serviceBaseUrl=" + this.getServiceBaseUrl() + ", name=" + this.getName() + ", id=" + this.getId() + ", compression=" + this.getCompression() + ", eventSourcingSessions=" + this.getEventSourcingSessions() + ", keyValueSessions=" + this.getKeyValueSessions() + ", searchSessions=" + this.getSearchSessions() + ", gatewaySessions=" + this.getGatewaySessions() + ", trackingSessions=" + this.getTrackingSessions() + ", projectId=" + this.getProjectId() + ", typeFilter=" + this.getTypeFilter() + ")";
        }

        public static class PropertiesBuilder {
            private String serviceBaseUrl;
            private String name;
            private boolean id$set;
            private String id$value;
            private boolean compression$set;
            private CompressionAlgorithm compression$value;
            private boolean eventSourcingSessions$set;
            private int eventSourcingSessions$value;
            private boolean keyValueSessions$set;
            private int keyValueSessions$value;
            private boolean searchSessions$set;
            private int searchSessions$value;
            private boolean gatewaySessions$set;
            private Map<MessageType, Integer> gatewaySessions$value;
            private boolean trackingSessions$set;
            private Map<MessageType, Integer> trackingSessions$value;
            private String projectId;
            private String typeFilter;

            PropertiesBuilder() {
            }

            public PropertiesBuilder serviceBaseUrl(@NonNull String serviceBaseUrl) {
                if (serviceBaseUrl == null) {
                    throw new NullPointerException("serviceBaseUrl is marked non-null but is null");
                }
                this.serviceBaseUrl = serviceBaseUrl;
                return this;
            }

            public PropertiesBuilder name(@NonNull String name) {
                if (name == null) {
                    throw new NullPointerException("name is marked non-null but is null");
                }
                this.name = name;
                return this;
            }

            public PropertiesBuilder id(@NonNull String id) {
                if (id == null) {
                    throw new NullPointerException("id is marked non-null but is null");
                }
                this.id$value = id;
                this.id$set = true;
                return this;
            }

            public PropertiesBuilder compression(CompressionAlgorithm compression) {
                this.compression$value = compression;
                this.compression$set = true;
                return this;
            }

            public PropertiesBuilder eventSourcingSessions(int eventSourcingSessions) {
                this.eventSourcingSessions$value = eventSourcingSessions;
                this.eventSourcingSessions$set = true;
                return this;
            }

            public PropertiesBuilder keyValueSessions(int keyValueSessions) {
                this.keyValueSessions$value = keyValueSessions;
                this.keyValueSessions$set = true;
                return this;
            }

            public PropertiesBuilder searchSessions(int searchSessions) {
                this.searchSessions$value = searchSessions;
                this.searchSessions$set = true;
                return this;
            }

            public PropertiesBuilder gatewaySessions(Map<MessageType, Integer> gatewaySessions) {
                this.gatewaySessions$value = gatewaySessions;
                this.gatewaySessions$set = true;
                return this;
            }

            public PropertiesBuilder trackingSessions(Map<MessageType, Integer> trackingSessions) {
                this.trackingSessions$value = trackingSessions;
                this.trackingSessions$set = true;
                return this;
            }

            public PropertiesBuilder projectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            public PropertiesBuilder typeFilter(String typeFilter) {
                this.typeFilter = typeFilter;
                return this;
            }

            public Properties build() {
                String id$value = this.id$value;
                if (!this.id$set) {
                    id$value = Properties.$default$id();
                }
                CompressionAlgorithm compression$value = this.compression$value;
                if (!this.compression$set) {
                    compression$value = Properties.$default$compression();
                }
                int eventSourcingSessions$value = this.eventSourcingSessions$value;
                if (!this.eventSourcingSessions$set) {
                    eventSourcingSessions$value = Properties.$default$eventSourcingSessions();
                }
                int keyValueSessions$value = this.keyValueSessions$value;
                if (!this.keyValueSessions$set) {
                    keyValueSessions$value = Properties.$default$keyValueSessions();
                }
                int searchSessions$value = this.searchSessions$value;
                if (!this.searchSessions$set) {
                    searchSessions$value = Properties.$default$searchSessions();
                }
                Map<MessageType, Integer> gatewaySessions$value = this.gatewaySessions$value;
                if (!this.gatewaySessions$set) {
                    gatewaySessions$value = Properties.$default$gatewaySessions();
                }
                Map<MessageType, Integer> trackingSessions$value = this.trackingSessions$value;
                if (!this.trackingSessions$set) {
                    trackingSessions$value = Properties.$default$trackingSessions();
                }
                return new Properties(this.serviceBaseUrl, this.name, id$value, compression$value, eventSourcingSessions$value, keyValueSessions$value, searchSessions$value, gatewaySessions$value, trackingSessions$value, this.projectId, this.typeFilter);
            }

            public String toString() {
                return "WebSocketClient.Properties.PropertiesBuilder(serviceBaseUrl=" + this.serviceBaseUrl + ", name=" + this.name + ", id$value=" + this.id$value + ", compression$value=" + this.compression$value + ", eventSourcingSessions$value=" + this.eventSourcingSessions$value + ", keyValueSessions$value=" + this.keyValueSessions$value + ", searchSessions$value=" + this.searchSessions$value + ", gatewaySessions$value=" + this.gatewaySessions$value + ", trackingSessions$value=" + this.trackingSessions$value + ", projectId=" + this.projectId + ", typeFilter=" + this.typeFilter + ")";
            }
        }
    }
}

