/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.scheduling;

import io.fluxcapacitor.common.IndexUtils;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.scheduling.ScheduledMessage;
import io.fluxcapacitor.common.handling.HandlerConfiguration;
import io.fluxcapacitor.javaclient.common.serialization.MessageSerializer;
import io.fluxcapacitor.javaclient.scheduling.Schedule;
import io.fluxcapacitor.javaclient.scheduling.Scheduler;
import io.fluxcapacitor.javaclient.scheduling.SchedulerException;
import io.fluxcapacitor.javaclient.scheduling.client.SchedulingClient;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerRegistry;
import java.beans.ConstructorProperties;
import java.time.Instant;

public class DefaultScheduler
implements Scheduler {
    private final SchedulingClient client;
    private final MessageSerializer serializer;
    private final HandlerRegistry localHandlerRegistry;

    @Override
    public void schedule(Schedule message, boolean ifAbsent) {
        try {
            SerializedMessage serializedMessage = this.serializer.serialize(message);
            this.client.schedule(new ScheduledMessage(message.getScheduleId(), message.getDeadline().toEpochMilli(), serializedMessage, ifAbsent)).await();
        }
        catch (Exception e) {
            throw new SchedulerException(String.format("Failed to schedule message %s for %s", message.getPayload(), message.getDeadline()), e);
        }
    }

    @Override
    public void cancelSchedule(String scheduleId) {
        try {
            this.client.cancelSchedule(scheduleId).await();
        }
        catch (Exception e) {
            throw new SchedulerException(String.format("Failed to cancel schedule with id %s", scheduleId), e);
        }
    }

    public Registration registerHandler(Object target, HandlerConfiguration handlerConfiguration) {
        return this.localHandlerRegistry.registerHandler(target, handlerConfiguration);
    }

    public void handleLocally(Schedule schedule, SerializedMessage serializedMessage) {
        serializedMessage.setIndex(Long.valueOf(IndexUtils.indexFromTimestamp((Instant)schedule.getDeadline())));
        this.localHandlerRegistry.handle(schedule.getPayload(), serializedMessage);
    }

    @ConstructorProperties(value={"client", "serializer", "localHandlerRegistry"})
    public DefaultScheduler(SchedulingClient client, MessageSerializer serializer, HandlerRegistry localHandlerRegistry) {
        this.client = client;
        this.serializer = serializer;
        this.localHandlerRegistry = localHandlerRegistry;
    }
}

