/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.scheduling;

import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.Message;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.time.Instant;
import lombok.NonNull;

public final class Schedule
extends Message {
    public static String scheduleIdMetadataKey = "$scheduleId";
    @NonNull
    private final String scheduleId;
    @NonNull
    private final Instant deadline;

    public Schedule(Object payload, String scheduleId, Instant deadline) {
        super(payload);
        this.scheduleId = scheduleId;
        this.deadline = deadline;
    }

    public Schedule(Object payload, Metadata metadata, String scheduleId, Instant deadline) {
        super(payload, metadata);
        this.scheduleId = scheduleId;
        this.deadline = deadline;
    }

    @ConstructorProperties(value={"payload", "metadata", "messageId", "timestamp", "scheduleId", "deadline"})
    public Schedule(Object payload, Metadata metadata, String messageId, Instant timestamp, String scheduleId, Instant deadline) {
        super(payload, metadata, messageId, timestamp);
        this.scheduleId = scheduleId;
        this.deadline = deadline;
    }

    @Override
    public Schedule withPayload(Object payload) {
        return new Schedule(payload, this.getMetadata(), this.getMessageId(), this.getTimestamp(), this.scheduleId, this.deadline);
    }

    @Override
    public Schedule withMetadata(Metadata metadata) {
        return new Schedule(this.getPayload(), metadata, this.getMessageId(), this.getTimestamp(), this.scheduleId, this.deadline);
    }

    public Schedule reschedule(Duration duration) {
        return new Schedule(this.getPayload(), this.getMetadata(), FluxCapacitor.generateId(), FluxCapacitor.currentClock().instant(), this.scheduleId, this.deadline.plus(duration));
    }

    @NonNull
    public String getScheduleId() {
        return this.scheduleId;
    }

    @NonNull
    public Instant getDeadline() {
        return this.deadline;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Schedule)) {
            return false;
        }
        Schedule other = (Schedule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$scheduleId = this.getScheduleId();
        String other$scheduleId = other.getScheduleId();
        if (this$scheduleId == null ? other$scheduleId != null : !this$scheduleId.equals(other$scheduleId)) {
            return false;
        }
        Instant this$deadline = this.getDeadline();
        Instant other$deadline = other.getDeadline();
        return !(this$deadline == null ? other$deadline != null : !((Object)this$deadline).equals(other$deadline));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Schedule;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $scheduleId = this.getScheduleId();
        result = result * 59 + ($scheduleId == null ? 43 : $scheduleId.hashCode());
        Instant $deadline = this.getDeadline();
        result = result * 59 + ($deadline == null ? 43 : ((Object)$deadline).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "Schedule(super=" + super.toString() + ", scheduleId=" + this.getScheduleId() + ", deadline=" + this.getDeadline() + ")";
    }
}

