/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.common.handling.HandlerConfiguration;
import io.fluxcapacitor.common.handling.HandlerInspector;
import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.configuration.ConfigurationException;
import io.fluxcapacitor.javaclient.tracking.handling.HandleCommand;
import io.fluxcapacitor.javaclient.tracking.handling.HandleError;
import io.fluxcapacitor.javaclient.tracking.handling.HandleEvent;
import io.fluxcapacitor.javaclient.tracking.handling.HandleMetrics;
import io.fluxcapacitor.javaclient.tracking.handling.HandleNotification;
import io.fluxcapacitor.javaclient.tracking.handling.HandleQuery;
import io.fluxcapacitor.javaclient.tracking.handling.HandleResult;
import io.fluxcapacitor.javaclient.tracking.handling.HandleSchedule;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerFactory;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerInterceptor;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;

public class DefaultHandlerFactory
implements HandlerFactory {
    private final MessageType messageType;
    private final HandlerInterceptor handlerInterceptor;
    private final List<ParameterResolver<? super DeserializingMessage>> parameterResolvers;

    @Override
    public Optional<Handler<DeserializingMessage>> createHandler(Object target, String consumer, HandlerConfiguration handlerConfiguration) {
        Class<? extends Annotation> methodAnnotation = DefaultHandlerFactory.getHandlerAnnotation(this.messageType);
        if (HandlerInspector.hasHandlerMethods(target.getClass(), methodAnnotation, (HandlerConfiguration)handlerConfiguration)) {
            return Optional.of(this.handlerInterceptor.wrap((Handler<DeserializingMessage>)HandlerInspector.createHandler((Object)target, methodAnnotation, this.parameterResolvers, (HandlerConfiguration)handlerConfiguration), consumer));
        }
        return Optional.empty();
    }

    private static Class<? extends Annotation> getHandlerAnnotation(MessageType messageType) {
        switch (messageType) {
            case COMMAND: {
                return HandleCommand.class;
            }
            case EVENT: {
                return HandleEvent.class;
            }
            case NOTIFICATION: {
                return HandleNotification.class;
            }
            case QUERY: {
                return HandleQuery.class;
            }
            case RESULT: {
                return HandleResult.class;
            }
            case ERROR: {
                return HandleError.class;
            }
            case SCHEDULE: {
                return HandleSchedule.class;
            }
            case METRICS: {
                return HandleMetrics.class;
            }
        }
        throw new ConfigurationException(String.format("Unrecognized type: %s", messageType));
    }

    @ConstructorProperties(value={"messageType", "handlerInterceptor", "parameterResolvers"})
    public DefaultHandlerFactory(MessageType messageType, HandlerInterceptor handlerInterceptor, List<ParameterResolver<? super DeserializingMessage>> parameterResolvers) {
        this.messageType = messageType;
        this.handlerInterceptor = handlerInterceptor;
        this.parameterResolvers = parameterResolvers;
    }
}

