/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.javaclient.common.IdentityProvider;
import io.fluxcapacitor.javaclient.common.UuidFactory;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.configuration.client.Client;
import io.fluxcapacitor.javaclient.modeling.AggregateIdResolver;
import io.fluxcapacitor.javaclient.modeling.AggregateRepository;
import io.fluxcapacitor.javaclient.modeling.AggregateRoot;
import io.fluxcapacitor.javaclient.persisting.caching.Cache;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.EventStore;
import io.fluxcapacitor.javaclient.persisting.keyvalue.KeyValueStore;
import io.fluxcapacitor.javaclient.persisting.search.DocumentStore;
import io.fluxcapacitor.javaclient.persisting.search.Search;
import io.fluxcapacitor.javaclient.publishing.CommandGateway;
import io.fluxcapacitor.javaclient.publishing.ErrorGateway;
import io.fluxcapacitor.javaclient.publishing.EventGateway;
import io.fluxcapacitor.javaclient.publishing.MetricsGateway;
import io.fluxcapacitor.javaclient.publishing.QueryGateway;
import io.fluxcapacitor.javaclient.publishing.ResultGateway;
import io.fluxcapacitor.javaclient.publishing.correlation.CorrelationDataProvider;
import io.fluxcapacitor.javaclient.publishing.correlation.DefaultCorrelationDataProvider;
import io.fluxcapacitor.javaclient.scheduling.Scheduler;
import io.fluxcapacitor.javaclient.tracking.Tracking;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.UserProvider;
import java.time.Clock;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public interface FluxCapacitor
extends AutoCloseable {
    public static final AtomicReference<FluxCapacitor> applicationInstance = new AtomicReference();
    public static final ThreadLocal<FluxCapacitor> instance = new ThreadLocal();
    public static final CorrelationDataProvider correlationDataProvider = new DefaultCorrelationDataProvider();

    public static FluxCapacitor get() {
        return Optional.ofNullable(instance.get()).orElseGet(() -> Optional.ofNullable(applicationInstance.get()).orElseThrow(() -> new IllegalStateException("FluxCapacitor instance not set")));
    }

    public static Optional<FluxCapacitor> getOptionally() {
        FluxCapacitor result = instance.get();
        return result == null ? Optional.ofNullable(applicationInstance.get()) : Optional.of(result);
    }

    public static Clock currentClock() {
        return FluxCapacitor.getOptionally().map(FluxCapacitor::clock).orElseGet(Clock::systemUTC);
    }

    public static String generateId() {
        return FluxCapacitor.getOptionally().map(FluxCapacitor::identityProvider).orElseGet(UuidFactory::new).nextId();
    }

    public static Map<String, String> currentCorrelationData() {
        return correlationDataProvider.getCorrelationData();
    }

    public static void publishEvent(Object event) {
        FluxCapacitor.get().eventGateway().publish(event);
    }

    public static void publishEvent(Object payload, Metadata metadata) {
        FluxCapacitor.get().eventGateway().publish(payload, metadata);
    }

    public static void sendAndForgetCommand(Object command) {
        FluxCapacitor.get().commandGateway().sendAndForget(command);
    }

    public static void sendAndForgetCommand(Object payload, Metadata metadata) {
        FluxCapacitor.get().commandGateway().sendAndForget(payload, metadata);
    }

    public static <R> CompletableFuture<R> sendCommand(Object command) {
        return FluxCapacitor.get().commandGateway().send(command);
    }

    public static <R> CompletableFuture<R> sendCommand(Object payload, Metadata metadata) {
        return FluxCapacitor.get().commandGateway().send(payload, metadata);
    }

    public static <R> R sendCommandAndWait(Object command) {
        return FluxCapacitor.get().commandGateway().sendAndWait(command);
    }

    public static <R> R sendCommandAndWait(Object payload, Metadata metadata) {
        return FluxCapacitor.get().commandGateway().sendAndWait(payload, metadata);
    }

    public static <R> CompletableFuture<R> query(Object query) {
        return FluxCapacitor.get().queryGateway().send(query);
    }

    public static <R> CompletableFuture<R> query(Object payload, Metadata metadata) {
        return FluxCapacitor.get().queryGateway().send(payload, metadata);
    }

    public static <R> R queryAndWait(Object query) {
        return FluxCapacitor.get().queryGateway().sendAndWait(query);
    }

    public static <R> R queryAndWait(Object payload, Metadata metadata) {
        return FluxCapacitor.get().queryGateway().sendAndWait(payload, metadata);
    }

    public static void schedule(Object schedule, String scheduleId, Instant deadline) {
        FluxCapacitor.get().scheduler().schedule(schedule, scheduleId, deadline);
    }

    public static void publishMetrics(Object metrics) {
        FluxCapacitor.get().metricsGateway().publish(metrics);
    }

    public static void publishMetrics(Object payload, Metadata metadata) {
        FluxCapacitor.get().metricsGateway().publish(payload, metadata);
    }

    public static <T> AggregateRoot<T> loadAggregate(String id, Class<T> aggregateType) {
        return FluxCapacitor.loadAggregate(id, aggregateType, Optional.ofNullable(DeserializingMessage.getCurrent()).map(d -> d.getMessageType() != MessageType.COMMAND).orElse(true));
    }

    public static <T> AggregateRoot<T> loadAggregate(String id, Class<T> aggregateType, boolean readOnly) {
        AggregateRoot<T> result = FluxCapacitor.get().aggregateRepository().load(id, aggregateType, readOnly, false);
        DeserializingMessage message = DeserializingMessage.getCurrent();
        if (message != null && (message.getMessageType() == MessageType.EVENT || message.getMessageType() == MessageType.NOTIFICATION) && id.equals(AggregateIdResolver.getAggregateId(message))) {
            return result.playBackToEvent(message.getSerializedObject().getMessageId());
        }
        return result;
    }

    public static void index(Object object, String id, String collection) {
        FluxCapacitor.get().documentStore().index(object, id, collection);
    }

    public static void index(Object object, String id, String collection, @Nullable Instant timestamp) {
        FluxCapacitor.get().documentStore().index(object, id, collection, timestamp);
    }

    public static void index(Object object, String id, String collection, @Nullable Instant timestamp, @Nullable Instant end) {
        FluxCapacitor.get().documentStore().index(object, id, collection, timestamp, end);
    }

    public static <T> void index(Collection<? extends T> objects, String collection, Function<? super T, String> idFunction, Function<? super T, Instant> timestampFunction, Function<? super T, Instant> endFunction) {
        FluxCapacitor.get().documentStore().index(objects, collection, idFunction, timestampFunction, endFunction);
    }

    public static Search search(String collection) {
        return FluxCapacitor.get().documentStore().search(collection);
    }

    default public Registration registerHandlers(Object ... handlers) {
        return this.registerHandlers(Arrays.asList(handlers));
    }

    default public Registration registerHandlers(List<?> handlers) {
        return this.apply(f -> {
            Registration tracking = Arrays.stream(MessageType.values()).map(t -> this.tracking((MessageType)t).start(this, handlers)).reduce(Registration::merge).orElse(Registration.noOp());
            Registration local = handlers.stream().flatMap(h -> Stream.of(this.commandGateway().registerHandler(h), this.queryGateway().registerHandler(h), this.eventGateway().registerHandler(h), this.eventStore().registerHandler(h), this.errorGateway().registerHandler(h))).reduce(Registration::merge).orElse(Registration.noOp());
            return tracking.merge(local);
        });
    }

    public void withClock(Clock var1);

    public void withIdentityProvider(IdentityProvider var1);

    public AggregateRepository aggregateRepository();

    public EventStore eventStore();

    public Scheduler scheduler();

    public CommandGateway commandGateway();

    public QueryGateway queryGateway();

    public EventGateway eventGateway();

    public ResultGateway resultGateway();

    public ErrorGateway errorGateway();

    public MetricsGateway metricsGateway();

    public Tracking tracking(MessageType var1);

    public KeyValueStore keyValueStore();

    public DocumentStore documentStore();

    public UserProvider userProvider();

    public Cache cache();

    public Serializer serializer();

    public Clock clock();

    public IdentityProvider identityProvider();

    public Client client();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <R> R apply(Function<FluxCapacitor, R> function) {
        FluxCapacitor current = instance.get();
        try {
            instance.set(this);
            R r = function.apply(this);
            return r;
        }
        finally {
            instance.set(current);
        }
    }

    default public void execute(Consumer<FluxCapacitor> task) {
        FluxCapacitor current = instance.get();
        try {
            instance.set(this);
            task.accept(this);
        }
        finally {
            instance.set(current);
        }
    }

    public Registration beforeShutdown(Runnable var1);

    @Override
    public void close();
}

