/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.common.handling.HandlerConfiguration;
import io.fluxcapacitor.javaclient.common.ClientUtils;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerFactory;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerRegistry;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalHandlerRegistry
implements HandlerRegistry {
    private static final Logger log = LoggerFactory.getLogger(LocalHandlerRegistry.class);
    private static final HandlerConfiguration localHandlerConfiguration = HandlerConfiguration.builder().handlerFilter(ClientUtils::isLocalHandlerMethod).build();
    private final MessageType messageType;
    private final HandlerFactory handlerFactory;
    private final Serializer serializer;
    private final List<Handler<DeserializingMessage>> localHandlers = new CopyOnWriteArrayList<Handler<DeserializingMessage>>();

    @Override
    public Registration registerHandler(Object target) {
        return this.registerHandler(target, localHandlerConfiguration);
    }

    @Override
    public Registration registerHandler(Object target, HandlerConfiguration handlerConfiguration) {
        Optional<Handler<DeserializingMessage>> handler = this.handlerFactory.createHandler(target, "local-" + this.messageType, handlerConfiguration);
        handler.ifPresent(this.localHandlers::add);
        return () -> handler.ifPresent(this.localHandlers::remove);
    }

    @Override
    public Optional<CompletableFuture<Message>> handle(Object payload, SerializedMessage serializedMessage) {
        if (!this.localHandlers.isEmpty()) {
            return new DeserializingMessage(serializedMessage, type -> this.serializer.convert(payload, type), this.messageType).apply(m -> {
                boolean handled = false;
                CompletionStage<Message> future = new CompletableFuture<Message>();
                for (Handler<DeserializingMessage> handler : this.localHandlers) {
                    if (!handler.canHandle(m)) continue;
                    boolean passive = handler.isPassive(m);
                    try {
                        Object result = handler.invoke(m);
                        if (passive || future.isDone()) continue;
                        if (result instanceof CompletableFuture) {
                            future = ((CompletableFuture)result).thenApply(Message::new);
                            continue;
                        }
                        future.complete(new Message(result));
                    }
                    catch (Exception e) {
                        if (passive) {
                            log.error("Passive local handler {} failed to handle a {}", new Object[]{handler, m.getPayloadClass(), e});
                            continue;
                        }
                        future.completeExceptionally(e);
                    }
                    finally {
                        if (passive) continue;
                        handled = true;
                    }
                }
                return handled ? Optional.of(future) : Optional.empty();
            });
        }
        return Optional.empty();
    }

    @ConstructorProperties(value={"messageType", "handlerFactory", "serializer"})
    public LocalHandlerRegistry(MessageType messageType, HandlerFactory handlerFactory, Serializer serializer) {
        this.messageType = messageType;
        this.handlerFactory = handlerFactory;
        this.serializer = serializer;
    }
}

