/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.serialization;

import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.common.api.SerializedObject;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.common.serialization.Revision;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingObject;
import io.fluxcapacitor.javaclient.common.serialization.SerializationException;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.common.serialization.upcasting.Upcaster;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSerializer
implements Serializer {
    private static final Logger log = LoggerFactory.getLogger(AbstractSerializer.class);
    private final Upcaster<SerializedObject<byte[], ?>> upcasterChain;
    private final String format;
    private final Map<String, String> typeCasters = new ConcurrentHashMap<String, String>();

    protected AbstractSerializer(Upcaster<SerializedObject<byte[], ?>> upcasterChain, String format) {
        this.upcasterChain = upcasterChain;
        this.format = format;
    }

    @Override
    public Data<byte[]> serialize(Object object, String format) {
        if (format == null) {
            format = this.format;
        }
        try {
            if (object instanceof Data) {
                Data data = (Data)object;
                if (data.getValue() instanceof byte[]) {
                    return data;
                }
                return new Data((Object)((byte[])this.serialize(data.getValue(), format).getValue()), data.getType(), data.getRevision(), format);
            }
            if (Objects.equals(this.format, format)) {
                return new Data((Object)this.doSerialize(object), this.asString(this.getType(object)), this.getRevision(object).map(Revision::value).orElse(0).intValue(), format);
            }
            return this.serializeToOtherFormat(object, format);
        }
        catch (Exception e) {
            throw new SerializationException(String.format("Could not serialize %s (format %s)", object, format), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Data<byte[]> serializeToOtherFormat(Object object, String format) {
        Data data;
        if (object instanceof String) {
            return new Data((Object)((String)object).getBytes(StandardCharsets.UTF_8), this.asString((Type)((Object)String.class)), 0, format);
        }
        if (object instanceof byte[]) {
            return new Data((Object)((byte[])object), this.asString((Type)((Object)byte[].class)), 0, format);
        }
        if (!(object instanceof InputStream)) throw new UnsupportedOperationException();
        try (InputStream inputStream = (InputStream)object;){
            data = new Data((Object)inputStream.readAllBytes(), this.asString((Type)((Object)byte[].class)), 0, format);
            if (inputStream == null) return data;
        }
        return data;
    }

    protected Type getType(Object object) {
        Set values;
        Map map;
        Set keys;
        if (object == null) {
            return Void.class;
        }
        Class<?> type = object.getClass();
        if (Collection.class.isAssignableFrom(type)) {
            Collection collection = (Collection)object;
            Set children = collection.stream().map(this::getType).collect(Collectors.toSet());
            if (children.size() == 1) {
                return TypeUtils.parameterize(type, (Type[])new Type[]{(Type)children.iterator().next()});
            }
        } else if (Map.class.isAssignableFrom(type) && (keys = (map = (Map)object).keySet().stream().map(this::getType).collect(Collectors.toSet())).size() == 1 && (values = map.values().stream().map(this::getType).collect(Collectors.toSet())).size() == 1) {
            return TypeUtils.parameterize(type, (Type[])new Type[]{(Type)keys.iterator().next(), (Type)values.iterator().next()});
        }
        return type;
    }

    protected String asString(Type type) {
        return type.getTypeName();
    }

    protected Optional<Revision> getRevision(Object object) {
        return Optional.ofNullable(object).map(o -> o.getClass().getAnnotation(Revision.class));
    }

    protected abstract byte[] doSerialize(Object var1) throws Exception;

    public <S extends SerializedObject<byte[], S>> Stream<DeserializingObject<byte[], S>> deserialize(Stream<S> dataStream, boolean failOnUnknownType) {
        return this.upcasterChain.upcast(dataStream).map(s -> {
            String upcastedType;
            String type = s.data().getType();
            return Objects.equals(type, upcastedType = this.upcastType(type)) ? s : s.withData(s.data().withType(upcastedType));
        }).flatMap(s -> {
            if (!Objects.equals(this.format, s.data().getFormat())) {
                return this.deserializeOtherFormat((SerializedObject<byte[], ?>)s);
            }
            if (s.data().getType() == null) {
                return this.deserializeUnknownType((SerializedObject<byte[], ?>)s);
            }
            if (!this.isKnownType(s.data().getType())) {
                if (failOnUnknownType) {
                    throw new SerializationException(String.format("Could not deserialize object. The serialized type is unknown: %s (rev. %d)", s.data().getType(), s.data().getRevision()));
                }
                return this.deserializeUnknownType((SerializedObject<byte[], ?>)s);
            }
            return Stream.of(new DeserializingObject((SerializedObject)s, type -> {
                try {
                    return Object.class.equals(type) ? this.doDeserialize((Data<byte[]>)s.data(), s.data().getType()) : this.doDeserialize((Data<byte[]>)s.data(), this.asString((Type)type));
                }
                catch (Exception e) {
                    throw new SerializationException("Could not deserialize a " + s.data().getType(), e);
                }
            }));
        });
    }

    @Override
    public <V> V convert(Object value, Class<V> type) {
        if (type == null || Object.class.equals(type)) {
            return (V)value;
        }
        return this.doConvert(value, type);
    }

    @Override
    public <V> V clone(Object value) {
        if (value == null || value.getClass().isPrimitive() || value instanceof String) {
            return null;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (value instanceof List) {
                return (V)new ArrayList(collection);
            }
            if (value instanceof SortedSet) {
                return (V)new TreeSet(collection);
            }
            if (value instanceof Set) {
                return (V)new LinkedHashSet(collection);
            }
            return (V)new LinkedList(collection);
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            if (value instanceof SortedMap) {
                return (V)new TreeMap(map);
            }
            return (V)new LinkedHashMap(map);
        }
        return (V)this.doClone(value);
    }

    @Override
    public Serializer registerTypeCaster(String oldType, String newType) {
        this.typeCasters.put(oldType, newType);
        return this;
    }

    @Override
    public String upcastType(String type) {
        if (type == null) {
            return null;
        }
        String result = this.typeCasters.get(type);
        if (result == null || Objects.equals(result, type)) {
            return type;
        }
        return this.upcastType(result);
    }

    protected abstract Object doClone(Object var1);

    protected abstract <V> V doConvert(Object var1, Class<V> var2);

    protected boolean isKnownType(String type) {
        try {
            ReflectionUtils.classForName((String)type);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected Stream<DeserializingObject<byte[], ?>> deserializeOtherFormat(SerializedObject<byte[], ?> s) {
        return Stream.of(new DeserializingObject(s, type -> {
            try {
                if (Object.class.equals(type)) {
                    if (s.data().getFormat() != null && s.data().getFormat().startsWith("text/")) {
                        return new String((byte[])s.data().getValue(), StandardCharsets.UTF_8);
                    }
                    return s.data().getValue();
                }
                if (byte[].class.isAssignableFrom((Class<?>)type)) {
                    return s.data().getValue();
                }
                if (String.class.isAssignableFrom((Class<?>)type)) {
                    return new String((byte[])s.data().getValue());
                }
                if (InputStream.class.isAssignableFrom((Class<?>)type)) {
                    return new ByteArrayInputStream((byte[])s.data().getValue());
                }
                return this.doDeserialize((Data<byte[]>)s.data(), this.asString((Type)type));
            }
            catch (Exception e) {
                throw new SerializationException("Could not deserialize a " + s.data().getType(), e);
            }
        }));
    }

    protected Stream<DeserializingObject<byte[], ?>> deserializeUnknownType(SerializedObject<byte[], ?> serializedObject) {
        return Stream.empty();
    }

    protected abstract Object doDeserialize(Data<byte[]> var1, String var2) throws Exception;

    public String getFormat() {
        return this.format;
    }
}

