/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.serialization;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingObject;
import io.fluxcapacitor.javaclient.common.serialization.MessageFormatter;
import io.fluxcapacitor.javaclient.modeling.AggregateIdResolver;
import io.fluxcapacitor.javaclient.modeling.AggregateTypeResolver;
import io.fluxcapacitor.javaclient.scheduling.Schedule;
import io.fluxcapacitor.javaclient.tracking.handling.DeserializingMessageParameterResolver;
import io.fluxcapacitor.javaclient.tracking.handling.MessageParameterResolver;
import io.fluxcapacitor.javaclient.tracking.handling.MetadataParameterResolver;
import io.fluxcapacitor.javaclient.tracking.handling.PayloadParameterResolver;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.UserParameterResolver;
import io.fluxcapacitor.javaclient.web.WebPayloadParameterResolver;
import io.fluxcapacitor.javaclient.web.WebRequest;
import io.fluxcapacitor.javaclient.web.WebResponse;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DeserializingMessage {
    private static final Logger log = LoggerFactory.getLogger(DeserializingMessage.class);
    public static MessageFormatter messageFormatter = MessageFormatter.DEFAULT;
    public static List<ParameterResolver<? super DeserializingMessage>> defaultParameterResolvers = Arrays.asList(new DeserializingMessageParameterResolver(), new MetadataParameterResolver(), new MessageParameterResolver(), new AggregateIdResolver(), new AggregateTypeResolver(), new UserParameterResolver(), new WebPayloadParameterResolver(), new PayloadParameterResolver());
    private static final ThreadLocal<Set<Consumer<Throwable>>> messageCompletionHandlers = new ThreadLocal();
    private static final ThreadLocal<Map<Object, Object>> messageResources = new ThreadLocal();
    private static final ThreadLocal<Set<Consumer<Throwable>>> batchCompletionHandlers = new ThreadLocal();
    private static final ThreadLocal<Map<Object, Object>> batchResources = new ThreadLocal();
    private static final ThreadLocal<DeserializingMessage> current = new ThreadLocal();
    private final DeserializingObject<byte[], SerializedMessage> delegate;
    private final MessageType messageType;

    public DeserializingMessage(SerializedMessage message, Function<Class<?>, Object> payload, MessageType messageType) {
        this(new DeserializingObject<byte[], SerializedMessage>(message, payload), messageType);
    }

    public void run(Consumer<DeserializingMessage> task) {
        this.apply(m -> {
            task.accept((DeserializingMessage)m);
            return null;
        });
    }

    public <T> T apply(Function<DeserializingMessage, T> action) {
        return DeserializingMessage.handleBatch(Stream.of(this)).map(action).collect(Collectors.toList()).get(0);
    }

    public Metadata getMetadata() {
        return this.delegate.getSerializedObject().getMetadata();
    }

    public String getMessageId() {
        return this.getSerializedObject().getMessageId();
    }

    public Long getIndex() {
        return this.getSerializedObject().getIndex();
    }

    public Instant getTimestamp() {
        return Instant.ofEpochMilli(this.getSerializedObject().getTimestamp());
    }

    public Message toMessage() {
        Message message = new Message(this.getPayload(), this.getMetadata(), this.getMessageId(), this.getTimestamp());
        switch (this.messageType) {
            case SCHEDULE: {
                return new Schedule(message);
            }
            case WEBREQUEST: {
                return new WebRequest(message);
            }
            case WEBRESPONSE: {
                return new WebResponse(message);
            }
        }
        return message;
    }

    public static DeserializingMessage getCurrent() {
        return current.get();
    }

    public static void whenHandlerCompletes(Consumer<Throwable> handler) {
        if (current.get() == null) {
            handler.accept(null);
        } else {
            if (messageCompletionHandlers.get() == null) {
                messageCompletionHandlers.set(new LinkedHashSet());
            }
            messageCompletionHandlers.get().add(handler);
        }
    }

    public static <K, V> V computeForMessage(K key, BiFunction<? super K, ? super V, ? extends V> function) {
        return DeserializingMessage.getMessageResources().compute(key, function);
    }

    public static <K, V> V computeForMessageIfAbsent(K key, Function<? super K, ? extends V> function) {
        return DeserializingMessage.getMessageResources().computeIfAbsent(key, function);
    }

    public static <V> V getMessageResource(Object key) {
        return (V)DeserializingMessage.getMessageResources().get(key);
    }

    public static <V> V getMessageResourceOrDefault(Object key, V defaultValue) {
        return (V)DeserializingMessage.getMessageResources().getOrDefault(key, defaultValue);
    }

    private static Map<Object, Object> getMessageResources() {
        if (messageResources.get() == null) {
            messageResources.set(new HashMap());
        }
        return messageResources.get();
    }

    public String toString() {
        return (String)messageFormatter.apply(this);
    }

    public static Stream<DeserializingMessage> handleBatch(Stream<DeserializingMessage> batch) {
        return StreamSupport.stream(new MessageSpliterator(batch.spliterator()), false);
    }

    public static void whenBatchCompletes(Consumer<Throwable> handler) {
        if (current.get() == null) {
            handler.accept(null);
        } else {
            if (batchCompletionHandlers.get() == null) {
                batchCompletionHandlers.set(new LinkedHashSet());
            }
            batchCompletionHandlers.get().add(handler);
        }
    }

    public static <K, V> V computeForBatch(K key, BiFunction<? super K, ? super V, ? extends V> function) {
        return DeserializingMessage.getBatchResources().compute(key, function);
    }

    public static <K, V> V computeForBatchIfAbsent(K key, Function<? super K, ? extends V> function) {
        return DeserializingMessage.getBatchResources().computeIfAbsent(key, function);
    }

    public static <V> V getBatchResource(Object key) {
        return (V)DeserializingMessage.getBatchResources().get(key);
    }

    public static <V> V getBatchResourceOrDefault(Object key, V defaultValue) {
        return (V)DeserializingMessage.getBatchResources().getOrDefault(key, defaultValue);
    }

    private static Map<Object, Object> getBatchResources() {
        if (batchResources.get() == null) {
            batchResources.set(new HashMap());
        }
        return batchResources.get();
    }

    public DeserializingObject<byte[], SerializedMessage> getDelegate() {
        return this.delegate;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeserializingMessage)) {
            return false;
        }
        DeserializingMessage other = (DeserializingMessage)o;
        DeserializingObject<byte[], SerializedMessage> this$delegate = this.getDelegate();
        DeserializingObject<byte[], SerializedMessage> other$delegate = other.getDelegate();
        if (this$delegate == null ? other$delegate != null : !this$delegate.equals(other$delegate)) {
            return false;
        }
        MessageType this$messageType = this.getMessageType();
        MessageType other$messageType = other.getMessageType();
        return !(this$messageType == null ? other$messageType != null : !this$messageType.equals(other$messageType));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DeserializingObject<byte[], SerializedMessage> $delegate = this.getDelegate();
        result = result * 59 + ($delegate == null ? 43 : $delegate.hashCode());
        MessageType $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : $messageType.hashCode());
        return result;
    }

    @ConstructorProperties(value={"delegate", "messageType"})
    public DeserializingMessage(DeserializingObject<byte[], SerializedMessage> delegate, MessageType messageType) {
        this.delegate = delegate;
        this.messageType = messageType;
    }

    public <V> V getPayload() {
        return this.getDelegate().getPayload();
    }

    public <V> V getPayloadAs(Class<V> type) {
        return this.getDelegate().getPayloadAs(type);
    }

    public boolean isDeserialized() {
        return this.getDelegate().isDeserialized();
    }

    public String getType() {
        return this.getDelegate().getType();
    }

    public int getRevision() {
        return this.getDelegate().getRevision();
    }

    public SerializedMessage getSerializedObject() {
        return this.getDelegate().getSerializedObject();
    }

    public Class<?> getPayloadClass() {
        return this.getDelegate().getPayloadClass();
    }

    protected static class MessageSpliterator
    extends Spliterators.AbstractSpliterator<DeserializingMessage> {
        private final Spliterator<DeserializingMessage> upStream;

        public MessageSpliterator(Spliterator<DeserializingMessage> upStream) {
            super(upStream.estimateSize(), upStream.characteristics());
            this.upStream = upStream;
        }

        @Override
        public boolean tryAdvance(Consumer<? super DeserializingMessage> action) {
            boolean hadNext;
            try {
                hadNext = this.upStream.tryAdvance((? super T d) -> {
                    DeserializingMessage previous = DeserializingMessage.getCurrent();
                    try {
                        current.set((DeserializingMessage)d);
                        action.accept((DeserializingMessage)d);
                        if (previous == null) {
                            this.onMessageCompletion(null);
                        }
                        current.set(previous);
                    }
                    catch (Throwable e) {
                        this.onMessageCompletion(e);
                        throw e;
                    }
                });
            }
            catch (Throwable e) {
                this.onBatchCompletion(e);
                throw e;
            }
            if (!hadNext && DeserializingMessage.getCurrent() == null) {
                this.onBatchCompletion(null);
            }
            return hadNext;
        }

        protected void onMessageCompletion(Throwable error) {
            try {
                Optional.ofNullable(messageCompletionHandlers.get()).ifPresent(handlers -> {
                    messageCompletionHandlers.remove();
                    handlers.forEach(h -> h.accept(error));
                });
            }
            finally {
                messageResources.remove();
                messageCompletionHandlers.remove();
                current.set(null);
            }
        }

        protected void onBatchCompletion(Throwable error) {
            try {
                Optional.ofNullable(batchCompletionHandlers.get()).ifPresent(handlers -> {
                    batchCompletionHandlers.remove();
                    handlers.forEach(h -> h.accept(error));
                });
            }
            finally {
                batchResources.remove();
                batchCompletionHandlers.remove();
            }
        }
    }
}

