/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.serialization.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.common.api.SerializedObject;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.common.search.Document;
import io.fluxcapacitor.common.search.Inverter;
import io.fluxcapacitor.common.search.JacksonInverter;
import io.fluxcapacitor.common.serialization.NullCollectionsAsEmptyModule;
import io.fluxcapacitor.common.serialization.StripStringsModule;
import io.fluxcapacitor.javaclient.common.serialization.AbstractSerializer;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingObject;
import io.fluxcapacitor.javaclient.common.serialization.SerializationException;
import io.fluxcapacitor.javaclient.common.serialization.jackson.ObjectNodeConverter;
import io.fluxcapacitor.javaclient.common.serialization.upcasting.Converter;
import io.fluxcapacitor.javaclient.common.serialization.upcasting.Upcaster;
import io.fluxcapacitor.javaclient.common.serialization.upcasting.UpcasterChain;
import io.fluxcapacitor.javaclient.persisting.search.DocumentSerializer;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.stream.Stream;

public class JacksonSerializer
extends AbstractSerializer
implements DocumentSerializer {
    public static JsonMapper defaultObjectMapper = (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).addModule((Module)new StripStringsModule())).addModule((Module)new NullCollectionsAsEmptyModule())).disable(new SerializationFeature[]{SerializationFeature.FAIL_ON_EMPTY_BEANS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).nodeFactory(JsonNodeFactory.withExactBigDecimals((boolean)true))).serializationInclusion(JsonInclude.Include.NON_NULL)).enable(new DeserializationFeature[]{DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY})).build();
    private final ObjectMapper objectMapper;
    private final Function<String, JavaType> typeCache = ObjectUtils.memoize(this::getJavaType);
    private final Function<Type, String> typeStringCache = ObjectUtils.memoize(this::getCanonicalType);
    private final Upcaster<Data<JsonNode>> jsonNodeUpcaster;
    private final Inverter<JsonNode> inverter;

    public JacksonSerializer() {
        this(Collections.emptyList());
    }

    public JacksonSerializer(Collection<?> upcasters) {
        this((ObjectMapper)defaultObjectMapper, upcasters);
    }

    public JacksonSerializer(ObjectMapper objectMapper) {
        this(objectMapper, Collections.emptyList());
    }

    public JacksonSerializer(ObjectMapper objectMapper, Collection<?> upcasters) {
        this(objectMapper, upcasters, new ObjectNodeConverter(objectMapper));
    }

    public JacksonSerializer(ObjectMapper objectMapper, Collection<?> upcasters, Converter<JsonNode> converter) {
        super(UpcasterChain.createConverting(upcasters, converter), "application/json");
        this.objectMapper = objectMapper;
        this.jsonNodeUpcaster = UpcasterChain.create(upcasters, converter);
        this.inverter = new JacksonInverter(objectMapper);
    }

    @Override
    protected String asString(Type type) {
        return this.typeStringCache.apply(type);
    }

    @Override
    protected byte[] doSerialize(Object object) throws Exception {
        return this.objectMapper.writeValueAsBytes(object);
    }

    @Override
    protected Object doDeserialize(Data<byte[]> data, String type) throws Exception {
        return this.objectMapper.readValue((byte[])data.getValue(), this.typeCache.apply(type));
    }

    @Override
    protected boolean isKnownType(String type) {
        try {
            this.typeCache.apply(type);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    protected Stream<DeserializingObject<byte[], ?>> deserializeUnknownType(SerializedObject<byte[], ?> s) {
        return Stream.of(new DeserializingObject(s, type -> {
            try {
                return this.convert(this.objectMapper.readTree((byte[])s.data().getValue()), type);
            }
            catch (Exception e) {
                throw new SerializationException(String.format("Could not deserialize a %s to a JsonNode. Invalid Json?", s.data().getType()), e);
            }
        }));
    }

    protected JavaType getJavaType(String type) {
        return this.objectMapper.getTypeFactory().constructFromCanonical(type);
    }

    protected String getCanonicalType(Type type) {
        return this.objectMapper.constructType(type).toCanonical();
    }

    @Override
    public Document toDocument(Object value, String id, String collection, Instant timestamp, Instant end) {
        return this.inverter.toDocument(this.serialize(value), id, collection, timestamp, end);
    }

    @Override
    public <T> T fromDocument(Document document) {
        JsonNode jsonNode = (JsonNode)this.inverter.fromDocument(document);
        return this.jsonNodeUpcaster.upcast(Stream.of(new Data((Object)jsonNode, document.getType(), document.getRevision(), "application/json"))).findFirst().map(d -> this.objectMapper.convertValue(d.getValue(), this.typeCache.apply(d.getType()))).orElse(null);
    }

    @Override
    public <T> T fromDocument(Document document, Class<T> type) {
        JsonNode jsonNode = (JsonNode)this.inverter.fromDocument(document);
        return this.jsonNodeUpcaster.upcast(Stream.of(new Data((Object)jsonNode, document.getType(), document.getRevision(), "application/json"))).findFirst().map(d -> this.objectMapper.convertValue(d.getValue(), type)).orElse(null);
    }

    @Override
    public <V> V doConvert(Object value, Class<V> type) {
        return (V)this.objectMapper.convertValue(value, type);
    }

    @Override
    public Object doClone(Object value) {
        return ReflectionUtils.copyFields((Object)value, this.doConvert(this.objectMapper.createObjectNode(), value.getClass()));
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

