/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.websocket;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.websocket.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionPool
implements Supplier<Session>,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(SessionPool.class);
    private final List<AtomicReference<Session>> sessions;
    private final int size;
    private final AtomicInteger counter = new AtomicInteger();
    private final Supplier<Session> sessionFactory;
    private final AtomicBoolean shuttingDown = new AtomicBoolean();

    public SessionPool(int size, Supplier<Session> sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.size = size;
        this.sessions = IntStream.range(0, this.size).mapToObj(i -> new AtomicReference()).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public Session get() {
        AtomicReference<Session> reference = this.sessions.get(this.counter.getAndAccumulate(1, (i, inc) -> {
            int newIndex = i + inc;
            return newIndex >= this.size ? 0 : newIndex;
        }));
        return reference.updateAndGet(s -> {
            if (SessionPool.isClosed(s)) {
                AtomicBoolean atomicBoolean = this.shuttingDown;
                synchronized (atomicBoolean) {
                    while (SessionPool.isClosed(s)) {
                        if (this.shuttingDown.get()) {
                            throw new IllegalStateException("Cannot provide session. This client has closed");
                        }
                        s = this.sessionFactory.get();
                    }
                }
            }
            return s;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.shuttingDown.compareAndSet(false, true)) {
            AtomicBoolean atomicBoolean = this.shuttingDown;
            synchronized (atomicBoolean) {
                this.sessions.stream().map(AtomicReference::get).forEach(session -> {
                    if (!SessionPool.isClosed(session)) {
                        try {
                            session.close();
                        }
                        catch (Exception e) {
                            log.warn("Failed to closed websocket session connected to endpoint {}. Reason: {}", (Object)session.getRequestURI(), (Object)e.getMessage());
                        }
                    }
                });
            }
        }
    }

    private static boolean isClosed(Session session) {
        try {
            return session == null || !session.isOpen();
        }
        catch (Exception e) {
            log.error("Failed to check if session is open", (Throwable)e);
            return true;
        }
    }
}

