/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.configuration;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.ClientUtils;
import io.fluxcapacitor.javaclient.common.IdentityProvider;
import io.fluxcapacitor.javaclient.common.UuidFactory;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.common.serialization.jackson.JacksonSerializer;
import io.fluxcapacitor.javaclient.configuration.FluxCapacitorBuilder;
import io.fluxcapacitor.javaclient.configuration.client.Client;
import io.fluxcapacitor.javaclient.persisting.caching.Cache;
import io.fluxcapacitor.javaclient.persisting.caching.DefaultCache;
import io.fluxcapacitor.javaclient.persisting.caching.NamedCache;
import io.fluxcapacitor.javaclient.persisting.caching.SelectiveCache;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.DefaultEventSourcingHandlerFactory;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.DefaultEventStore;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.DefaultSnapshotStore;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.EventStore;
import io.fluxcapacitor.javaclient.persisting.keyvalue.DefaultKeyValueStore;
import io.fluxcapacitor.javaclient.persisting.keyvalue.KeyValueStore;
import io.fluxcapacitor.javaclient.persisting.repository.AggregateRepository;
import io.fluxcapacitor.javaclient.persisting.repository.CachingAggregateRepository;
import io.fluxcapacitor.javaclient.persisting.repository.DefaultAggregateRepository;
import io.fluxcapacitor.javaclient.persisting.search.DefaultDocumentStore;
import io.fluxcapacitor.javaclient.persisting.search.DocumentSerializer;
import io.fluxcapacitor.javaclient.persisting.search.DocumentStore;
import io.fluxcapacitor.javaclient.publishing.CommandGateway;
import io.fluxcapacitor.javaclient.publishing.DefaultCommandGateway;
import io.fluxcapacitor.javaclient.publishing.DefaultErrorGateway;
import io.fluxcapacitor.javaclient.publishing.DefaultEventGateway;
import io.fluxcapacitor.javaclient.publishing.DefaultGenericGateway;
import io.fluxcapacitor.javaclient.publishing.DefaultMetricsGateway;
import io.fluxcapacitor.javaclient.publishing.DefaultQueryGateway;
import io.fluxcapacitor.javaclient.publishing.DefaultRequestHandler;
import io.fluxcapacitor.javaclient.publishing.DefaultResultGateway;
import io.fluxcapacitor.javaclient.publishing.DefaultWebRequestGateway;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import io.fluxcapacitor.javaclient.publishing.ErrorGateway;
import io.fluxcapacitor.javaclient.publishing.EventGateway;
import io.fluxcapacitor.javaclient.publishing.GenericGateway;
import io.fluxcapacitor.javaclient.publishing.MetricsGateway;
import io.fluxcapacitor.javaclient.publishing.QueryGateway;
import io.fluxcapacitor.javaclient.publishing.RequestHandler;
import io.fluxcapacitor.javaclient.publishing.ResultGateway;
import io.fluxcapacitor.javaclient.publishing.WebRequestGateway;
import io.fluxcapacitor.javaclient.publishing.correlation.CorrelatingInterceptor;
import io.fluxcapacitor.javaclient.publishing.correlation.CorrelationDataProvider;
import io.fluxcapacitor.javaclient.publishing.correlation.DefaultCorrelationDataProvider;
import io.fluxcapacitor.javaclient.publishing.dataprotection.DataProtectionInterceptor;
import io.fluxcapacitor.javaclient.publishing.routing.MessageRoutingInterceptor;
import io.fluxcapacitor.javaclient.scheduling.DefaultScheduler;
import io.fluxcapacitor.javaclient.scheduling.Scheduler;
import io.fluxcapacitor.javaclient.scheduling.SchedulingInterceptor;
import io.fluxcapacitor.javaclient.tracking.BatchInterceptor;
import io.fluxcapacitor.javaclient.tracking.ConsumerConfiguration;
import io.fluxcapacitor.javaclient.tracking.DefaultTracking;
import io.fluxcapacitor.javaclient.tracking.Tracking;
import io.fluxcapacitor.javaclient.tracking.TrackingException;
import io.fluxcapacitor.javaclient.tracking.handling.DefaultHandlerFactory;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerInterceptor;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerRegistry;
import io.fluxcapacitor.javaclient.tracking.handling.LocalHandlerRegistry;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.AuthenticatingInterceptor;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.UserProvider;
import io.fluxcapacitor.javaclient.tracking.handling.errorreporting.ErrorReportingInterceptor;
import io.fluxcapacitor.javaclient.tracking.handling.validation.ValidatingInterceptor;
import io.fluxcapacitor.javaclient.tracking.metrics.HandlerMonitor;
import io.fluxcapacitor.javaclient.tracking.metrics.TrackerMonitor;
import io.fluxcapacitor.javaclient.web.DefaultWebResponseMapper;
import io.fluxcapacitor.javaclient.web.ForwardingWebConsumer;
import io.fluxcapacitor.javaclient.web.LocalServerConfig;
import io.fluxcapacitor.javaclient.web.WebResponseGateway;
import io.fluxcapacitor.javaclient.web.WebResponseMapper;
import java.beans.ConstructorProperties;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFluxCapacitor
implements FluxCapacitor {
    private static final Logger log = LoggerFactory.getLogger(DefaultFluxCapacitor.class);
    private final Map<MessageType, ? extends Tracking> trackingSupplier;
    private final CommandGateway commandGateway;
    private final QueryGateway queryGateway;
    private final EventGateway eventGateway;
    private final ResultGateway resultGateway;
    private final ErrorGateway errorGateway;
    private final MetricsGateway metricsGateway;
    private final WebRequestGateway webRequestGateway;
    private final AggregateRepository aggregateRepository;
    private final EventStore eventStore;
    private final KeyValueStore keyValueStore;
    private final DocumentStore documentStore;
    private final Scheduler scheduler;
    private final UserProvider userProvider;
    private final Cache cache;
    private final Serializer serializer;
    private final CorrelationDataProvider correlationDataProvider;
    private final AtomicReference<Clock> clock = new AtomicReference<Clock>(Clock.systemUTC());
    private final AtomicReference<IdentityProvider> identityProvider = new AtomicReference<UuidFactory>(new UuidFactory());
    private final Client client;
    private final Runnable shutdownHandler;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Collection<Runnable> cleanupTasks = new CopyOnWriteArrayList<Runnable>();

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Tracking tracking(MessageType messageType) {
        return Optional.ofNullable(this.trackingSupplier.get(messageType)).orElseThrow(() -> new TrackingException(String.format("Tracking is not supported for type %s", messageType)));
    }

    @Override
    public void withClock(@NonNull Clock clock) {
        if (clock == null) {
            throw new NullPointerException("clock is marked non-null but is null");
        }
        this.clock.set(clock);
    }

    @Override
    public Clock clock() {
        return this.clock.get();
    }

    @Override
    public void withIdentityProvider(@NonNull IdentityProvider identityProvider) {
        if (identityProvider == null) {
            throw new NullPointerException("identityProvider is marked non-null but is null");
        }
        this.identityProvider.set(identityProvider);
    }

    @Override
    public IdentityProvider identityProvider() {
        return this.identityProvider.get();
    }

    @Override
    public Registration beforeShutdown(Runnable task) {
        this.cleanupTasks.add(task);
        return () -> this.cleanupTasks.remove(task);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            log.info("Initiating controlled shutdown");
            try {
                this.cleanupTasks.forEach(ClientUtils::tryRun);
                this.shutdownHandler.run();
            }
            catch (Exception e) {
                log.error("Encountered an error during shutdown", (Throwable)e);
            }
            finally {
                if (FluxCapacitor.applicationInstance.get() == this) {
                    FluxCapacitor.applicationInstance.set(null);
                }
            }
            log.info("Completed shutdown");
        }
    }

    @ConstructorProperties(value={"trackingSupplier", "commandGateway", "queryGateway", "eventGateway", "resultGateway", "errorGateway", "metricsGateway", "webRequestGateway", "aggregateRepository", "eventStore", "keyValueStore", "documentStore", "scheduler", "userProvider", "cache", "serializer", "correlationDataProvider", "client", "shutdownHandler"})
    protected DefaultFluxCapacitor(Map<MessageType, ? extends Tracking> trackingSupplier, CommandGateway commandGateway, QueryGateway queryGateway, EventGateway eventGateway, ResultGateway resultGateway, ErrorGateway errorGateway, MetricsGateway metricsGateway, WebRequestGateway webRequestGateway, AggregateRepository aggregateRepository, EventStore eventStore, KeyValueStore keyValueStore, DocumentStore documentStore, Scheduler scheduler, UserProvider userProvider, Cache cache, Serializer serializer, CorrelationDataProvider correlationDataProvider, Client client, Runnable shutdownHandler) {
        this.trackingSupplier = trackingSupplier;
        this.commandGateway = commandGateway;
        this.queryGateway = queryGateway;
        this.eventGateway = eventGateway;
        this.resultGateway = resultGateway;
        this.errorGateway = errorGateway;
        this.metricsGateway = metricsGateway;
        this.webRequestGateway = webRequestGateway;
        this.aggregateRepository = aggregateRepository;
        this.eventStore = eventStore;
        this.keyValueStore = keyValueStore;
        this.documentStore = documentStore;
        this.scheduler = scheduler;
        this.userProvider = userProvider;
        this.cache = cache;
        this.serializer = serializer;
        this.correlationDataProvider = correlationDataProvider;
        this.client = client;
        this.shutdownHandler = shutdownHandler;
    }

    public Map<MessageType, ? extends Tracking> trackingSupplier() {
        return this.trackingSupplier;
    }

    @Override
    public CommandGateway commandGateway() {
        return this.commandGateway;
    }

    @Override
    public QueryGateway queryGateway() {
        return this.queryGateway;
    }

    @Override
    public EventGateway eventGateway() {
        return this.eventGateway;
    }

    @Override
    public ResultGateway resultGateway() {
        return this.resultGateway;
    }

    @Override
    public ErrorGateway errorGateway() {
        return this.errorGateway;
    }

    @Override
    public MetricsGateway metricsGateway() {
        return this.metricsGateway;
    }

    @Override
    public WebRequestGateway webRequestGateway() {
        return this.webRequestGateway;
    }

    @Override
    public AggregateRepository aggregateRepository() {
        return this.aggregateRepository;
    }

    @Override
    public EventStore eventStore() {
        return this.eventStore;
    }

    @Override
    public KeyValueStore keyValueStore() {
        return this.keyValueStore;
    }

    @Override
    public DocumentStore documentStore() {
        return this.documentStore;
    }

    @Override
    public Scheduler scheduler() {
        return this.scheduler;
    }

    @Override
    public UserProvider userProvider() {
        return this.userProvider;
    }

    @Override
    public Cache cache() {
        return this.cache;
    }

    @Override
    public Serializer serializer() {
        return this.serializer;
    }

    @Override
    public CorrelationDataProvider correlationDataProvider() {
        return this.correlationDataProvider;
    }

    @Override
    public Client client() {
        return this.client;
    }

    public Runnable shutdownHandler() {
        return this.shutdownHandler;
    }

    public AtomicBoolean closed() {
        return this.closed;
    }

    public Collection<Runnable> cleanupTasks() {
        return this.cleanupTasks;
    }

    public static class Builder
    implements FluxCapacitorBuilder {
        private Serializer serializer;
        private Serializer snapshotSerializer;
        private CorrelationDataProvider correlationDataProvider;
        private DocumentSerializer documentSerializer;
        private final Map<MessageType, List<ConsumerConfiguration>> consumerConfigurations;
        private final List<ParameterResolver<? super DeserializingMessage>> parameterResolvers;
        private final Map<MessageType, List<DispatchInterceptor>> lowPrioDispatchInterceptors;
        private final Map<MessageType, List<DispatchInterceptor>> highPrioDispatchInterceptors;
        private final Map<MessageType, List<HandlerInterceptor>> lowPrioHandlerInterceptors;
        private final Map<MessageType, List<HandlerInterceptor>> highPrioHandlerInterceptors;
        private final Map<MessageType, List<BatchInterceptor>> customBatchInterceptors;
        private DispatchInterceptor messageRoutingInterceptor;
        private SchedulingInterceptor schedulingInterceptor;
        private ForwardingWebConsumer forwardingWebConsumer;
        private Cache cache;
        private Cache relationshipsCache;
        private WebResponseMapper webResponseMapper;
        private boolean disableErrorReporting;
        private boolean disableMessageCorrelation;
        private boolean disablePayloadValidation;
        private boolean disableDataProtection;
        private boolean disableAutomaticAggregateCaching;
        private boolean disableShutdownHook;
        private boolean collectTrackingMetrics;
        private boolean makeApplicationInstance;
        private UserProvider userProvider;

        public Builder() {
            this.snapshotSerializer = this.serializer = new JacksonSerializer();
            this.correlationDataProvider = DefaultCorrelationDataProvider.INSTANCE;
            this.documentSerializer = (JacksonSerializer)this.serializer;
            this.consumerConfigurations = this.defaultConfigurations();
            this.parameterResolvers = new ArrayList<ParameterResolver<? super DeserializingMessage>>(DeserializingMessage.defaultParameterResolvers);
            this.lowPrioDispatchInterceptors = new HashMap<MessageType, List<DispatchInterceptor>>();
            this.highPrioDispatchInterceptors = new HashMap<MessageType, List<DispatchInterceptor>>();
            this.lowPrioHandlerInterceptors = new HashMap<MessageType, List<HandlerInterceptor>>();
            this.highPrioHandlerInterceptors = new HashMap<MessageType, List<HandlerInterceptor>>();
            this.customBatchInterceptors = new HashMap<MessageType, List<BatchInterceptor>>();
            this.messageRoutingInterceptor = new MessageRoutingInterceptor();
            this.schedulingInterceptor = new SchedulingInterceptor();
            this.cache = new DefaultCache();
            this.relationshipsCache = new DefaultCache(100000);
            this.webResponseMapper = new DefaultWebResponseMapper();
            this.userProvider = UserProvider.defaultUserSupplier;
        }

        protected Map<MessageType, List<ConsumerConfiguration>> defaultConfigurations() {
            return Collections.unmodifiableMap(Arrays.stream(MessageType.values()).collect(Collectors.toMap(Function.identity(), messageType -> new ArrayList<ConsumerConfiguration>(Collections.singletonList(ConsumerConfiguration.getDefault(messageType))))));
        }

        @Override
        public Builder replaceSerializer(@NonNull Serializer serializer) {
            if (serializer == null) {
                throw new NullPointerException("serializer is marked non-null but is null");
            }
            if (this.snapshotSerializer == this.serializer) {
                this.snapshotSerializer = serializer;
            }
            if (this.documentSerializer == this.serializer && serializer instanceof DocumentSerializer) {
                this.documentSerializer = (DocumentSerializer)((Object)serializer);
            }
            this.serializer = serializer;
            return this;
        }

        @Override
        public FluxCapacitorBuilder replaceCorrelationDataProvider(CorrelationDataProvider correlationDataProvider) {
            this.correlationDataProvider = correlationDataProvider;
            return this;
        }

        @Override
        public Builder replaceSnapshotSerializer(@NonNull Serializer serializer) {
            if (serializer == null) {
                throw new NullPointerException("serializer is marked non-null but is null");
            }
            this.snapshotSerializer = serializer;
            return this;
        }

        @Override
        public FluxCapacitorBuilder replaceDocumentSerializer(@NonNull DocumentSerializer documentSerializer) {
            if (documentSerializer == null) {
                throw new NullPointerException("documentSerializer is marked non-null but is null");
            }
            this.documentSerializer = documentSerializer;
            return this;
        }

        @Override
        public FluxCapacitorBuilder registerUserSupplier(@NonNull UserProvider userProvider) {
            if (userProvider == null) {
                throw new NullPointerException("userProvider is marked non-null but is null");
            }
            this.userProvider = userProvider;
            return this;
        }

        @Override
        public Builder configureDefaultConsumer(@NonNull MessageType messageType, @NonNull UnaryOperator<ConsumerConfiguration> updateFunction) {
            if (messageType == null) {
                throw new NullPointerException("messageType is marked non-null but is null");
            }
            if (updateFunction == null) {
                throw new NullPointerException("updateFunction is marked non-null but is null");
            }
            List<ConsumerConfiguration> configurations = this.consumerConfigurations.get(messageType);
            ConsumerConfiguration defaultConfiguration = configurations.get(configurations.size() - 1);
            ConsumerConfiguration updatedConfiguration = (ConsumerConfiguration)updateFunction.apply(defaultConfiguration);
            if (configurations.subList(0, configurations.size() - 1).stream().map(ConsumerConfiguration::getName).anyMatch(n -> Objects.equals(n, updatedConfiguration.getName()))) {
                throw new IllegalArgumentException(String.format("Consumer name %s is already in use", updatedConfiguration.getName()));
            }
            configurations.set(configurations.size() - 1, updatedConfiguration);
            return this;
        }

        @Override
        public Builder addConsumerConfiguration(@NonNull ConsumerConfiguration consumerConfiguration) {
            if (consumerConfiguration == null) {
                throw new NullPointerException("consumerConfiguration is marked non-null but is null");
            }
            List<ConsumerConfiguration> configurations = this.consumerConfigurations.get(consumerConfiguration.getMessageType());
            if (configurations.stream().map(ConsumerConfiguration::getName).anyMatch(n -> Objects.equals(n, consumerConfiguration.getName()))) {
                throw new IllegalArgumentException(String.format("Consumer name %s is already in use", consumerConfiguration.getName()));
            }
            configurations.add(configurations.size() - 1, consumerConfiguration);
            return this;
        }

        @Override
        public FluxCapacitorBuilder addBatchInterceptor(BatchInterceptor interceptor, MessageType ... forTypes) {
            Arrays.stream(forTypes.length == 0 ? MessageType.values() : forTypes).forEach(type -> this.customBatchInterceptors.computeIfAbsent((MessageType)type, t -> new ArrayList()).add(interceptor));
            return this;
        }

        @Override
        public Builder addDispatchInterceptor(@NonNull DispatchInterceptor interceptor, boolean highPriority, MessageType ... forTypes) {
            if (interceptor == null) {
                throw new NullPointerException("interceptor is marked non-null but is null");
            }
            Arrays.stream(forTypes.length == 0 ? MessageType.values() : forTypes).forEach(type -> (highPriority ? this.highPrioDispatchInterceptors : this.lowPrioDispatchInterceptors).computeIfAbsent((MessageType)type, t -> new ArrayList()).add(interceptor));
            return this;
        }

        @Override
        public Builder addHandlerInterceptor(@NonNull HandlerInterceptor interceptor, boolean highPriority, MessageType ... forTypes) {
            if (interceptor == null) {
                throw new NullPointerException("interceptor is marked non-null but is null");
            }
            Arrays.stream(forTypes.length == 0 ? MessageType.values() : forTypes).forEach(type -> (highPriority ? this.highPrioHandlerInterceptors : this.lowPrioHandlerInterceptors).computeIfAbsent((MessageType)type, t -> new ArrayList()).add(interceptor));
            return this;
        }

        @Override
        public Builder replaceMessageRoutingInterceptor(@NonNull DispatchInterceptor messageRoutingInterceptor) {
            if (messageRoutingInterceptor == null) {
                throw new NullPointerException("messageRoutingInterceptor is marked non-null but is null");
            }
            this.messageRoutingInterceptor = messageRoutingInterceptor;
            return this;
        }

        @Override
        public FluxCapacitorBuilder replaceCache(@NonNull Cache cache) {
            if (cache == null) {
                throw new NullPointerException("cache is marked non-null but is null");
            }
            this.cache = cache;
            return this;
        }

        @Override
        public FluxCapacitorBuilder forwardWebRequestsToLocalServer(LocalServerConfig localServerConfig, UnaryOperator<ConsumerConfiguration> consumerConfigurator) {
            this.forwardingWebConsumer = new ForwardingWebConsumer(localServerConfig, (ConsumerConfiguration)consumerConfigurator.apply(ConsumerConfiguration.getDefault(MessageType.WEBREQUEST)));
            return this;
        }

        @Override
        public FluxCapacitorBuilder replaceWebResponseMapper(WebResponseMapper webResponseMapper) {
            this.webResponseMapper = webResponseMapper;
            return this;
        }

        @Override
        public FluxCapacitorBuilder withAggregateCache(Class<?> aggregateType, Cache cache) {
            this.cache = new SelectiveCache(cache, SelectiveCache.aggregateSelector(aggregateType), this.cache);
            return this;
        }

        @Override
        public FluxCapacitorBuilder replaceRelationshipsCache(UnaryOperator<Cache> replaceFunction) {
            this.relationshipsCache = (Cache)replaceFunction.apply(this.relationshipsCache);
            return this;
        }

        @Override
        public Builder addParameterResolver(@NonNull ParameterResolver<DeserializingMessage> parameterResolver) {
            if (parameterResolver == null) {
                throw new NullPointerException("parameterResolver is marked non-null but is null");
            }
            this.parameterResolvers.add(parameterResolver);
            return this;
        }

        @Override
        public FluxCapacitorBuilder disableErrorReporting() {
            this.disableErrorReporting = true;
            return this;
        }

        @Override
        public FluxCapacitorBuilder disableShutdownHook() {
            this.disableShutdownHook = true;
            return this;
        }

        @Override
        public Builder disableMessageCorrelation() {
            this.disableMessageCorrelation = true;
            return this;
        }

        @Override
        public Builder disablePayloadValidation() {
            this.disablePayloadValidation = true;
            return this;
        }

        @Override
        public FluxCapacitorBuilder disableDataProtection() {
            this.disableDataProtection = true;
            return this;
        }

        @Override
        public FluxCapacitorBuilder disableAutomaticAggregateCaching() {
            this.disableAutomaticAggregateCaching = true;
            return this;
        }

        @Override
        public FluxCapacitorBuilder enableTrackingMetrics() {
            this.collectTrackingMetrics = true;
            return this;
        }

        @Override
        public FluxCapacitorBuilder makeApplicationInstance(boolean makeApplicationInstance) {
            this.makeApplicationInstance = makeApplicationInstance;
            return this;
        }

        @Override
        public FluxCapacitor build(@NonNull Client client) {
            HandlerInterceptor interceptor;
            if (client == null) {
                throw new NullPointerException("client is marked non-null but is null");
            }
            Map<MessageType, DispatchInterceptor> dispatchInterceptors = Arrays.stream(MessageType.values()).collect(Collectors.toMap(Function.identity(), m -> DispatchInterceptor.noOp()));
            Map<MessageType, HandlerInterceptor> handlerInterceptors = Arrays.stream(MessageType.values()).collect(Collectors.toMap(Function.identity(), m -> HandlerInterceptor.noOp()));
            HashMap<MessageType, List<BatchInterceptor>> batchInterceptors = new HashMap<MessageType, List<BatchInterceptor>>(this.customBatchInterceptors);
            HashMap<MessageType, List<ConsumerConfiguration>> consumerConfigurations = new HashMap<MessageType, List<ConsumerConfiguration>>(this.consumerConfigurations);
            DefaultKeyValueStore keyValueStore = new DefaultKeyValueStore(client.getKeyValueClient(), this.serializer);
            DefaultDocumentStore documentStore = new DefaultDocumentStore(client.getSearchClient(), this.documentSerializer);
            Arrays.stream(MessageType.values()).forEach(type -> dispatchInterceptors.computeIfPresent((MessageType)type, (t, i) -> i.andThen(this.messageRoutingInterceptor)));
            if (this.userProvider != null) {
                interceptor = new AuthenticatingInterceptor(this.userProvider);
                Stream.of(MessageType.COMMAND, MessageType.QUERY, MessageType.SCHEDULE).forEach(arg_0 -> Builder.lambda$build$15(dispatchInterceptors, (AuthenticatingInterceptor)interceptor, handlerInterceptors, arg_0));
            }
            if (!this.disableDataProtection) {
                interceptor = new DataProtectionInterceptor(keyValueStore, this.serializer);
                Stream.of(MessageType.COMMAND, MessageType.EVENT, MessageType.QUERY, MessageType.RESULT, MessageType.SCHEDULE).forEach(arg_0 -> Builder.lambda$build$18(dispatchInterceptors, (DataProtectionInterceptor)interceptor, handlerInterceptors, arg_0));
            }
            if (!this.disableMessageCorrelation) {
                CorrelatingInterceptor correlatingInterceptor = new CorrelatingInterceptor();
                Arrays.stream(MessageType.values()).forEach(type -> dispatchInterceptors.compute((MessageType)type, (t, i) -> correlatingInterceptor.andThen((DispatchInterceptor)i)));
            }
            if (!this.disablePayloadValidation) {
                Stream.of(MessageType.COMMAND, MessageType.QUERY).forEach(type -> handlerInterceptors.computeIfPresent((MessageType)type, (t, i) -> i.andThen(new ValidatingInterceptor())));
            }
            dispatchInterceptors.computeIfPresent(MessageType.SCHEDULE, (t, i) -> i.andThen(this.schedulingInterceptor));
            handlerInterceptors.computeIfPresent(MessageType.SCHEDULE, (t, i) -> i.andThen(this.schedulingInterceptor));
            if (this.collectTrackingMetrics) {
                TrackerMonitor batchInterceptor = new TrackerMonitor();
                HandlerMonitor handlerMonitor = new HandlerMonitor();
                Arrays.stream(MessageType.values()).forEach(type -> {
                    consumerConfigurations.computeIfPresent((MessageType)type, (t, list) -> t == MessageType.METRICS ? list : list.stream().map(c -> c.toBuilder().batchInterceptor(batchInterceptor).build()).collect(Collectors.toList()));
                    handlerInterceptors.compute((MessageType)type, (t, i) -> t == MessageType.METRICS ? i : handlerMonitor.andThen((HandlerInterceptor)i));
                });
            }
            this.lowPrioDispatchInterceptors.forEach((messageType, interceptors) -> interceptors.forEach(interceptor -> dispatchInterceptors.computeIfPresent((MessageType)messageType, (t, i) -> i.andThen((DispatchInterceptor)interceptor))));
            this.highPrioDispatchInterceptors.forEach((messageType, interceptors) -> interceptors.forEach(interceptor -> dispatchInterceptors.computeIfPresent((MessageType)messageType, (t, i) -> interceptor.andThen((DispatchInterceptor)i))));
            this.lowPrioHandlerInterceptors.forEach((messageType, interceptors) -> interceptors.forEach(interceptor -> handlerInterceptors.computeIfPresent((MessageType)messageType, (t, i) -> i.andThen((HandlerInterceptor)interceptor))));
            this.highPrioHandlerInterceptors.forEach((messageType, interceptors) -> interceptors.forEach(interceptor -> handlerInterceptors.computeIfPresent((MessageType)messageType, (t, i) -> interceptor.andThen((HandlerInterceptor)i))));
            DefaultEventSourcingHandlerFactory eventSourcingHandlerFactory = new DefaultEventSourcingHandlerFactory(this.parameterResolvers);
            DefaultEventStore eventStore = new DefaultEventStore(client.getEventStoreClient(), this.serializer, dispatchInterceptors.get(MessageType.EVENT), this.localHandlerRegistry(MessageType.EVENT, handlerInterceptors));
            DefaultSnapshotStore snapshotRepository = new DefaultSnapshotStore(client.getKeyValueClient(), this.snapshotSerializer);
            NamedCache aggregateCache = new NamedCache(this.cache, id -> "$Aggregate:" + id);
            AggregateRepository aggregateRepository = new DefaultAggregateRepository(eventStore, snapshotRepository, aggregateCache, this.relationshipsCache, documentStore, this.serializer, dispatchInterceptors.get(MessageType.EVENT), eventSourcingHandlerFactory);
            if (!this.disableAutomaticAggregateCaching) {
                aggregateRepository = new CachingAggregateRepository(aggregateRepository, client, aggregateCache, this.relationshipsCache, this.serializer);
            }
            DefaultRequestHandler defaultRequestHandler = new DefaultRequestHandler(client, MessageType.RESULT);
            DefaultErrorGateway errorGateway = new DefaultErrorGateway(this.createRequestGateway(client, MessageType.ERROR, defaultRequestHandler, dispatchInterceptors, handlerInterceptors));
            if (!this.disableErrorReporting) {
                ErrorReportingInterceptor interceptor2 = new ErrorReportingInterceptor(errorGateway);
                Arrays.stream(MessageType.values()).forEach(type -> handlerInterceptors.compute((MessageType)type, (t, i) -> interceptor2.andThen((HandlerInterceptor)i)));
            }
            DefaultResultGateway resultGateway = new DefaultResultGateway(client.getGatewayClient(MessageType.RESULT), this.serializer, dispatchInterceptors.get(MessageType.RESULT));
            DefaultCommandGateway commandGateway = new DefaultCommandGateway(this.createRequestGateway(client, MessageType.COMMAND, defaultRequestHandler, dispatchInterceptors, handlerInterceptors));
            DefaultQueryGateway queryGateway = new DefaultQueryGateway(this.createRequestGateway(client, MessageType.QUERY, defaultRequestHandler, dispatchInterceptors, handlerInterceptors));
            DefaultEventGateway eventGateway = new DefaultEventGateway(this.createRequestGateway(client, MessageType.EVENT, defaultRequestHandler, dispatchInterceptors, handlerInterceptors));
            DefaultMetricsGateway metricsGateway = new DefaultMetricsGateway(this.createRequestGateway(client, MessageType.METRICS, defaultRequestHandler, dispatchInterceptors, handlerInterceptors));
            DefaultRequestHandler webRequestHandler = new DefaultRequestHandler(client, MessageType.WEBRESPONSE);
            DefaultWebRequestGateway webRequestGateway = new DefaultWebRequestGateway(this.createRequestGateway(client, MessageType.WEBREQUEST, webRequestHandler, dispatchInterceptors, handlerInterceptors));
            WebResponseGateway webResponseGateway = new WebResponseGateway(client.getGatewayClient(MessageType.WEBRESPONSE), this.serializer, dispatchInterceptors.get(MessageType.WEBRESPONSE), this.webResponseMapper);
            batchInterceptors.forEach((type, interceptors) -> consumerConfigurations.computeIfPresent((MessageType)type, (t, configs) -> configs.stream().map(c -> c.toBuilder().batchInterceptors((Collection<? extends BatchInterceptor>)interceptors).build()).collect(Collectors.toList())));
            Map<MessageType, Tracking> trackingMap = Arrays.stream(MessageType.values()).collect(Collectors.toMap(Function.identity(), m -> new DefaultTracking((MessageType)m, client, m == MessageType.WEBREQUEST ? webResponseGateway : resultGateway, (List)consumerConfigurations.get(m), this.serializer, new DefaultHandlerFactory((MessageType)m, (HandlerInterceptor)handlerInterceptors.get(m == MessageType.NOTIFICATION ? MessageType.EVENT : m), this.parameterResolvers))));
            DefaultScheduler scheduler = new DefaultScheduler(client.getSchedulingClient(), this.serializer, dispatchInterceptors.get(MessageType.SCHEDULE), this.localHandlerRegistry(MessageType.SCHEDULE, handlerInterceptors));
            Runnable shutdownHandler = () -> {
                ForkJoinPool shutdownPool = new ForkJoinPool(MessageType.values().length);
                Optional.ofNullable(this.forwardingWebConsumer).ifPresent(ForwardingWebConsumer::close);
                shutdownPool.invokeAll(trackingMap.values().stream().map(t -> () -> {
                    t.close();
                    return null;
                }).collect(Collectors.toList()));
                Runnable[] runnableArray = new Runnable[3];
                runnableArray[0] = commandGateway::close;
                runnableArray[1] = queryGateway::close;
                runnableArray[2] = webRequestGateway::close;
                shutdownPool.invokeAll(Stream.of(runnableArray).map(t -> () -> {
                    t.run();
                    return null;
                }).collect(Collectors.toList()));
                defaultRequestHandler.close();
                webRequestHandler.close();
                client.shutDown();
                shutdownPool.shutdown();
            };
            FluxCapacitor fluxCapacitor = this.doBuild(trackingMap, commandGateway, queryGateway, eventGateway, resultGateway, errorGateway, metricsGateway, webRequestGateway, aggregateRepository, eventStore, keyValueStore, documentStore, scheduler, this.userProvider, this.cache, this.serializer, this.correlationDataProvider, client, shutdownHandler);
            if (this.makeApplicationInstance) {
                FluxCapacitor.applicationInstance.set(fluxCapacitor);
            }
            Optional.ofNullable(this.forwardingWebConsumer).ifPresent(c -> c.start(client));
            if (!this.disableShutdownHook) {
                Runtime.getRuntime().addShutdownHook(new Thread(fluxCapacitor::close));
            }
            return fluxCapacitor;
        }

        protected FluxCapacitor doBuild(Map<MessageType, ? extends Tracking> trackingSupplier, CommandGateway commandGateway, QueryGateway queryGateway, EventGateway eventGateway, ResultGateway resultGateway, ErrorGateway errorGateway, MetricsGateway metricsGateway, WebRequestGateway webRequestGateway, AggregateRepository aggregateRepository, EventStore eventStore, KeyValueStore keyValueStore, DocumentStore documentStore, Scheduler scheduler, UserProvider userProvider, Cache cache, Serializer serializer, CorrelationDataProvider correlationDataProvider, Client client, Runnable shutdownHandler) {
            return new DefaultFluxCapacitor(trackingSupplier, commandGateway, queryGateway, eventGateway, resultGateway, errorGateway, metricsGateway, webRequestGateway, aggregateRepository, eventStore, keyValueStore, documentStore, scheduler, userProvider, cache, serializer, correlationDataProvider, client, shutdownHandler);
        }

        protected GenericGateway createRequestGateway(Client client, MessageType messageType, RequestHandler requestHandler, Map<MessageType, DispatchInterceptor> dispatchInterceptors, Map<MessageType, HandlerInterceptor> handlerInterceptors) {
            return new DefaultGenericGateway(client.getGatewayClient(messageType), requestHandler, this.serializer, dispatchInterceptors.get(messageType), messageType, this.localHandlerRegistry(messageType, handlerInterceptors));
        }

        protected HandlerRegistry localHandlerRegistry(MessageType messageType, Map<MessageType, HandlerInterceptor> handlerInterceptors) {
            LocalHandlerRegistry result = new LocalHandlerRegistry(messageType, new DefaultHandlerFactory(messageType, handlerInterceptors.get(messageType), this.parameterResolvers), this.serializer);
            return messageType == MessageType.EVENT ? result.merge(new LocalHandlerRegistry(MessageType.NOTIFICATION, new DefaultHandlerFactory(MessageType.NOTIFICATION, handlerInterceptors.get(MessageType.EVENT), this.parameterResolvers), this.serializer)) : result;
        }

        private static /* synthetic */ void lambda$build$18(Map dispatchInterceptors, DataProtectionInterceptor interceptor, Map handlerInterceptors, MessageType type) {
            dispatchInterceptors.computeIfPresent(type, (t, i) -> i.andThen(interceptor));
            handlerInterceptors.computeIfPresent(type, (t, i) -> i.andThen(interceptor));
        }

        private static /* synthetic */ void lambda$build$15(Map dispatchInterceptors, AuthenticatingInterceptor interceptor, Map handlerInterceptors, MessageType type) {
            dispatchInterceptors.computeIfPresent(type, (t, i) -> i.andThen(interceptor));
            handlerInterceptors.computeIfPresent(type, (t, i) -> i.andThen(interceptor));
        }
    }
}

