/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.modeling;

import com.google.common.collect.Sets;
import io.fluxcapacitor.common.api.modeling.Relationship;
import io.fluxcapacitor.javaclient.modeling.Entity;
import io.fluxcapacitor.javaclient.modeling.ReadOnlyAggregateRoot;
import java.time.Instant;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public interface AggregateRoot<T>
extends Entity<AggregateRoot<T>, T> {
    public static final ThreadLocal<Boolean> loading = ThreadLocal.withInitial(() -> false);
    public static final String AGGREGATE_ID_METADATA_KEY = "$aggregateId";
    public static final String AGGREGATE_TYPE_METADATA_KEY = "$aggregateType";

    public static boolean isLoading() {
        return loading.get();
    }

    public String lastEventId();

    public Long lastEventIndex();

    public Instant timestamp();

    public long sequenceNumber();

    public AggregateRoot<T> previous();

    default public AggregateRoot<T> playBackToEvent(String eventId) {
        return this.playBackToCondition(aggregate -> Objects.equals(eventId, aggregate.lastEventId())).orElseThrow(() -> new IllegalStateException(String.format("Could not load aggregate %s of type %s for event %s. Aggregate (%s) started at event %s", this.id(), this.type().getSimpleName(), eventId, this, this.lastEventId())));
    }

    default public Optional<AggregateRoot<T>> playBackToCondition(Predicate<AggregateRoot<T>> condition) {
        AggregateRoot<T> result;
        for (result = this; result != null && !condition.test(result); result = result.previous()) {
        }
        return Optional.ofNullable(result);
    }

    default public AggregateRoot<T> makeReadOnly() {
        if (this instanceof ReadOnlyAggregateRoot) {
            return this;
        }
        return new ReadOnlyAggregateRoot(this);
    }

    default public Set<Relationship> relationships() {
        String id = this.id().toString();
        String type = this.type().getName();
        return this.get() == null ? Collections.emptySet() : this.allEntities().stream().map(Entity::id).filter(Objects::nonNull).map(entityId -> Relationship.builder().entityId(entityId.toString()).aggregateType(type).aggregateId(id).build()).collect(Collectors.toSet());
    }

    default public Set<Relationship> associations(AggregateRoot<?> previous) {
        return Sets.difference(this.relationships(), previous.relationships());
    }

    default public Set<Relationship> dissociations(AggregateRoot<?> previous) {
        return Sets.difference(previous.relationships(), this.relationships());
    }
}

