/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.modeling;

import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.modeling.Entity;
import io.fluxcapacitor.javaclient.modeling.EntityId;
import io.fluxcapacitor.javaclient.modeling.ImmutableEntity;
import io.fluxcapacitor.javaclient.modeling.Member;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.EventSourcingHandlerFactory;
import java.beans.ConstructorProperties;
import java.beans.Introspector;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotatedEntityHolder
implements Entity.Holder {
    private static final Logger log = LoggerFactory.getLogger(AnnotatedEntityHolder.class);
    private static final Map<AccessibleObject, Entity.Holder> cache = new ConcurrentHashMap<AccessibleObject, Entity.Holder>();
    private static final Pattern getterPattern = Pattern.compile("(get|is)([A-Z].*)");
    private final AccessibleObject location;
    private final Class<?> ownerType;
    private final BiFunction<Object, Object, Object> wither;
    private final Class<?> holderType;
    private final Function<Object, Id> idProvider;
    private final Class<?> entityType;
    private final EventSourcingHandlerFactory handlerFactory;
    private final Serializer serializer;

    public static Entity.Holder getEntityHolder(Class<?> ownerType, AccessibleObject location, EventSourcingHandlerFactory handlerFactory, Serializer serializer) {
        return cache.computeIfAbsent(location, l -> new AnnotatedEntityHolder(ownerType, (AccessibleObject)l, handlerFactory, serializer));
    }

    private AnnotatedEntityHolder(Class<?> ownerType, AccessibleObject location, EventSourcingHandlerFactory handlerFactory, Serializer serializer) {
        this.handlerFactory = handlerFactory;
        this.serializer = serializer;
        this.location = location;
        this.ownerType = ownerType;
        this.holderType = ReflectionUtils.getPropertyType((AccessibleObject)location);
        this.entityType = ReflectionUtils.getCollectionElementType((AccessibleObject)location).orElse(this.holderType);
        Member member = location.getAnnotation(Member.class);
        String pathToId = member.idProperty();
        this.idProvider = pathToId.isBlank() ? v -> ReflectionUtils.getAnnotatedProperty((Object)v, EntityId.class).map(p -> new Id(Optional.ofNullable(ReflectionUtils.getValue((AccessibleObject)p, (Object)v)).orElse(null), ReflectionUtils.getName((AccessibleObject)p))).orElseGet(() -> {
            if (v instanceof Class) {
                return new Id(null, ReflectionUtils.getAnnotatedProperty((Class)((Class)v), EntityId.class).map(ReflectionUtils::getName).orElse(null));
            }
            return new Id(null, null);
        }) : v -> new Id(ReflectionUtils.readProperty((String)pathToId, (Object)v).orElse(null), pathToId);
        String propertyName = Introspector.decapitalize(Optional.of(ReflectionUtils.getName((AccessibleObject)location)).map(name -> Optional.of(getterPattern.matcher((CharSequence)name)).map(matcher -> matcher.matches() ? matcher.group(2) : name).orElse((String)name)).orElseThrow());
        Class[] witherParams = new Class[]{ReflectionUtils.getPropertyType((AccessibleObject)location)};
        Stream<Method> witherCandidates = ReflectionUtils.getAllMethods(this.ownerType).stream().filter(m -> m.getReturnType().isAssignableFrom(this.ownerType) || m.getReturnType().equals(Void.TYPE));
        witherCandidates = member.wither().isBlank() ? witherCandidates.filter(m -> Arrays.equals(witherParams, m.getParameterTypes()) && m.getName().toLowerCase().contains(propertyName.toLowerCase())) : witherCandidates.filter(m -> Objects.equals(member.wither(), m.getName()));
        Optional<BiFunction> wither = witherCandidates.findFirst().map(m -> (o, h) -> ObjectUtils.safelyCall(() -> m.invoke(o, h)));
        this.wither = wither.orElseGet(() -> {
            AtomicBoolean warningIssued = new AtomicBoolean();
            Field field = ReflectionUtils.getField((Class)ownerType, (String)propertyName).orElse(null);
            return (o, h) -> {
                block6: {
                    if (warningIssued.get()) {
                        return o;
                    }
                    if (field == null) {
                        if (warningIssued.compareAndSet(false, true)) {
                            log.warn("No update function found for @Member {}. Updates to enclosed entities won't automatically update the parent entity.", (Object)location);
                        }
                    } else {
                        try {
                            o = serializer.clone(o);
                            ReflectionUtils.setField((Field)field, (Object)o, (Object)h);
                        }
                        catch (Exception e) {
                            if (!warningIssued.compareAndSet(false, true)) break block6;
                            log.warn("Not able to update @Member {}. Please add a wither or setter method.", (Object)location, (Object)e);
                        }
                    }
                }
                return o;
            };
        });
    }

    @Override
    public Stream<Entity<?, ?>> getEntities(Object owner) {
        Class<?> type;
        Object holderValue = ReflectionUtils.getValue((AccessibleObject)this.location, (Object)owner);
        Class<?> clazz = type = holderValue == null ? this.holderType : holderValue.getClass();
        if (Collection.class.isAssignableFrom(type)) {
            if (holderValue == null) {
                return Stream.of(this.createEmptyEntity());
            }
            return Stream.concat(((Collection)holderValue).stream().flatMap(v -> this.createEntity(v, this.idProvider).stream()), Stream.of(this.createEmptyEntity()));
        }
        if (Map.class.isAssignableFrom(type)) {
            if (holderValue == null) {
                return Stream.of(this.createEmptyEntity());
            }
            return Stream.concat(((Map)holderValue).entrySet().stream().flatMap(e -> this.createEntity(e.getValue(), v -> new Id(e.getKey(), this.idProvider.apply(v).property())).stream()), Stream.of(this.createEmptyEntity()));
        }
        return this.createEntity(holderValue, this.idProvider).or(() -> Optional.of(this.createEmptyEntity())).stream();
    }

    private Optional<Entity<?, ?>> createEntity(Object member, Function<Object, Id> idProvider) {
        return Optional.ofNullable(member).map(m -> (Id)idProvider.apply(member)).map(id -> ImmutableEntity.builder().value(member).type(member.getClass()).handlerFactory(this.handlerFactory).serializer(this.serializer).id(id.value()).holder(this).idProperty(id.property()).build());
    }

    private Entity<?, ?> createEmptyEntity() {
        return ImmutableEntity.builder().type(this.entityType).handlerFactory(this.handlerFactory).serializer(this.serializer).holder(this).idProperty(this.idProvider.apply(this.entityType).property()).build();
    }

    @Override
    public Object updateOwner(Object owner, Entity<?, ?> before, Entity<?, ?> after) {
        Object holder = ReflectionUtils.getValue((AccessibleObject)this.location, (Object)owner);
        if (Collection.class.isAssignableFrom(this.holderType)) {
            Collection collection = (Collection)this.serializer.clone(holder);
            if (collection instanceof List) {
                List list = (List)collection;
                int index = list.indexOf(before.get());
                if (index < 0) {
                    list.add(after.get());
                } else if (after.get() == null) {
                    list.remove(index);
                } else {
                    list.set(index, after.get());
                }
                holder = list;
            } else {
                collection.remove(before.get());
                collection.add(after.get());
                holder = collection;
            }
        } else if (Map.class.isAssignableFrom(this.holderType)) {
            Map map = (Map)this.serializer.clone(holder);
            Object id = Optional.ofNullable(after.id()).orElseGet(() -> this.idProvider.apply(after.get()).value());
            if (after.get() == null) {
                map.remove(id);
            } else {
                map.put(id, after.get());
            }
            holder = map;
        } else {
            holder = after.get();
        }
        Object result = this.wither.apply(owner, holder);
        return result == null ? owner : result;
    }

    private static final class Id {
        private final Object value;
        private final String property;

        @ConstructorProperties(value={"value", "property"})
        public Id(Object value, String property) {
            this.value = value;
            this.property = property;
        }

        public Object value() {
            return this.value;
        }

        public String property() {
            return this.property;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Id)) {
                return false;
            }
            Id other = (Id)o;
            Object this$value = this.value();
            Object other$value = other.value();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            String this$property = this.property();
            String other$property = other.property();
            return !(this$property == null ? other$property != null : !this$property.equals(other$property));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $value = this.value();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            String $property = this.property();
            result = result * 59 + ($property == null ? 43 : $property.hashCode());
            return result;
        }

        public String toString() {
            return "AnnotatedEntityHolder.Id(value=" + this.value() + ", property=" + this.property() + ")";
        }
    }
}

