/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.modeling;

import io.fluxcapacitor.javaclient.modeling.AggregateRoot;
import io.fluxcapacitor.javaclient.modeling.Entity;
import java.time.Instant;
import java.util.Collection;
import lombok.NonNull;

public abstract class DelegatingAggregateRoot<T, A extends AggregateRoot<T>>
implements AggregateRoot<T> {
    protected A delegate;

    public DelegatingAggregateRoot(@NonNull A delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        this.delegate = delegate;
    }

    @Override
    public <E extends Exception> AggregateRoot<T> assertLegal(Object ... commands) throws E {
        this.delegate.assertLegal(commands);
        return this;
    }

    @Override
    public Object id() {
        return this.delegate.id();
    }

    @Override
    public Class<T> type() {
        return this.delegate.type();
    }

    @Override
    public T get() {
        return this.delegate.get();
    }

    @Override
    public Entity.Holder holder() {
        return this.delegate.holder();
    }

    @Override
    public String idProperty() {
        return this.delegate.idProperty();
    }

    @Override
    public String lastEventId() {
        return this.delegate.lastEventId();
    }

    @Override
    public Long lastEventIndex() {
        return this.delegate.lastEventIndex();
    }

    @Override
    public Instant timestamp() {
        return this.delegate.timestamp();
    }

    @Override
    public long sequenceNumber() {
        return this.delegate.sequenceNumber();
    }

    @Override
    public AggregateRoot<T> previous() {
        return this.delegate.previous();
    }

    @Override
    public Collection<Entity<?, ?>> entities() {
        return this.delegate.entities();
    }

    public A getDelegate() {
        return this.delegate;
    }
}

