/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.modeling;

import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.publishing.routing.RoutingKey;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Entity<M extends Entity<M, T>, T> {
    public Object id();

    public Class<T> type();

    public T get();

    public String idProperty();

    public Holder holder();

    public Collection<Entity<?, ?>> entities();

    default public Collection<Entity<?, ?>> allEntities() {
        return Stream.concat(Stream.of(this), this.entities().stream().flatMap(e -> e.allEntities().stream())).collect(Collectors.toUnmodifiableList());
    }

    default public Optional<Entity<?, ?>> getEntity(String entityId) {
        return this.allEntities().stream().filter(e -> entityId.equals(e.id())).findFirst();
    }

    default public M apply(Object ... events) {
        return this.apply(List.of(events));
    }

    default public M apply(Collection<?> events) {
        Entity<M, T> result = this;
        for (Object event : events) {
            result = this.apply(event);
        }
        return (M)result;
    }

    default public M apply(Object event) {
        if (event instanceof DeserializingMessage) {
            return this.apply(((DeserializingMessage)event).toMessage());
        }
        return this.apply(Message.asMessage(event));
    }

    default public M apply(Object event, Metadata metadata) {
        return this.apply(new Message(event, metadata));
    }

    public M apply(Message var1);

    public M update(UnaryOperator<T> var1);

    default public <E extends Exception> M assertLegal(Object command) throws E {
        if (command instanceof Collection) {
            return this.assertLegal(((Collection)command).toArray());
        }
        return this.assertLegal(new Object[]{command});
    }

    public <E extends Exception> M assertLegal(Object ... var1) throws E;

    default public boolean isPossibleTarget(Object message) {
        Object payload;
        if (message == null) {
            return false;
        }
        if (this.entities().stream().anyMatch(e -> e.isPossibleTarget(message))) {
            return true;
        }
        String idProperty = this.idProperty();
        Object id = this.id();
        if (idProperty == null) {
            return true;
        }
        if (id == null && this.get() != null) {
            return false;
        }
        Object object = payload = message instanceof Message ? ((Message)message).getPayload() : message;
        if (id == null) {
            return ReflectionUtils.hasProperty((String)idProperty, (Object)payload);
        }
        return ReflectionUtils.readProperty((String)idProperty, (Object)payload).or(() -> ReflectionUtils.getAnnotatedPropertyValue((Object)payload, RoutingKey.class)).map(id::equals).orElse(false);
    }

    default public <E extends Exception> M assertThat(Validator<T, E> validator) throws E {
        validator.validate(this.get());
        return (M)this;
    }

    default public <E extends Exception> M ensure(Predicate<T> check, Function<T, E> errorProvider) throws E {
        if (!check.test(this.get())) {
            throw (Exception)errorProvider.apply(this.get());
        }
        return (M)this;
    }

    @FunctionalInterface
    public static interface Validator<T, E extends Exception> {
        public void validate(T var1) throws E;
    }

    public static interface Holder {
        public Stream<Entity<?, ?>> getEntities(Object var1);

        public Object updateOwner(Object var1, Entity<?, ?> var2, Entity<?, ?> var3);
    }
}

