/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.modeling;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.modeling.AggregateRoot;
import io.fluxcapacitor.javaclient.modeling.Entity;
import io.fluxcapacitor.javaclient.modeling.ImmutableEntity;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.EventSourcingHandlerFactory;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;

public final class ImmutableAggregateRoot<T>
implements AggregateRoot<T> {
    @JsonProperty
    private final ImmutableEntity<T> delegate;
    @JsonProperty
    private final String lastEventId;
    @JsonProperty
    private final Long lastEventIndex;
    @JsonProperty
    private final Instant timestamp;
    @JsonProperty
    private final long sequenceNumber;
    private final transient ImmutableAggregateRoot<T> previous;

    public static <T> ImmutableAggregateRoot<T> from(AggregateRoot<T> a, EventSourcingHandlerFactory handlerFactory, Serializer serializer) {
        if (a == null) {
            return null;
        }
        return ImmutableAggregateRoot.builder().delegate(ImmutableEntity.builder().handlerFactory(handlerFactory).serializer(serializer).id(a.id()).value(a.get()).type(a.type()).idProperty(a.idProperty()).build()).lastEventId(a.lastEventId()).lastEventIndex(a.lastEventIndex()).timestamp(a.timestamp()).sequenceNumber(a.sequenceNumber()).previous(ImmutableAggregateRoot.from(a.previous(), handlerFactory, serializer)).build();
    }

    @Override
    public ImmutableAggregateRoot<T> apply(Message message) {
        return this.apply(new DeserializingMessage(message.serialize(this.delegate.serializer()), type -> this.delegate.serializer().convert(message.getPayload(), type), MessageType.EVENT));
    }

    public ImmutableAggregateRoot<T> apply(DeserializingMessage message) {
        return this.toBuilder().delegate(this.delegate.apply(message)).previous(this).timestamp(message.getTimestamp()).lastEventId(message.getMessageId()).lastEventIndex(message.getIndex()).sequenceNumber(this.sequenceNumber() + 1L).build();
    }

    @Override
    public AggregateRoot<T> apply(Object event) {
        if (event instanceof DeserializingMessage) {
            return this.apply((DeserializingMessage)event);
        }
        return this.apply(Message.asMessage(event));
    }

    @Override
    public ImmutableAggregateRoot<T> update(UnaryOperator<T> function) {
        return this.toBuilder().delegate((ImmutableEntity<T>)this.delegate.update((UnaryOperator)function)).previous(this).timestamp(FluxCapacitor.currentClock().instant()).build();
    }

    @Override
    public Object id() {
        return this.delegate().id();
    }

    @Override
    public Class<T> type() {
        return this.delegate().type();
    }

    @Override
    public T get() {
        return this.delegate.get();
    }

    @Override
    public String idProperty() {
        return this.delegate.idProperty();
    }

    @Override
    public Entity.Holder holder() {
        return this.delegate.holder();
    }

    @Override
    public Collection<Entity<?, ?>> entities() {
        return this.delegate.entities();
    }

    @Override
    public <E extends Exception> AggregateRoot<T> assertLegal(Object ... commands) throws E {
        this.delegate.assertLegal(commands);
        return this;
    }

    public ImmutableAggregateRoot<T> withEventIndex(Long index, String messageId) {
        if (Objects.equals(messageId, this.lastEventId)) {
            return this.lastEventIndex == null ? this.withLastEventIndex(index) : this;
        }
        return this.withPrevious(this.previous.withEventIndex(index, messageId));
    }

    public Long highestEventIndex() {
        return Optional.ofNullable(this.lastEventIndex).or(() -> Optional.ofNullable(this.previous).map(ImmutableAggregateRoot::highestEventIndex)).orElse(null);
    }

    private static <T> Instant $default$timestamp() {
        return FluxCapacitor.currentClock().instant();
    }

    private static <T> long $default$sequenceNumber() {
        return -1L;
    }

    @ConstructorProperties(value={"delegate", "lastEventId", "lastEventIndex", "timestamp", "sequenceNumber", "previous"})
    ImmutableAggregateRoot(ImmutableEntity<T> delegate, String lastEventId, Long lastEventIndex, Instant timestamp, long sequenceNumber, ImmutableAggregateRoot<T> previous) {
        this.delegate = delegate;
        this.lastEventId = lastEventId;
        this.lastEventIndex = lastEventIndex;
        this.timestamp = timestamp;
        this.sequenceNumber = sequenceNumber;
        this.previous = previous;
    }

    public static <T> ImmutableAggregateRootBuilder<T> builder() {
        return new ImmutableAggregateRootBuilder();
    }

    public ImmutableAggregateRootBuilder<T> toBuilder() {
        return new ImmutableAggregateRootBuilder<T>().delegate(this.delegate).lastEventId(this.lastEventId).lastEventIndex(this.lastEventIndex).timestamp(this.timestamp).sequenceNumber(this.sequenceNumber).previous(this.previous);
    }

    public ImmutableEntity<T> delegate() {
        return this.delegate;
    }

    @Override
    public String lastEventId() {
        return this.lastEventId;
    }

    @Override
    public Long lastEventIndex() {
        return this.lastEventIndex;
    }

    @Override
    public Instant timestamp() {
        return this.timestamp;
    }

    @Override
    public long sequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public ImmutableAggregateRoot<T> previous() {
        return this.previous;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImmutableAggregateRoot)) {
            return false;
        }
        ImmutableAggregateRoot other = (ImmutableAggregateRoot)o;
        if (this.sequenceNumber() != other.sequenceNumber()) {
            return false;
        }
        Long this$lastEventIndex = this.lastEventIndex();
        Long other$lastEventIndex = other.lastEventIndex();
        if (this$lastEventIndex == null ? other$lastEventIndex != null : !((Object)this$lastEventIndex).equals(other$lastEventIndex)) {
            return false;
        }
        ImmutableEntity<T> this$delegate = this.delegate();
        ImmutableEntity<T> other$delegate = other.delegate();
        if (this$delegate == null ? other$delegate != null : !((Object)this$delegate).equals(other$delegate)) {
            return false;
        }
        String this$lastEventId = this.lastEventId();
        String other$lastEventId = other.lastEventId();
        if (this$lastEventId == null ? other$lastEventId != null : !this$lastEventId.equals(other$lastEventId)) {
            return false;
        }
        Instant this$timestamp = this.timestamp();
        Instant other$timestamp = other.timestamp();
        return !(this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $sequenceNumber = this.sequenceNumber();
        result = result * 59 + (int)($sequenceNumber >>> 32 ^ $sequenceNumber);
        Long $lastEventIndex = this.lastEventIndex();
        result = result * 59 + ($lastEventIndex == null ? 43 : ((Object)$lastEventIndex).hashCode());
        ImmutableEntity<T> $delegate = this.delegate();
        result = result * 59 + ($delegate == null ? 43 : ((Object)$delegate).hashCode());
        String $lastEventId = this.lastEventId();
        result = result * 59 + ($lastEventId == null ? 43 : $lastEventId.hashCode());
        Instant $timestamp = this.timestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        return result;
    }

    public String toString() {
        return "ImmutableAggregateRoot(delegate=" + this.delegate() + ", lastEventId=" + this.lastEventId() + ", lastEventIndex=" + this.lastEventIndex() + ", timestamp=" + this.timestamp() + ", sequenceNumber=" + this.sequenceNumber() + ")";
    }

    public ImmutableAggregateRoot<T> withLastEventIndex(Long lastEventIndex) {
        return this.lastEventIndex == lastEventIndex ? this : new ImmutableAggregateRoot<T>(this.delegate, this.lastEventId, lastEventIndex, this.timestamp, this.sequenceNumber, this.previous);
    }

    public ImmutableAggregateRoot<T> withPrevious(ImmutableAggregateRoot<T> previous) {
        return this.previous == previous ? this : new ImmutableAggregateRoot<T>(this.delegate, this.lastEventId, this.lastEventIndex, this.timestamp, this.sequenceNumber, previous);
    }

    public static class ImmutableAggregateRootBuilder<T> {
        private ImmutableEntity<T> delegate;
        private String lastEventId;
        private Long lastEventIndex;
        private boolean timestamp$set;
        private Instant timestamp$value;
        private boolean sequenceNumber$set;
        private long sequenceNumber$value;
        private ImmutableAggregateRoot<T> previous;

        ImmutableAggregateRootBuilder() {
        }

        @JsonProperty
        public ImmutableAggregateRootBuilder<T> delegate(ImmutableEntity<T> delegate) {
            this.delegate = delegate;
            return this;
        }

        @JsonProperty
        public ImmutableAggregateRootBuilder<T> lastEventId(String lastEventId) {
            this.lastEventId = lastEventId;
            return this;
        }

        @JsonProperty
        public ImmutableAggregateRootBuilder<T> lastEventIndex(Long lastEventIndex) {
            this.lastEventIndex = lastEventIndex;
            return this;
        }

        @JsonProperty
        public ImmutableAggregateRootBuilder<T> timestamp(Instant timestamp) {
            this.timestamp$value = timestamp;
            this.timestamp$set = true;
            return this;
        }

        @JsonProperty
        public ImmutableAggregateRootBuilder<T> sequenceNumber(long sequenceNumber) {
            this.sequenceNumber$value = sequenceNumber;
            this.sequenceNumber$set = true;
            return this;
        }

        public ImmutableAggregateRootBuilder<T> previous(ImmutableAggregateRoot<T> previous) {
            this.previous = previous;
            return this;
        }

        public ImmutableAggregateRoot<T> build() {
            Instant timestamp$value = this.timestamp$value;
            if (!this.timestamp$set) {
                timestamp$value = ImmutableAggregateRoot.$default$timestamp();
            }
            long sequenceNumber$value = this.sequenceNumber$value;
            if (!this.sequenceNumber$set) {
                sequenceNumber$value = ImmutableAggregateRoot.$default$sequenceNumber();
            }
            return new ImmutableAggregateRoot<T>(this.delegate, this.lastEventId, this.lastEventIndex, timestamp$value, sequenceNumber$value, this.previous);
        }

        public String toString() {
            return "ImmutableAggregateRoot.ImmutableAggregateRootBuilder(delegate=" + this.delegate + ", lastEventId=" + this.lastEventId + ", lastEventIndex=" + this.lastEventIndex + ", timestamp$value=" + this.timestamp$value + ", sequenceNumber$value=" + this.sequenceNumber$value + ", previous=" + this.previous + ")";
        }
    }
}

