/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.modeling;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.modeling.AnnotatedEntityHolder;
import io.fluxcapacitor.javaclient.modeling.Entity;
import io.fluxcapacitor.javaclient.modeling.Member;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.EventSourcingHandlerFactory;
import io.fluxcapacitor.javaclient.tracking.handling.validation.ValidationUtils;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImmutableEntity<T>
implements Entity<ImmutableEntity<T>, T> {
    private static final Logger log = LoggerFactory.getLogger(ImmutableEntity.class);
    @JsonProperty
    private final Object id;
    @JsonProperty
    private final Class<T> type;
    @JsonProperty
    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="type")
    private final T value;
    @JsonProperty
    private final String idProperty;
    private final transient Entity.Holder holder;
    private final transient EventSourcingHandlerFactory handlerFactory;
    private final transient Serializer serializer;
    private final AtomicReference<Object> entities = new AtomicReference();
    private final AtomicReference<Object> allEntities = new AtomicReference();

    @Override
    public Class<T> type() {
        return this.value == null ? this.type : this.value.getClass();
    }

    @Override
    public T get() {
        return this.value;
    }

    private Collection<Entity<?, ?>> computeEntities() {
        Class<Object> type = this.value == null ? this.type() : this.value.getClass();
        return ReflectionUtils.getAnnotatedProperties(type, Member.class).stream().flatMap(location -> AnnotatedEntityHolder.getEntityHolder(type, location, this.handlerFactory, this.serializer).getEntities(this.value)).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public ImmutableEntity<T> apply(Message message) {
        return this.apply(new DeserializingMessage(message.serialize(this.serializer), type -> this.serializer.convert(message.getPayload(), type), MessageType.EVENT));
    }

    @Override
    public ImmutableEntity<T> apply(Object event) {
        if (event instanceof DeserializingMessage) {
            return this.apply((DeserializingMessage)event);
        }
        return this.apply(Message.asMessage(event));
    }

    @Override
    public ImmutableEntity<T> update(UnaryOperator<T> function) {
        return this.toBuilder().value(function.apply(this.get())).build();
    }

    public ImmutableEntity<T> apply(DeserializingMessage message) {
        ImmutableEntity<Object> result = this.toBuilder().value(this.handlerFactory.forType(this.type()).invoke(this, message)).build();
        Object payload = message.getPayload();
        Iterator iterator = result.possibleTargets(payload).iterator();
        while (iterator.hasNext()) {
            Object updated;
            Entity entity = (Entity)iterator.next();
            if (!entity.isPossibleTarget(payload) || Objects.equals(updated = entity.apply((Object)message), entity)) continue;
            result = result.toBuilder().value(entity.holder().updateOwner(result.get(), entity, (Entity<?, ?>)updated)).build();
        }
        return result;
    }

    @Override
    public <E extends Exception> ImmutableEntity<T> assertLegal(Object ... commands) throws E {
        if (commands.length > 0) {
            Entity<ImmutableEntity<T>, T> result = this;
            Iterator iterator = Arrays.stream(commands).iterator();
            while (iterator.hasNext()) {
                Object c = iterator.next();
                ValidationUtils.assertLegal(c, result);
                this.possibleTargets(c).forEach(e -> e.assertLegal(c));
                if (!iterator.hasNext()) continue;
                result = result.apply(Message.asMessage(c));
            }
        }
        return this;
    }

    Stream<Entity<?, ?>> possibleTargets(Object payload) {
        return this.entities().stream().collect(Collectors.groupingBy(Entity::holder)).values().stream().flatMap(group -> group.stream().filter(e -> e.isPossibleTarget(payload)).findFirst().stream());
    }

    @ConstructorProperties(value={"id", "type", "value", "idProperty", "holder", "handlerFactory", "serializer"})
    ImmutableEntity(Object id, Class<T> type, T value, String idProperty, Entity.Holder holder, EventSourcingHandlerFactory handlerFactory, Serializer serializer) {
        this.id = id;
        this.type = type;
        this.value = value;
        this.idProperty = idProperty;
        this.holder = holder;
        this.handlerFactory = handlerFactory;
        this.serializer = serializer;
    }

    public static <T> ImmutableEntityBuilder<T> builder() {
        return new ImmutableEntityBuilder();
    }

    public ImmutableEntityBuilder<T> toBuilder() {
        return new ImmutableEntityBuilder().id(this.id).type(this.type).value(this.value).idProperty(this.idProperty).holder(this.holder).handlerFactory(this.handlerFactory).serializer(this.serializer);
    }

    @Override
    public Object id() {
        return this.id;
    }

    public T value() {
        return this.value;
    }

    @Override
    public String idProperty() {
        return this.idProperty;
    }

    @Override
    public Entity.Holder holder() {
        return this.holder;
    }

    public EventSourcingHandlerFactory handlerFactory() {
        return this.handlerFactory;
    }

    public Serializer serializer() {
        return this.serializer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImmutableEntity)) {
            return false;
        }
        ImmutableEntity other = (ImmutableEntity)o;
        Object this$id = this.id();
        Object other$id = other.id();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Class<T> this$type = this.type();
        Class<T> other$type = other.type();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        T this$value = this.value();
        T other$value = other.value();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$idProperty = this.idProperty();
        String other$idProperty = other.idProperty();
        return !(this$idProperty == null ? other$idProperty != null : !this$idProperty.equals(other$idProperty));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $id = this.id();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Class<T> $type = this.type();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        T $value = this.value();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $idProperty = this.idProperty();
        result = result * 59 + ($idProperty == null ? 43 : $idProperty.hashCode());
        return result;
    }

    public String toString() {
        return "ImmutableEntity(id=" + this.id() + ", type=" + this.type() + ", value=" + this.value() + ", idProperty=" + this.idProperty() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Entity<?, ?>> entities() {
        Object value = this.entities.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.entities;
            synchronized (atomicReference) {
                value = this.entities.get();
                if (value == null) {
                    Collection<Entity<?, ?>> actualValue = this.computeEntities();
                    value = actualValue == null ? this.entities : actualValue;
                    this.entities.set(value);
                }
            }
        }
        return (Collection)(value == this.entities ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Entity<?, ?>> allEntities() {
        Object value = this.allEntities.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.allEntities;
            synchronized (atomicReference) {
                value = this.allEntities.get();
                if (value == null) {
                    Collection<Entity<?, ?>> actualValue = Entity.super.allEntities();
                    value = actualValue == null ? this.allEntities : actualValue;
                    this.allEntities.set(value);
                }
            }
        }
        return (Collection)(value == this.allEntities ? null : value);
    }

    public static class ImmutableEntityBuilder<T> {
        private Object id;
        private Class<T> type;
        private T value;
        private String idProperty;
        private Entity.Holder holder;
        private EventSourcingHandlerFactory handlerFactory;
        private Serializer serializer;

        ImmutableEntityBuilder() {
        }

        @JsonProperty
        public ImmutableEntityBuilder<T> id(Object id) {
            this.id = id;
            return this;
        }

        @JsonProperty
        public ImmutableEntityBuilder<T> type(Class<T> type) {
            this.type = type;
            return this;
        }

        @JsonProperty
        @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="type")
        public ImmutableEntityBuilder<T> value(T value) {
            this.value = value;
            return this;
        }

        @JsonProperty
        public ImmutableEntityBuilder<T> idProperty(String idProperty) {
            this.idProperty = idProperty;
            return this;
        }

        public ImmutableEntityBuilder<T> holder(Entity.Holder holder) {
            this.holder = holder;
            return this;
        }

        public ImmutableEntityBuilder<T> handlerFactory(EventSourcingHandlerFactory handlerFactory) {
            this.handlerFactory = handlerFactory;
            return this;
        }

        public ImmutableEntityBuilder<T> serializer(Serializer serializer) {
            this.serializer = serializer;
            return this;
        }

        public ImmutableEntity<T> build() {
            return new ImmutableEntity<T>(this.id, this.type, this.value, this.idProperty, this.holder, this.handlerFactory, this.serializer);
        }

        public String toString() {
            return "ImmutableEntity.ImmutableEntityBuilder(id=" + this.id + ", type=" + this.type + ", value=" + this.value + ", idProperty=" + this.idProperty + ", holder=" + this.holder + ", handlerFactory=" + this.handlerFactory + ", serializer=" + this.serializer + ")";
        }
    }
}

