/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.caching;

import com.google.common.cache.CacheBuilder;
import io.fluxcapacitor.javaclient.persisting.caching.Cache;
import java.beans.ConstructorProperties;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCache
implements Cache {
    private static final Logger log = LoggerFactory.getLogger(DefaultCache.class);
    private final ConcurrentMap<Object, Object> cache;

    public DefaultCache() {
        this(1000);
    }

    public DefaultCache(int maxSize) {
        this.cache = CacheBuilder.newBuilder().maximumSize((long)maxSize).build().asMap();
    }

    @Override
    public void put(Object id, @NonNull Object value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.cache.put(id, value);
    }

    @Override
    public void putIfAbsent(Object id, @NonNull Object value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.cache.putIfAbsent(id, value);
    }

    @Override
    public <T> T computeIfAbsent(Object id, Function<? super Object, T> mappingFunction) {
        return (T)this.cache.computeIfAbsent(id, mappingFunction);
    }

    @Override
    public <T> T computeIfPresent(Object id, BiFunction<? super Object, ? super T, ? extends T> mappingFunction) {
        return this.cache.computeIfPresent(id, mappingFunction);
    }

    @Override
    public <T> T compute(Object id, BiFunction<? super Object, ? super T, ? extends T> mappingFunction) {
        return this.cache.compute(id, mappingFunction);
    }

    @Override
    public <T> T getIfPresent(Object id) {
        return (T)this.cache.get(id);
    }

    @Override
    public void invalidate(Object id) {
        this.cache.remove(id);
    }

    @Override
    public void invalidateAll() {
        this.cache.clear();
    }

    @ConstructorProperties(value={"cache"})
    public DefaultCache(ConcurrentMap<Object, Object> cache) {
        this.cache = cache;
    }
}

