/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.caching;

import io.fluxcapacitor.javaclient.persisting.caching.Cache;
import java.beans.ConstructorProperties;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import lombok.NonNull;

public class NamedCache
implements Cache {
    private final Cache delegate;
    private final UnaryOperator<Object> idFunction;

    @Override
    public void put(Object id, @NonNull Object value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.delegate.put(this.idFunction.apply(id), value);
    }

    @Override
    public void putIfAbsent(Object id, @NonNull Object value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.delegate.putIfAbsent(this.idFunction.apply(id), value);
    }

    @Override
    public <T> T computeIfAbsent(Object id, Function<? super Object, T> mappingFunction) {
        return this.delegate.computeIfAbsent(this.idFunction.apply(id), mappingFunction);
    }

    @Override
    public <T> T computeIfPresent(Object id, BiFunction<? super Object, ? super T, ? extends T> mappingFunction) {
        return this.delegate.computeIfPresent(this.idFunction.apply(id), mappingFunction);
    }

    @Override
    public <T> T compute(Object id, BiFunction<? super Object, ? super T, ? extends T> mappingFunction) {
        return this.delegate.compute(this.idFunction.apply(id), mappingFunction);
    }

    @Override
    public <T> T getIfPresent(Object id) {
        return this.delegate.getIfPresent(this.idFunction.apply(id));
    }

    @Override
    public void invalidate(Object id) {
        this.delegate.invalidate(this.idFunction.apply(id));
    }

    @Override
    public void invalidateAll() {
        this.delegate.invalidateAll();
    }

    @ConstructorProperties(value={"delegate", "idFunction"})
    public NamedCache(Cache delegate, UnaryOperator<Object> idFunction) {
        this.delegate = delegate;
        this.idFunction = idFunction;
    }
}

