/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.caching;

import io.fluxcapacitor.javaclient.modeling.AggregateRoot;
import io.fluxcapacitor.javaclient.persisting.caching.Cache;
import io.fluxcapacitor.javaclient.persisting.caching.DefaultCache;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.NonNull;

public class SelectiveCache
implements Cache {
    private final Cache delegate;
    private final Predicate<Object> selector;
    private final Cache nextCache;

    public static Predicate<Object> aggregateSelector(Class<?> type) {
        return v -> {
            if (v instanceof AggregateRoot) {
                AggregateRoot aggregateRoot = (AggregateRoot)v;
                return Optional.ofNullable(aggregateRoot.get()).map(r -> type.isAssignableFrom(r.getClass())).orElseGet(() -> type.isAssignableFrom(aggregateRoot.type()));
            }
            return false;
        };
    }

    public SelectiveCache(Cache nextCache, Predicate<Object> selector) {
        this(new DefaultCache(), selector, nextCache);
    }

    @Override
    public void put(Object id, @NonNull Object value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (this.selector.test(value)) {
            this.delegate.put(id, value);
        } else {
            this.nextCache.put(id, value);
        }
    }

    @Override
    public void putIfAbsent(Object id, @NonNull Object value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (this.selector.test(value)) {
            this.delegate.putIfAbsent(id, value);
        } else {
            this.nextCache.putIfAbsent(id, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T computeIfAbsent(Object id, Function<? super Object, T> mappingFunction) {
        T result = this.getIfPresent(id);
        if (result == null) {
            SelectiveCache selectiveCache = this;
            synchronized (selectiveCache) {
                result = this.getIfPresent(id);
                if (result == null && (result = mappingFunction.apply(id)) != null) {
                    this.putIfAbsent(id, result);
                }
            }
        }
        return result;
    }

    @Override
    public <T> T computeIfPresent(Object id, BiFunction<? super Object, ? super T, ? extends T> mappingFunction) {
        T result = this.getIfPresent(id);
        if (result != null) {
            if (this.selector.test(result)) {
                return this.delegate.computeIfPresent(id, mappingFunction);
            }
            return this.nextCache.computeIfPresent(id, mappingFunction);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T compute(Object id, BiFunction<? super Object, ? super T, ? extends T> mappingFunction) {
        T result = this.computeIfPresent(id, mappingFunction);
        if (result == null) {
            SelectiveCache selectiveCache = this;
            synchronized (selectiveCache) {
                result = this.getIfPresent(id);
                result = mappingFunction.apply(id, result);
                if (result != null) {
                    this.put(id, result);
                } else {
                    this.invalidate(id);
                }
                return result;
            }
        }
        return result;
    }

    @Override
    public <T> T getIfPresent(Object id) {
        return (T)Optional.ofNullable(this.delegate.getIfPresent(id)).orElseGet(() -> this.nextCache.getIfPresent(id));
    }

    @Override
    public void invalidate(Object id) {
        this.delegate.invalidate(id);
        this.nextCache.invalidate(id);
    }

    @Override
    public void invalidateAll() {
        this.delegate.invalidateAll();
        this.nextCache.invalidateAll();
    }

    @ConstructorProperties(value={"delegate", "selector", "nextCache"})
    public SelectiveCache(Cache delegate, Predicate<Object> selector, Cache nextCache) {
        this.delegate = delegate;
        this.selector = selector;
        this.nextCache = nextCache;
    }
}

