/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.eventsourcing;

import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.handling.HandlerConfiguration;
import io.fluxcapacitor.common.handling.HandlerInspector;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.common.handling.HandlerNotFoundException;
import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.modeling.Entity;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.Apply;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.ApplyEvent;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.EventSourcingHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class AnnotatedEventSourcingHandler<T>
implements EventSourcingHandler<T> {
    private final Class<? extends T> handlerType;
    private final HandlerInvoker<DeserializingMessage> aggregateInvoker;
    private final EventSourcingAggregateParameterResolver<T> aggregateResolver = new EventSourcingAggregateParameterResolver();
    private final Function<Class<?>, HandlerInvoker<DeserializingMessage>> eventInvokers;

    public AnnotatedEventSourcingHandler(Class<? extends T> handlerType) {
        this(handlerType, DeserializingMessage.defaultParameterResolvers);
    }

    public AnnotatedEventSourcingHandler(Class<? extends T> handlerType, List<ParameterResolver<? super DeserializingMessage>> parameterResolvers) {
        this.handlerType = handlerType;
        this.aggregateInvoker = HandlerInspector.inspect(handlerType, parameterResolvers, (HandlerConfiguration)HandlerConfiguration.builder().methodAnnotation(ApplyEvent.class).build());
        this.eventInvokers = ObjectUtils.memoize(eventType -> {
            ArrayList<EventSourcingAggregateParameterResolver<T>> paramResolvers = new ArrayList<EventSourcingAggregateParameterResolver<T>>(parameterResolvers);
            paramResolvers.add(0, this.aggregateResolver);
            return HandlerInspector.inspect((Class)eventType, paramResolvers, (HandlerConfiguration)HandlerConfiguration.builder().methodAnnotation(Apply.class).handlerFilter((type, executable) -> {
                if (executable instanceof Method) {
                    Class<?> returnType = ((Method)executable).getReturnType();
                    return handlerType.isAssignableFrom(returnType) || returnType.isAssignableFrom(handlerType) || returnType.equals(Void.TYPE);
                }
                return false;
            }).build());
        });
    }

    @Override
    public T invoke(Entity<?, T> entity, DeserializingMessage message) {
        return (T)message.apply(m -> {
            Object model = entity.get();
            try {
                Object result;
                HandlerInvoker<DeserializingMessage> invoker;
                boolean handledByAggregate;
                try {
                    this.aggregateResolver.setAggregate(entity);
                    handledByAggregate = this.aggregateInvoker.canHandle(model, m);
                    invoker = handledByAggregate ? this.aggregateInvoker : this.eventInvokers.apply(message.getPayloadClass());
                    result = invoker.invoke(handledByAggregate ? model : m.getPayload(), m);
                }
                catch (HandlerNotFoundException e) {
                    if (model == null && entity.holder() == null) {
                        throw new HandlerNotFoundException(String.format("Aggregate '%2$s' of type %1$s does not exist and no applicable method exists in %1$s or %3$s that would instantiate a new %1$s.", entity.type().getSimpleName(), entity.id(), message.getPayloadClass().getSimpleName()));
                    }
                    Object t = model;
                    this.aggregateResolver.removeAggregate();
                    return t;
                }
                if (model == null) {
                    T t = this.handlerType.cast(result);
                    return t;
                }
                if (this.handlerType.isInstance(result)) {
                    T t = this.handlerType.cast(result);
                    return t;
                }
                if (result == null && invoker.expectResult(handledByAggregate ? model : m.getPayload(), m)) {
                    Object var8_11 = null;
                    return var8_11;
                }
                Object t = model;
                return t;
            }
            finally {
                this.aggregateResolver.removeAggregate();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canHandle(Entity<?, T> entity, DeserializingMessage message) {
        try {
            this.aggregateResolver.setAggregate(entity);
            boolean bl = this.aggregateInvoker.canHandle(entity.get(), (Object)message) || this.eventInvokers.apply(message.getPayloadClass()).canHandle(message.getPayload(), (Object)message);
            return bl;
        }
        finally {
            this.aggregateResolver.removeAggregate();
        }
    }

    public static class EventSourcingAggregateParameterResolver<T>
    implements ParameterResolver<Object> {
        private final ThreadLocal<Entity<?, T>> currentAggregate = new ThreadLocal();

        public Function<Object, Object> resolve(Parameter parameter, Annotation methodAnnotation) {
            Class<T> aggregateType = this.currentAggregate.get().type();
            return parameter.getType().isAssignableFrom(aggregateType) || aggregateType.isAssignableFrom(parameter.getType()) ? m -> this.currentAggregate.get().get() : null;
        }

        public boolean matches(Parameter parameter, Annotation methodAnnotation, Object value) {
            return this.currentAggregate.get() != null && this.currentAggregate.get().get() != null && super.matches(parameter, methodAnnotation, value);
        }

        public boolean determinesSpecificity() {
            return true;
        }

        public void setAggregate(Entity<?, T> aggregate) {
            this.currentAggregate.set(aggregate);
        }

        public void removeAggregate() {
            this.currentAggregate.remove();
        }
    }
}

