/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.eventsourcing;

import io.fluxcapacitor.common.Awaitable;
import io.fluxcapacitor.common.ConsistentHashing;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.modeling.UpdateRelationships;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.AggregateEventStream;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.EventSourcingException;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.EventStore;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.client.EventStoreClient;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerRegistry;
import java.beans.ConstructorProperties;
import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEventStore
implements EventStore {
    private static final Logger log = LoggerFactory.getLogger(DefaultEventStore.class);
    private final EventStoreClient client;
    private final Serializer serializer;
    private final DispatchInterceptor dispatchInterceptor;
    private final HandlerRegistry localHandlerRegistry;

    @Override
    public Awaitable storeEvents(String aggregateId, List<?> events, boolean storeOnly) {
        Awaitable result;
        ArrayList messages = new ArrayList(events.size());
        try {
            int segment = ConsistentHashing.computeSegment((String)aggregateId);
            events.forEach(e -> {
                DeserializingMessage deserializingMessage;
                if (e instanceof DeserializingMessage) {
                    deserializingMessage = (DeserializingMessage)e;
                } else {
                    Message m = this.dispatchInterceptor.interceptDispatch(Message.asMessage(e), MessageType.EVENT);
                    SerializedMessage serializedMessage = this.dispatchInterceptor.modifySerializedMessage(m.serialize(this.serializer), m, MessageType.EVENT);
                    deserializingMessage = new DeserializingMessage(serializedMessage, type -> m.getPayload(), MessageType.EVENT);
                }
                messages.add(deserializingMessage);
            });
            result = this.client.storeEvents(aggregateId, messages.stream().map(m -> m.getSerializedObject().getSegment() == null ? m.getSerializedObject().withSegment(Integer.valueOf(segment)) : m.getSerializedObject()).collect(Collectors.toList()), storeOnly);
        }
        catch (Exception e2) {
            throw new EventSourcingException(String.format("Failed to store events %s for aggregate %s", events, aggregateId), e2);
        }
        messages.forEach(m -> this.localHandlerRegistry.handle(m.getPayload(), m.getSerializedObject()));
        return result;
    }

    @Override
    public AggregateEventStream<DeserializingMessage> getEvents(String aggregateId, long lastSequenceNumber) {
        try {
            AggregateEventStream<SerializedMessage> serializedEvents = this.client.getEvents(aggregateId, lastSequenceNumber);
            return serializedEvents.convert(stream -> this.serializer.deserializeMessages((Stream<SerializedMessage>)stream, MessageType.EVENT));
        }
        catch (Exception e) {
            throw new EventSourcingException(String.format("Failed to obtain events for aggregate %s", aggregateId), e);
        }
    }

    @Override
    public Awaitable updateRelationships(UpdateRelationships updateRelationships) {
        return this.client.updateRelationships(updateRelationships);
    }

    @Override
    public Map<String, Class<?>> getAggregatesFor(String entityId) {
        return this.client.getAggregateIds(entityId).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            try {
                return ReflectionUtils.classForName((String)this.serializer.upcastType((String)e.getValue()));
            }
            catch (Exception error) {
                log.error("Failed to get the aggregate class for type {} (aggregate id: {}, entity id: {}). Please register a type caster with the Serializer.", new Object[]{e.getValue(), e.getKey(), entityId, error});
                return Void.class;
            }
        }));
    }

    @ConstructorProperties(value={"client", "serializer", "dispatchInterceptor", "localHandlerRegistry"})
    public DefaultEventStore(EventStoreClient client, Serializer serializer, DispatchInterceptor dispatchInterceptor, HandlerRegistry localHandlerRegistry) {
        this.client = client;
        this.serializer = serializer;
        this.dispatchInterceptor = dispatchInterceptor;
        this.localHandlerRegistry = localHandlerRegistry;
    }

    public Optional<CompletableFuture<Message>> handle(Object payload, SerializedMessage serializedMessage) {
        return this.localHandlerRegistry.handle(payload, serializedMessage);
    }

    public HandlerRegistry merge(HandlerRegistry next) {
        return this.localHandlerRegistry.merge(next);
    }

    @Override
    public Registration registerHandler(Object target) {
        return this.localHandlerRegistry.registerHandler(target);
    }

    @Override
    public Registration registerHandler(Object target, BiPredicate<Class<?>, Executable> handlerFilter) {
        return this.localHandlerRegistry.registerHandler(target, handlerFilter);
    }
}

