/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.eventsourcing;

import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.modeling.AggregateRoot;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.SnapshotTrigger;
import java.util.List;

public class PeriodicSnapshotTrigger
implements SnapshotTrigger {
    private final int period;

    public PeriodicSnapshotTrigger(int period) {
        if (period < 1) {
            throw new IllegalArgumentException("Period should be at least 1");
        }
        this.period = period;
    }

    @Override
    public boolean shouldCreateSnapshot(AggregateRoot<?> model, List<DeserializingMessage> newEvents) {
        return this.periodIndex(model.sequenceNumber()) > this.periodIndex(model.sequenceNumber() - (long)newEvents.size());
    }

    protected long periodIndex(long sequenceNumber) {
        return (sequenceNumber + 1L) / (long)this.period;
    }
}

