/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.eventsourcing.client;

import io.fluxcapacitor.common.Awaitable;
import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.modeling.GetAggregateIds;
import io.fluxcapacitor.common.api.modeling.UpdateRelationships;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.AggregateEventStream;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.client.EventStoreClient;
import io.fluxcapacitor.javaclient.tracking.client.InMemoryMessageStore;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class InMemoryEventStoreClient
extends InMemoryMessageStore
implements EventStoreClient {
    private final Map<String, List<SerializedMessage>> appliedEvents = new ConcurrentHashMap<String, List<SerializedMessage>>();
    private final Map<String, Map<String, String>> relationships = new ConcurrentHashMap<String, Map<String, String>>();

    @Override
    public Awaitable storeEvents(String aggregateId, List<SerializedMessage> events, boolean storeOnly) {
        this.appliedEvents.computeIfAbsent(aggregateId, id -> new CopyOnWriteArrayList()).addAll(events);
        if (storeOnly) {
            return Awaitable.ready();
        }
        return super.send(Guarantee.SENT, events.toArray(new SerializedMessage[0]));
    }

    @Override
    public Awaitable updateRelationships(UpdateRelationships request) {
        request.getDissociations().forEach(r -> this.relationships.computeIfAbsent(r.getEntityId(), entityId -> new ConcurrentHashMap()).remove(r.getAggregateId()));
        request.getAssociations().forEach(r -> this.relationships.computeIfAbsent(r.getEntityId(), entityId -> new ConcurrentHashMap()).put(r.getAggregateId(), r.getAggregateType()));
        return Awaitable.ready();
    }

    @Override
    public AggregateEventStream<SerializedMessage> getEvents(String aggregateId, long lastSequenceNumber) {
        List events = this.appliedEvents.getOrDefault(aggregateId, Collections.emptyList());
        return new AggregateEventStream<SerializedMessage>(events.subList(Math.min(1 + (int)lastSequenceNumber, events.size()), events.size()).stream(), aggregateId, () -> (long)events.size() - 1L);
    }

    @Override
    public CompletableFuture<Boolean> deleteEvents(String aggregateId) {
        return CompletableFuture.completedFuture(this.appliedEvents.remove(aggregateId) != null);
    }

    @Override
    public Map<String, String> getAggregateIds(GetAggregateIds request) {
        return Map.copyOf(this.relationships.getOrDefault(request.getEntityId(), Collections.emptyMap()));
    }
}

