/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.keyvalue.client;

import io.fluxcapacitor.common.Awaitable;
import io.fluxcapacitor.common.Backlog;
import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.api.BooleanResult;
import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.common.api.JsonType;
import io.fluxcapacitor.common.api.Request;
import io.fluxcapacitor.common.api.keyvalue.DeleteValue;
import io.fluxcapacitor.common.api.keyvalue.GetValue;
import io.fluxcapacitor.common.api.keyvalue.GetValueResult;
import io.fluxcapacitor.common.api.keyvalue.KeyValuePair;
import io.fluxcapacitor.common.api.keyvalue.StoreValueIfAbsent;
import io.fluxcapacitor.common.api.keyvalue.StoreValues;
import io.fluxcapacitor.common.api.keyvalue.StoreValuesAndWait;
import io.fluxcapacitor.javaclient.common.websocket.AbstractWebsocketClient;
import io.fluxcapacitor.javaclient.configuration.client.WebSocketClient;
import io.fluxcapacitor.javaclient.persisting.keyvalue.client.KeyValueClient;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.websocket.ClientEndpoint;

@ClientEndpoint
public class WebsocketKeyValueClient
extends AbstractWebsocketClient
implements KeyValueClient {
    private final Backlog<KeyValuePair> backlog = new Backlog(this::storeValues);

    public WebsocketKeyValueClient(String endPointUrl, WebSocketClient.ClientConfig clientConfig) {
        this(URI.create(endPointUrl), clientConfig);
    }

    public WebsocketKeyValueClient(URI endpointUri, WebSocketClient.ClientConfig clientConfig) {
        super(endpointUri, clientConfig, true, clientConfig.getKeyValueSessions());
    }

    protected Awaitable storeValues(List<KeyValuePair> keyValuePairs) {
        return this.sendAndForget((JsonType)new StoreValues(keyValuePairs));
    }

    @Override
    public Awaitable putValue(String key, Data<byte[]> value, Guarantee guarantee) {
        switch (guarantee) {
            case NONE: {
                this.backlog.add((Object[])new KeyValuePair[]{new KeyValuePair(key, value)});
                return Awaitable.ready();
            }
            case SENT: {
                return this.backlog.add((Object[])new KeyValuePair[]{new KeyValuePair(key, value)});
            }
            case STORED: {
                this.sendAndWait((Request)new StoreValuesAndWait(Collections.singletonList(new KeyValuePair(key, value))));
                return Awaitable.ready();
            }
        }
        throw new UnsupportedOperationException("Unrecognized guarantee: " + guarantee);
    }

    @Override
    public CompletableFuture<Boolean> putValueIfAbsent(String key, Data<byte[]> value) {
        return this.send((Request)new StoreValueIfAbsent(new KeyValuePair(key, value))).thenApply(r -> ((BooleanResult)r).isSuccess());
    }

    @Override
    public Data<byte[]> getValue(String key) {
        GetValueResult result = (GetValueResult)this.sendAndWait((Request)new GetValue(key));
        return result.getValue();
    }

    @Override
    public Awaitable deleteValue(String key) {
        return this.sendAndForget((JsonType)new DeleteValue(key));
    }
}

