/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.search;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.api.search.BulkUpdate;
import io.fluxcapacitor.common.api.search.Constraint;
import io.fluxcapacitor.common.api.search.CreateAuditTrail;
import io.fluxcapacitor.common.api.search.DocumentStats;
import io.fluxcapacitor.common.api.search.GetDocument;
import io.fluxcapacitor.common.api.search.GetSearchHistogram;
import io.fluxcapacitor.common.api.search.SearchDocuments;
import io.fluxcapacitor.common.api.search.SearchHistogram;
import io.fluxcapacitor.common.api.search.SearchQuery;
import io.fluxcapacitor.common.api.search.SerializedDocument;
import io.fluxcapacitor.common.api.search.SerializedDocumentUpdate;
import io.fluxcapacitor.common.api.search.bulkupdate.IndexDocument;
import io.fluxcapacitor.common.api.search.bulkupdate.IndexDocumentIfNotExists;
import io.fluxcapacitor.common.search.Document;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.persisting.search.DocumentSerializer;
import io.fluxcapacitor.javaclient.persisting.search.DocumentStore;
import io.fluxcapacitor.javaclient.persisting.search.DocumentStoreException;
import io.fluxcapacitor.javaclient.persisting.search.Search;
import io.fluxcapacitor.javaclient.persisting.search.SearchHit;
import io.fluxcapacitor.javaclient.persisting.search.client.SearchClient;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDocumentStore
implements DocumentStore {
    private static final Logger log = LoggerFactory.getLogger(DefaultDocumentStore.class);
    private final SearchClient client;
    private final DocumentSerializer serializer;

    @Override
    public CompletableFuture<Void> index(Object object, String id, String collection, Instant begin, Instant end, Guarantee guarantee, boolean ifNotExists) {
        try {
            return this.client.index(Collections.singletonList(this.serializer.toDocument(object, id, collection, begin, end)), guarantee, ifNotExists).asCompletableFuture();
        }
        catch (Exception e) {
            throw new DocumentStoreException(String.format("Could not store a document %s for id %s", object, id), e);
        }
    }

    @Override
    public <T> CompletableFuture<Void> index(Collection<? extends T> objects, String collection, @Nullable String idPath, @Nullable String beginPath, @Nullable String endPath, Guarantee guarantee, boolean ifNotExists) {
        List<Document> documents = objects.stream().map(v -> this.serializer.toDocument(v, FluxCapacitor.currentIdentityProvider().nextTechnicalId(), collection, null, null)).map(d -> {
            Document.DocumentBuilder builder = d.toBuilder();
            if (idPath != null) {
                builder.id(d.getEntryAtPath(idPath).filter(e -> e.getType() == Document.EntryType.TEXT || e.getType() == Document.EntryType.NUMERIC).map(Document.Entry::getValue).orElseThrow(() -> new IllegalArgumentException("Could not determine the document id. Path does not exist on document: " + d)));
            }
            if (beginPath != null) {
                builder.timestamp((Instant)d.getEntryAtPath(beginPath).filter(e -> e.getType() == Document.EntryType.TEXT).map(Document.Entry::getValue).map(Instant::parse).orElse(null));
            }
            if (endPath != null) {
                builder.end((Instant)d.getEntryAtPath(endPath).filter(e -> e.getType() == Document.EntryType.TEXT).map(Document.Entry::getValue).map(Instant::parse).orElse(null));
            }
            return builder.build();
        }).collect(Collectors.toList());
        try {
            return this.client.index(documents, guarantee, ifNotExists).asCompletableFuture();
        }
        catch (Exception e) {
            throw new DocumentStoreException(String.format("Could not store a list of documents for collection %s", collection), e);
        }
    }

    @Override
    public <T> CompletableFuture<Void> index(Collection<? extends T> objects, String collection, Function<? super T, String> idFunction, Function<? super T, Instant> beginFunction, Function<? super T, Instant> endFunction, Guarantee guarantee, boolean ifNotExists) {
        List<Document> documents = objects.stream().map(v -> this.serializer.toDocument(v, (String)idFunction.apply(v), collection, (Instant)beginFunction.apply(v), (Instant)endFunction.apply(v))).collect(Collectors.toList());
        try {
            return this.client.index(documents, guarantee, ifNotExists).asCompletableFuture();
        }
        catch (Exception e) {
            throw new DocumentStoreException(String.format("Could not store a list of documents for collection %s", collection), e);
        }
    }

    @Override
    public CompletableFuture<Void> bulkUpdate(Collection<BulkUpdate> updates, Guarantee guarantee) {
        try {
            return this.client.bulkUpdate(updates.stream().map(this::serializeAction).filter(Objects::nonNull).collect(Collectors.toMap(a -> String.format("%s_%s", a.getCollection(), a.getId()), UnaryOperator.identity(), (a, b) -> b)).values(), guarantee).asCompletableFuture();
        }
        catch (Exception e) {
            throw new DocumentStoreException("Could not apply batch of search actions", e);
        }
    }

    public SerializedDocumentUpdate serializeAction(BulkUpdate update) {
        SerializedDocumentUpdate.Builder builder = SerializedDocumentUpdate.builder().collection(update.getCollection()).id(update.getId()).type(update.getType());
        if (update instanceof IndexDocument) {
            IndexDocument u = (IndexDocument)update;
            return builder.object(new SerializedDocument(this.serializer.toDocument(u.getObject(), u.getId(), u.getCollection(), u.getTimestamp(), u.getEnd()))).build();
        }
        if (update instanceof IndexDocumentIfNotExists) {
            IndexDocumentIfNotExists u = (IndexDocumentIfNotExists)update;
            return builder.object(new SerializedDocument(this.serializer.toDocument(u.getObject(), u.getId(), u.getCollection(), u.getTimestamp(), u.getEnd()))).build();
        }
        return builder.build();
    }

    @Override
    public Search search(SearchQuery.Builder searchBuilder) {
        return new DefaultSearch(searchBuilder);
    }

    @Override
    public <T> Optional<T> fetchDocument(String id, String collection) {
        try {
            return this.client.fetch(new GetDocument(id, collection)).map(this.serializer::fromDocument);
        }
        catch (Exception e) {
            throw new DocumentStoreException(String.format("Could not get document %s from collection %s", id, collection), e);
        }
    }

    @Override
    public <T> Optional<T> fetchDocument(String id, String collection, Class<T> type) {
        try {
            return this.client.fetch(new GetDocument(id, collection)).map(d -> this.serializer.fromDocument((Document)d, type));
        }
        catch (Exception e) {
            throw new DocumentStoreException(String.format("Could not get document %s from collection %s", id, collection), e);
        }
    }

    @Override
    public CompletableFuture<Void> deleteDocument(String id, String collection) {
        try {
            return this.client.delete(id, collection, Guarantee.STORED).asCompletableFuture();
        }
        catch (Exception e) {
            throw new DocumentStoreException(String.format("Could not delete document %s", collection), e);
        }
    }

    @Override
    public CompletableFuture<Void> deleteCollection(String collection) {
        try {
            return this.client.deleteCollection(collection).asCompletableFuture();
        }
        catch (Exception e) {
            throw new DocumentStoreException(String.format("Could not delete collection %s", collection), e);
        }
    }

    @Override
    public CompletableFuture<Void> createAuditTrail(String collection, Duration retentionTime) {
        try {
            return this.client.createAuditTrail(new CreateAuditTrail(collection, (Long)Optional.ofNullable(retentionTime).map(Duration::getSeconds).orElse(null))).asCompletableFuture();
        }
        catch (Exception e) {
            throw new DocumentStoreException(String.format("Could not create audit trail %s", collection), e);
        }
    }

    @ConstructorProperties(value={"client", "serializer"})
    public DefaultDocumentStore(SearchClient client, DocumentSerializer serializer) {
        this.client = client;
        this.serializer = serializer;
    }

    @Override
    public DocumentSerializer getSerializer() {
        return this.serializer;
    }

    private class DefaultSearch
    implements Search {
        private final SearchQuery.Builder queryBuilder;
        private final List<String> sorting = new ArrayList<String>();
        private final List<String> pathFilters = new ArrayList<String>();
        private volatile int skip;

        protected DefaultSearch() {
            this(SearchQuery.builder());
        }

        @Override
        public Search inPeriod(Instant start, Instant endExclusive, boolean requireTimestamp) {
            if (start != null) {
                this.queryBuilder.since(start);
            }
            if (endExclusive != null) {
                this.queryBuilder.before(endExclusive);
            }
            this.queryBuilder.requireTimestamp(requireTimestamp);
            return this;
        }

        @Override
        public Search constraint(Constraint ... constraints) {
            switch (constraints.length) {
                case 0: {
                    break;
                }
                case 1: {
                    this.queryBuilder.constraint(constraints[0]);
                    break;
                }
                default: {
                    this.queryBuilder.constraints(Arrays.asList(constraints));
                }
            }
            return this;
        }

        @Override
        public Search sortByTimestamp(boolean descending) {
            this.sorting.add(descending ? "-" : "timestamp");
            return this;
        }

        @Override
        public Search sortByScore() {
            this.sorting.add("-score");
            return this;
        }

        @Override
        public Search sortBy(String path, boolean descending) {
            this.sorting.add((descending ? "-" : "") + path);
            return this;
        }

        @Override
        public Search exclude(String ... paths) {
            this.pathFilters.addAll(Arrays.stream(paths).map(p -> "-" + p).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Search includeOnly(String ... paths) {
            this.pathFilters.addAll(Arrays.asList(paths));
            return this;
        }

        @Override
        public Search skip(Integer n) {
            if (n != null) {
                this.skip = n;
            }
            return this;
        }

        @Override
        public <T> Stream<SearchHit<T>> streamHits() {
            return this.fetchHitStream(null, null);
        }

        @Override
        public <T> Stream<SearchHit<T>> streamHits(Class<T> type) {
            return this.fetchHitStream(null, type);
        }

        @Override
        public <T> List<T> fetch(int maxSize) {
            return this.fetchHitStream(maxSize, null).map(SearchHit::getValue).collect(Collectors.toList());
        }

        @Override
        public <T> List<T> fetch(int maxSize, Class<T> type) {
            return this.fetchHitStream(maxSize, type).map(SearchHit::getValue).collect(Collectors.toList());
        }

        protected <T> Stream<SearchHit<T>> fetchHitStream(Integer maxSize, Class<T> type) {
            Function<Document, Object> convertFunction = type == null ? DefaultDocumentStore.this.serializer::fromDocument : document -> DefaultDocumentStore.this.serializer.fromDocument((Document)document, type);
            return DefaultDocumentStore.this.client.search(SearchDocuments.builder().query(this.queryBuilder.build()).maxSize(maxSize).sorting(this.sorting).pathFilters(this.pathFilters).skip(this.skip).build()).map(hit -> hit.map(convertFunction));
        }

        @Override
        public SearchHistogram fetchHistogram(int resolution, int maxSize) {
            return DefaultDocumentStore.this.client.fetchHistogram(new GetSearchHistogram(this.queryBuilder.build(), resolution, maxSize));
        }

        @Override
        public List<DocumentStats> fetchStatistics(List<String> fields, String ... groupBy) {
            return DefaultDocumentStore.this.client.fetchStatistics(this.queryBuilder.build(), fields, Arrays.asList(groupBy));
        }

        @Override
        public CompletableFuture<Void> delete() {
            return DefaultDocumentStore.this.client.delete(this.queryBuilder.build(), Guarantee.STORED).asCompletableFuture();
        }

        @ConstructorProperties(value={"queryBuilder"})
        public DefaultSearch(SearchQuery.Builder queryBuilder) {
            this.queryBuilder = queryBuilder;
        }
    }
}

