/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.publishing.routing;

import io.fluxcapacitor.common.ConsistentHashing;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import io.fluxcapacitor.javaclient.publishing.routing.RoutingKey;
import io.fluxcapacitor.javaclient.scheduling.Schedule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageRoutingInterceptor
implements DispatchInterceptor {
    private static final Logger log = LoggerFactory.getLogger(MessageRoutingInterceptor.class);

    @Override
    public Message interceptDispatch(Message message, MessageType messageType) {
        return message;
    }

    @Override
    public SerializedMessage modifySerializedMessage(SerializedMessage serializedMessage, Message m, MessageType messageType) {
        SerializedMessage result;
        Class<?> payloadType;
        RoutingKey typeAnnotation;
        if (m.getPayload() != null && (typeAnnotation = (payloadType = m.getPayload().getClass()).getAnnotation(RoutingKey.class)) != null) {
            String routingValue = m.getMetadata().get(typeAnnotation.metadataKey());
            if (routingValue == null) {
                log.warn("Did not find metadata routingValue for {} for routing key of message {} (id {})", new Object[]{typeAnnotation.metadataKey(), payloadType, m.getMessageId()});
            } else {
                serializedMessage.setSegment(Integer.valueOf(ConsistentHashing.computeSegment((String)routingValue)));
                return serializedMessage;
            }
        }
        if ((result = ReflectionUtils.getAnnotatedPropertyValue(m.getPayload(), RoutingKey.class).map(Object::toString).map(ConsistentHashing::computeSegment).map(s -> {
            serializedMessage.setSegment(s);
            return serializedMessage;
        }).orElse(serializedMessage)).getSegment() == null && m instanceof Schedule) {
            result.setSegment(Integer.valueOf(ConsistentHashing.computeSegment((String)((Schedule)m).getScheduleId())));
        }
        return result;
    }
}

