/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.scheduling;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.scheduling.SerializedSchedule;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import io.fluxcapacitor.javaclient.scheduling.Schedule;
import io.fluxcapacitor.javaclient.scheduling.Scheduler;
import io.fluxcapacitor.javaclient.scheduling.SchedulerException;
import io.fluxcapacitor.javaclient.scheduling.client.SchedulingClient;
import io.fluxcapacitor.javaclient.tracking.IndexUtils;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerRegistry;
import java.beans.ConstructorProperties;
import java.lang.reflect.Executable;
import java.util.function.BiPredicate;

public class DefaultScheduler
implements Scheduler {
    private final SchedulingClient client;
    private final Serializer serializer;
    private final DispatchInterceptor dispatchInterceptor;
    private final HandlerRegistry localHandlerRegistry;

    @Override
    public void schedule(Schedule message, boolean ifAbsent) {
        try {
            message = (Schedule)this.dispatchInterceptor.interceptDispatch(message, MessageType.SCHEDULE);
            SerializedMessage serializedMessage = this.dispatchInterceptor.modifySerializedMessage(message.serialize(this.serializer), message, MessageType.SCHEDULE);
            this.client.schedule(new SerializedSchedule(message.getScheduleId(), message.getDeadline().toEpochMilli(), serializedMessage, ifAbsent)).await();
        }
        catch (Exception e) {
            throw new SchedulerException(String.format("Failed to schedule message %s for %s", message.getPayload(), message.getDeadline()), e);
        }
    }

    @Override
    public void cancelSchedule(String scheduleId) {
        try {
            this.client.cancelSchedule(scheduleId).await();
        }
        catch (Exception e) {
            throw new SchedulerException(String.format("Failed to cancel schedule with id %s", scheduleId), e);
        }
    }

    public Registration registerHandler(Object target, BiPredicate<Class<?>, Executable> handlerFilter) {
        return this.localHandlerRegistry.registerHandler(target, handlerFilter);
    }

    public void handleLocally(Schedule schedule, SerializedMessage serializedMessage) {
        serializedMessage.setIndex(Long.valueOf(IndexUtils.indexFromTimestamp(schedule.getDeadline())));
        this.localHandlerRegistry.handle(schedule.getPayload(), serializedMessage);
    }

    @ConstructorProperties(value={"client", "serializer", "dispatchInterceptor", "localHandlerRegistry"})
    public DefaultScheduler(SchedulingClient client, Serializer serializer, DispatchInterceptor dispatchInterceptor, HandlerRegistry localHandlerRegistry) {
        this.client = client;
        this.serializer = serializer;
        this.dispatchInterceptor = dispatchInterceptor;
        this.localHandlerRegistry = localHandlerRegistry;
    }
}

