/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.scheduling;

import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.scheduling.Schedule;
import java.time.Duration;
import java.time.Instant;

public interface Scheduler {
    default public String schedule(Object schedule, Instant deadline) {
        String scheduleId = FluxCapacitor.currentIdentityProvider().nextTechnicalId();
        this.schedule(schedule, scheduleId, deadline);
        return scheduleId;
    }

    default public String schedule(Object schedule, Duration delay) {
        return this.schedule(schedule, FluxCapacitor.currentClock().instant().plus(delay));
    }

    default public void schedule(Object schedule, String scheduleId, Duration delay) {
        this.schedule(schedule, scheduleId, FluxCapacitor.currentClock().instant().plus(delay));
    }

    default public void schedule(Object schedulePayload, Metadata metadata, String scheduleId, Instant deadline) {
        this.schedule((Object)new Message(schedulePayload, metadata), scheduleId, deadline);
    }

    default public void schedule(Object schedulePayload, Metadata metadata, String scheduleId, Duration delay) {
        this.schedule((Object)new Message(schedulePayload, metadata), scheduleId, delay);
    }

    default public void schedule(Object schedule, String scheduleId, Instant deadline) {
        if (schedule instanceof Message) {
            Message message = (Message)schedule;
            this.schedule(new Schedule(message.getPayload(), message.getMetadata(), message.getMessageId(), message.getTimestamp(), scheduleId, deadline));
        } else {
            this.schedule(new Schedule(schedule, scheduleId, deadline));
        }
    }

    default public void schedule(Schedule message) {
        this.schedule(message, false);
    }

    public void schedule(Schedule var1, boolean var2);

    public void cancelSchedule(String var1);
}

