/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.scheduling.client;

import io.fluxcapacitor.common.Awaitable;
import io.fluxcapacitor.common.Backlog;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.JsonType;
import io.fluxcapacitor.common.api.scheduling.CancelSchedule;
import io.fluxcapacitor.common.api.scheduling.Schedule;
import io.fluxcapacitor.common.api.scheduling.SerializedSchedule;
import io.fluxcapacitor.javaclient.common.websocket.AbstractWebsocketClient;
import io.fluxcapacitor.javaclient.configuration.client.WebSocketClient;
import io.fluxcapacitor.javaclient.scheduling.client.SchedulingClient;
import java.net.URI;
import java.util.List;
import javax.websocket.ClientEndpoint;

@ClientEndpoint
public class WebsocketSchedulingClient
extends AbstractWebsocketClient
implements SchedulingClient {
    private final Backlog<SerializedSchedule> backlog = new Backlog(this::scheduleMessages);

    public WebsocketSchedulingClient(String endPointUrl, WebSocketClient.ClientConfig clientConfig) {
        this(URI.create(endPointUrl), clientConfig);
    }

    public WebsocketSchedulingClient(URI endpointUri, WebSocketClient.ClientConfig clientConfig) {
        super(endpointUri, clientConfig, true, clientConfig.getGatewaySessions().get(MessageType.SCHEDULE));
    }

    protected Awaitable scheduleMessages(List<SerializedSchedule> schedules) {
        return this.sendAndForget((JsonType)new Schedule(schedules));
    }

    @Override
    public Awaitable schedule(SerializedSchedule ... schedules) {
        return this.backlog.add((Object[])schedules);
    }

    @Override
    public Awaitable cancelSchedule(String scheduleId) {
        return this.sendAndForget((JsonType)new CancelSchedule(scheduleId));
    }
}

