/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.client;

import io.fluxcapacitor.common.Awaitable;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.JsonType;
import io.fluxcapacitor.common.api.Request;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.tracking.ClaimSegment;
import io.fluxcapacitor.common.api.tracking.ClaimSegmentResult;
import io.fluxcapacitor.common.api.tracking.DisconnectTracker;
import io.fluxcapacitor.common.api.tracking.GetPosition;
import io.fluxcapacitor.common.api.tracking.GetPositionResult;
import io.fluxcapacitor.common.api.tracking.MessageBatch;
import io.fluxcapacitor.common.api.tracking.Position;
import io.fluxcapacitor.common.api.tracking.Read;
import io.fluxcapacitor.common.api.tracking.ReadFromIndex;
import io.fluxcapacitor.common.api.tracking.ReadFromIndexResult;
import io.fluxcapacitor.common.api.tracking.ReadResult;
import io.fluxcapacitor.common.api.tracking.ResetPosition;
import io.fluxcapacitor.common.api.tracking.StorePosition;
import io.fluxcapacitor.javaclient.common.websocket.AbstractWebsocketClient;
import io.fluxcapacitor.javaclient.configuration.client.WebSocketClient;
import io.fluxcapacitor.javaclient.tracking.ConsumerConfiguration;
import io.fluxcapacitor.javaclient.tracking.client.TrackingClient;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.websocket.ClientEndpoint;

@ClientEndpoint
public class WebsocketTrackingClient
extends AbstractWebsocketClient
implements TrackingClient {
    public WebsocketTrackingClient(String endPointUrl, WebSocketClient.ClientConfig clientConfig, MessageType type) {
        this(URI.create(endPointUrl), clientConfig, type);
    }

    public WebsocketTrackingClient(URI endPointUri, WebSocketClient.ClientConfig clientConfig, MessageType type) {
        super(endPointUri, clientConfig, type != MessageType.METRICS, clientConfig.getTrackingConfigs().get(type).getSessions());
    }

    @Override
    public CompletableFuture<MessageBatch> read(String consumer, String trackerId, Long lastIndex, ConsumerConfiguration configuration) {
        return this.send((Request)new Read(consumer, trackerId, configuration.getMaxFetchBatchSize(), configuration.getMaxWaitDuration().toMillis(), configuration.getTypeFilter(), configuration.ignoreMessageTarget(), configuration.ignoreSegment(), configuration.getReadStrategy(), lastIndex, (Long)Optional.ofNullable(configuration.getPurgeDelay()).map(Duration::toMillis).orElse(null))).thenApply(ReadResult::getMessageBatch);
    }

    public CompletableFuture<ClaimSegmentResult> claimSegment(String consumer, String trackerId, Long lastIndex, ConsumerConfiguration config) {
        return this.send((Request)new ClaimSegment(consumer, trackerId, config.getMaxWaitDuration().toMillis(), config.getTypeFilter(), config.ignoreMessageTarget(), config.getReadStrategy(), lastIndex, (Long)Optional.ofNullable(config.getPurgeDelay()).map(Duration::toMillis).orElse(null)));
    }

    @Override
    public List<SerializedMessage> readFromIndex(long minIndex, int maxSize) {
        ReadFromIndexResult result = (ReadFromIndexResult)this.sendAndWait((Request)new ReadFromIndex(minIndex, maxSize));
        return result.getMessages();
    }

    @Override
    public Awaitable storePosition(String consumer, int[] segment, long lastIndex) {
        return Awaitable.fromFuture(this.send((Request)new StorePosition(consumer, segment, lastIndex)), (Duration)Duration.ofSeconds(60L));
    }

    @Override
    public Awaitable resetPosition(String consumer, long lastIndex) {
        return Awaitable.fromFuture(this.send((Request)new ResetPosition(consumer, lastIndex)), (Duration)Duration.ofSeconds(60L));
    }

    @Override
    public Position getPosition(String consumer) {
        return ((GetPositionResult)this.sendAndWait((Request)new GetPosition(consumer))).getPosition();
    }

    @Override
    public Awaitable disconnectTracker(String consumer, String trackerId, boolean sendFinalEmptyBatch) {
        return this.sendAndForget((JsonType)new DisconnectTracker(consumer, trackerId, sendFinalEmptyBatch));
    }

    @Override
    public void close() {
        this.close(true);
    }
}

