/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.common.handling.HandlerConfiguration;
import io.fluxcapacitor.common.handling.HandlerInspector;
import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.tracking.handling.HandleCommand;
import io.fluxcapacitor.javaclient.tracking.handling.HandleError;
import io.fluxcapacitor.javaclient.tracking.handling.HandleEvent;
import io.fluxcapacitor.javaclient.tracking.handling.HandleMetrics;
import io.fluxcapacitor.javaclient.tracking.handling.HandleNotification;
import io.fluxcapacitor.javaclient.tracking.handling.HandleQuery;
import io.fluxcapacitor.javaclient.tracking.handling.HandleResult;
import io.fluxcapacitor.javaclient.tracking.handling.HandleSchedule;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerFactory;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerInterceptor;
import io.fluxcapacitor.javaclient.web.HandleWeb;
import io.fluxcapacitor.javaclient.web.WebRequest;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;

public class DefaultHandlerFactory
implements HandlerFactory {
    private static final Map<MessageType, BiPredicate<DeserializingMessage, Annotation>> messageFilterCache = new ConcurrentHashMap<MessageType, BiPredicate<DeserializingMessage, Annotation>>();
    private final MessageType messageType;
    private final HandlerInterceptor handlerInterceptor;
    private final List<ParameterResolver<? super DeserializingMessage>> parameterResolvers;

    @Override
    public Optional<Handler<DeserializingMessage>> createHandler(Object target, String consumer, BiPredicate<Class<?>, Executable> handlerFilter) {
        return Optional.ofNullable(DefaultHandlerFactory.getHandlerAnnotation(this.messageType)).map(a -> HandlerConfiguration.builder().methodAnnotation(a).handlerFilter(handlerFilter).messageFilter(DefaultHandlerFactory.getMessageFilter(this.messageType)).build()).filter(config -> HandlerInspector.hasHandlerMethods(target.getClass(), (HandlerConfiguration)config)).map(config -> this.handlerInterceptor.wrap((Handler<DeserializingMessage>)HandlerInspector.createHandler((Object)target, this.parameterResolvers, (HandlerConfiguration)config), consumer));
    }

    private static Class<? extends Annotation> getHandlerAnnotation(MessageType messageType) {
        switch (messageType) {
            case COMMAND: {
                return HandleCommand.class;
            }
            case EVENT: {
                return HandleEvent.class;
            }
            case NOTIFICATION: {
                return HandleNotification.class;
            }
            case QUERY: {
                return HandleQuery.class;
            }
            case RESULT: {
                return HandleResult.class;
            }
            case ERROR: {
                return HandleError.class;
            }
            case SCHEDULE: {
                return HandleSchedule.class;
            }
            case METRICS: {
                return HandleMetrics.class;
            }
            case WEBREQUEST: {
                return HandleWeb.class;
            }
        }
        return null;
    }

    private static BiPredicate<DeserializingMessage, Annotation> getMessageFilter(MessageType messageType) {
        return messageFilterCache.computeIfAbsent(messageType, t -> {
            if (t == MessageType.WEBREQUEST) {
                return WebRequest.getWebRequestFilter();
            }
            return (m, a) -> true;
        });
    }

    @ConstructorProperties(value={"messageType", "handlerInterceptor", "parameterResolvers"})
    public DefaultHandlerFactory(MessageType messageType, HandlerInterceptor handlerInterceptor, List<ParameterResolver<? super DeserializingMessage>> parameterResolvers) {
        this.messageType = messageType;
        this.handlerInterceptor = handlerInterceptor;
        this.parameterResolvers = parameterResolvers;
    }
}

