/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.ClientUtils;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerFactory;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerRegistry;
import io.fluxcapacitor.javaclient.tracking.handling.LocalHandler;
import java.beans.ConstructorProperties;
import java.lang.reflect.Executable;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalHandlerRegistry
implements HandlerRegistry {
    private static final Logger log = LoggerFactory.getLogger(LocalHandlerRegistry.class);
    private final MessageType messageType;
    private final HandlerFactory handlerFactory;
    private final Serializer serializer;
    private final List<Handler<DeserializingMessage>> localHandlers = new CopyOnWriteArrayList<Handler<DeserializingMessage>>();

    @Override
    public Registration registerHandler(Object target, BiPredicate<Class<?>, Executable> handlerFilter) {
        Optional<Handler<DeserializingMessage>> handler = this.handlerFactory.createHandler(target, "local-" + this.messageType, handlerFilter);
        handler.ifPresent(this.localHandlers::add);
        return () -> handler.ifPresent(this.localHandlers::remove);
    }

    @Override
    public Optional<CompletableFuture<Message>> handle(Object payload, SerializedMessage serializedMessage) {
        if (!this.localHandlers.isEmpty()) {
            return new DeserializingMessage(serializedMessage, type -> this.serializer.convert(payload, type), this.messageType).apply(m -> {
                boolean handled = false;
                boolean logMessage = false;
                CompletionStage<Message> future = new CompletableFuture<Message>();
                for (Handler<DeserializingMessage> handler : this.localHandlers) {
                    if (!handler.canHandle(m)) continue;
                    boolean passive = handler.isPassive(m);
                    try {
                        Object result = handler.invoke(m);
                        if (!passive && !future.isDone()) {
                            if (result instanceof CompletableFuture) {
                                future = ((CompletableFuture)result).thenApply(Message::new);
                            } else {
                                future.complete(new Message(result));
                            }
                        }
                        if (!passive) {
                            handled = true;
                        }
                        logMessage = logMessage || ClientUtils.getLocalHandlerAnnotation(handler.getTarget().getClass(), handler.getMethod(m)).map(LocalHandler::logMessage).orElse(false) != false;
                    }
                    catch (Exception e) {
                        try {
                            if (passive) {
                                log.error("Passive local handler {} failed to handle a {}", new Object[]{handler, m.getPayloadClass(), e});
                            } else {
                                future.completeExceptionally(e);
                            }
                            if (!passive) {
                                handled = true;
                            }
                            logMessage = logMessage || ClientUtils.getLocalHandlerAnnotation(handler.getTarget().getClass(), handler.getMethod(m)).map(LocalHandler::logMessage).orElse(false) != false;
                        }
                        catch (Throwable throwable) {
                            if (!passive) {
                                handled = true;
                            }
                            logMessage = logMessage || ClientUtils.getLocalHandlerAnnotation(handler.getTarget().getClass(), handler.getMethod(m)).map(LocalHandler::logMessage).orElse(false) != false;
                            throw throwable;
                        }
                    }
                }
                try {
                    Optional optional = handled ? Optional.of(future) : Optional.empty();
                    return optional;
                }
                finally {
                    if (logMessage) {
                        FluxCapacitor.getOptionally().ifPresent(fc -> fc.client().getGatewayClient(m.getMessageType()).send(Guarantee.NONE, serializedMessage));
                    }
                }
            });
        }
        return Optional.empty();
    }

    @ConstructorProperties(value={"messageType", "handlerFactory", "serializer"})
    public LocalHandlerRegistry(MessageType messageType, HandlerFactory handlerFactory, Serializer serializer) {
        this.messageType = messageType;
        this.handlerFactory = handlerFactory;
        this.serializer = serializer;
    }
}

