/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling.authentication;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerInterceptor;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.User;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.UserProvider;
import io.fluxcapacitor.javaclient.tracking.handling.validation.ValidationUtils;
import java.beans.ConstructorProperties;
import java.lang.reflect.Executable;
import java.util.Optional;
import java.util.function.Function;

public class AuthenticatingInterceptor
implements DispatchInterceptor,
HandlerInterceptor {
    private final UserProvider userProvider;

    @Override
    public Message interceptDispatch(Message m, MessageType messageType) {
        if (!this.userProvider.containsUser(m.getMetadata())) {
            User user;
            User user2 = user = Optional.ofNullable(DeserializingMessage.getCurrent()).isPresent() ? this.userProvider.getSystemUser() : Optional.ofNullable(this.userProvider.getActiveUser()).orElseGet(this.userProvider::getSystemUser);
            if (user != null) {
                m = m.withMetadata(this.userProvider.addToMetadata(m.getMetadata(), user));
            }
        }
        return m;
    }

    @Override
    public Function<DeserializingMessage, Object> interceptHandling(Function<DeserializingMessage, Object> function, Handler<DeserializingMessage> handler, String consumer) {
        return m -> {
            Object previous = User.getCurrent();
            User user = this.userProvider.fromMetadata(m.getMetadata());
            try {
                User.current.set(user);
                ValidationUtils.assertAuthorized(m.getPayloadClass(), user);
                Object r = function.apply((DeserializingMessage)m);
                return r;
            }
            finally {
                User.current.set((User)previous);
            }
        };
    }

    @Override
    public Handler<DeserializingMessage> wrap(Handler<DeserializingMessage> handler, String consumer) {
        return new AuthorizingHandler(HandlerInterceptor.super.wrap(handler, consumer));
    }

    @ConstructorProperties(value={"userProvider"})
    public AuthenticatingInterceptor(UserProvider userProvider) {
        this.userProvider = userProvider;
    }

    private class AuthorizingHandler
    implements Handler<DeserializingMessage> {
        private final Handler<DeserializingMessage> delegate;

        public boolean canHandle(DeserializingMessage m) {
            if (!this.delegate.canHandle((Object)m)) {
                return false;
            }
            return ValidationUtils.isAuthorized(this.delegate.getTarget().getClass(), this.delegate.getMethod((Object)m), AuthenticatingInterceptor.this.userProvider.fromMetadata(m.getMetadata()));
        }

        public String toString() {
            return this.delegate.toString();
        }

        @ConstructorProperties(value={"delegate"})
        public AuthorizingHandler(Handler<DeserializingMessage> delegate) {
            this.delegate = delegate;
        }

        public Executable getMethod(DeserializingMessage arg0) {
            return this.delegate.getMethod((Object)arg0);
        }

        public boolean isPassive(DeserializingMessage arg0) {
            return this.delegate.isPassive((Object)arg0);
        }

        public Object invoke(DeserializingMessage arg0) {
            return this.delegate.invoke((Object)arg0);
        }

        public Object getTarget() {
            return this.delegate.getTarget();
        }
    }

    private static interface ExcludedMethods {
        public boolean canHandle(DeserializingMessage var1);
    }
}

