/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling.errorreporting;

import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.exception.FunctionalException;
import io.fluxcapacitor.javaclient.common.exception.TechnicalException;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.publishing.ErrorGateway;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerInterceptor;
import java.beans.ConstructorProperties;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorReportingInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ErrorReportingInterceptor.class);
    private final ErrorGateway errorGateway;

    @Override
    public Function<DeserializingMessage, Object> interceptHandling(Function<DeserializingMessage, Object> function, Handler<DeserializingMessage> handler, String consumer) {
        return message -> {
            try {
                Object result = function.apply((DeserializingMessage)message);
                if (result instanceof CompletionStage) {
                    ((CompletionStage)result).whenComplete((r, e) -> {
                        if (e != null) {
                            message.run(m -> this.reportError((Throwable)e, handler, (DeserializingMessage)m));
                        }
                    });
                }
                return result;
            }
            catch (Exception e2) {
                this.reportError(e2, handler, (DeserializingMessage)message);
                throw e2;
            }
        };
    }

    protected void reportError(Throwable e, Handler<DeserializingMessage> handler, DeserializingMessage cause) {
        Metadata metadata = cause.getMetadata();
        if (!(e instanceof FunctionalException) && !(e instanceof TechnicalException)) {
            metadata = metadata.with("stackTrace", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            e = new TechnicalException(String.format("Handler %s failed to handle a %s", handler, cause));
        }
        this.errorGateway.report(new Message(e, metadata));
    }

    @ConstructorProperties(value={"errorGateway"})
    public ErrorReportingInterceptor(ErrorGateway errorGateway) {
        this.errorGateway = errorGateway;
    }
}

