/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling.validation;

import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.handling.HandlerConfiguration;
import io.fluxcapacitor.common.handling.HandlerInspector;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.modeling.AggregateRoot;
import io.fluxcapacitor.javaclient.modeling.AssertLegal;
import io.fluxcapacitor.javaclient.modeling.Entity;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.ForbidsRole;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.RequiresRole;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.UnauthenticatedException;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.UnauthorizedException;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.User;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.UserParameterResolver;
import io.fluxcapacitor.javaclient.tracking.handling.validation.Jsr380Validator;
import io.fluxcapacitor.javaclient.tracking.handling.validation.ValidationException;
import io.fluxcapacitor.javaclient.tracking.handling.validation.Validator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.BiFunction;
import java.util.function.Function;

public class ValidationUtils {
    public static final Validator defaultValidator = Optional.of(ServiceLoader.load(Validator.class)).map(ServiceLoader::iterator).filter(Iterator::hasNext).map(Iterator::next).orElse(Jsr380Validator.createDefault());
    protected static final Function<Class<?>, HandlerInvoker<Entity<?, ?>>> assertLegalInvokerCache = ObjectUtils.memoize(type -> HandlerInspector.inspect((Class)type, Arrays.asList(new UserParameterResolver(), new AssertLegalEntityParameterResolver()), (HandlerConfiguration)HandlerConfiguration.builder().methodAnnotation(AssertLegal.class).invokeMultipleMethods(true).build()));
    private static final Function<Class<?>, String[]> requiredRolesCache = ObjectUtils.memoize(payloadClass -> ValidationUtils.getRequiredRoles(ReflectionUtils.getTypeAnnotations((Class)payloadClass)));
    private static final BiFunction<Class<?>, Executable, String[]> requiredRolesForMethodCache = ObjectUtils.memoize((target, executable) -> Optional.ofNullable(ValidationUtils.getRequiredRoles(Arrays.asList(executable.getAnnotations()))).orElseGet(() -> ValidationUtils.getRequiredRoles(ReflectionUtils.getTypeAnnotations((Class)target))));

    public static Optional<ValidationException> checkValidity(Object object, Class<?> ... groups) {
        return defaultValidator.checkValidity(object, groups);
    }

    public static boolean isValid(Object object, Class<?> ... groups) {
        return defaultValidator.isValid(object, groups);
    }

    public static void assertValid(Object object, Class<?> ... groups) {
        defaultValidator.assertValid(object, groups);
    }

    public static void assertValid(Object[] objects, Class<?> ... groups) {
        Arrays.stream(objects).forEach(o -> ValidationUtils.assertValid(o, groups));
    }

    public static void assertValid(List<Object> objects, Class<?> ... groups) {
        objects.forEach(o -> ValidationUtils.assertValid(o, groups));
    }

    public static <E extends Exception> void assertLegal(Object commandOrQuery, Entity<?, ?> entity) throws E {
        HandlerInvoker<Entity<?, ?>> invoker = assertLegalInvokerCache.apply(commandOrQuery.getClass());
        if (invoker.canHandle(commandOrQuery, entity)) {
            invoker.invoke(commandOrQuery, entity);
        }
    }

    public static <E extends Exception> Optional<E> checkLegality(Object commandOrQuery, AggregateRoot<?> aggregate) {
        try {
            ValidationUtils.assertLegal(commandOrQuery, aggregate);
        }
        catch (Exception e) {
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public static boolean isLegal(Object commandOrQuery, AggregateRoot<?> aggregate) {
        return ValidationUtils.checkLegality(commandOrQuery, aggregate).isEmpty();
    }

    public static void assertAuthorized(Class<?> payloadType, User user) throws UnauthenticatedException, UnauthorizedException {
        String[] requiredRoles = requiredRolesCache.apply(payloadType);
        ValidationUtils.assertAuthorized(payloadType.getSimpleName(), user, requiredRoles);
    }

    public static Optional<Exception> checkAuthorization(Class<?> payloadType, User user) {
        try {
            ValidationUtils.assertAuthorized(payloadType, user);
        }
        catch (Exception e) {
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public static boolean isAuthorized(Class<?> payloadType, User user) {
        return !ValidationUtils.checkAuthorization(payloadType, user).isPresent();
    }

    public static boolean isAuthorized(Class<?> target, Executable method, User user) {
        try {
            ValidationUtils.assertAuthorized(method.getName(), user, requiredRolesForMethodCache.apply(target, method));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected static void assertAuthorized(String action, User user, String[] requiredRoles) {
        if (requiredRoles != null) {
            if (user == null) {
                throw new UnauthenticatedException(String.format("%s requires authentication", action));
            }
            ArrayList remainingRoles = new ArrayList();
            if (Arrays.stream(requiredRoles).filter(r -> {
                if (r.startsWith("!")) {
                    return true;
                }
                remainingRoles.add(r);
                return false;
            }).anyMatch(r -> user.hasRole(r.substring(1)))) {
                throw new UnauthorizedException(String.format("User %s is unauthorized to execute %s", user.getName(), action));
            }
            if (!remainingRoles.isEmpty()) {
                if (remainingRoles.stream().noneMatch(user::hasRole)) {
                    throw new UnauthorizedException(String.format("User %s is unauthorized to execute %s", user.getName(), action));
                }
            }
        }
    }

    protected static String[] getRequiredRoles(Iterable<? extends Annotation> annotations) {
        for (Annotation annotation : annotations) {
            if (annotation instanceof RequiresRole) {
                return ((RequiresRole)annotation).value();
            }
            if (annotation.annotationType().isAnnotationPresent(RequiresRole.class)) {
                for (Method method : ReflectionUtils.getAllMethods(annotation.annotationType())) {
                    if (!method.getName().equalsIgnoreCase("value")) continue;
                    Object[] result = (Object[])method.invoke((Object)annotation, new Object[0]);
                    return (String[])Arrays.stream(result).map(Object::toString).toArray(String[]::new);
                }
            }
            if (annotation instanceof ForbidsRole) {
                return (String[])Arrays.stream(((ForbidsRole)annotation).value()).map(s -> "!" + s).toArray(String[]::new);
            }
            if (!annotation.annotationType().isAnnotationPresent(ForbidsRole.class)) continue;
            for (Method method : ReflectionUtils.getAllMethods(annotation.annotationType())) {
                if (!method.getName().equalsIgnoreCase("value")) continue;
                Object[] result = (Object[])method.invoke((Object)annotation, new Object[0]);
                return (String[])Arrays.stream(result).map(Object::toString).map(s -> "!" + s).toArray(String[]::new);
            }
        }
        return null;
    }

    protected static class AssertLegalEntityParameterResolver
    implements ParameterResolver<Entity<?, ?>> {
        protected AssertLegalEntityParameterResolver() {
        }

        public Function<Entity<?, ?>, Object> resolve(Parameter parameter, Annotation methodAnnotation) {
            return Entity::get;
        }

        public boolean matches(Parameter parameter, Annotation methodAnnotation, Entity<?, ?> aggregate) {
            return parameter.getType().isAssignableFrom(aggregate.type()) || aggregate.type().isAssignableFrom(parameter.getType());
        }
    }
}

