/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.web;

import io.fluxcapacitor.common.SearchUtils;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.web.HandleWeb;
import io.fluxcapacitor.javaclient.web.HttpRequestMethod;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import lombok.NonNull;

public final class WebRequest
extends Message {
    private static final Map<Annotation, Predicate<DeserializingMessage>> filterCache = new ConcurrentHashMap<Annotation, Predicate<DeserializingMessage>>();
    @NonNull
    private final String path;
    @NonNull
    private final HttpRequestMethod method;
    @NonNull
    private final Map<String, List<String>> headers;

    public static Builder builder() {
        return new Builder();
    }

    public static BiPredicate<DeserializingMessage, Annotation> getWebRequestFilter() {
        return (message, annotation) -> filterCache.computeIfAbsent((Annotation)annotation, a -> {
            Annotation typeAnnotation = ReflectionUtils.getTypeAnnotation(a.annotationType(), HandleWeb.class);
            Predicate<String> pathTest = ReflectionUtils.readProperty((String)"value", (Object)a).map(url -> url.startsWith("/") ? url : "/" + url).map(SearchUtils::convertGlobToRegex).map(Pattern::asMatchPredicate).map(p -> s -> p.test(s.startsWith("/") ? s : "/" + s)).orElse(p -> true);
            Predicate<String> methodTest = ReflectionUtils.readProperty((String)"method", (Object)a).or(() -> ReflectionUtils.readProperty((String)"method", (Object)typeAnnotation)).map(r -> r == HttpRequestMethod.ANY ? p -> true : p -> r.name().equals(p)).orElse(p -> true);
            return msg -> {
                String path = Objects.requireNonNull(msg.getMetadata().get("url"), "Web request url is missing in the metadata of a WebRequest message");
                String method = Objects.requireNonNull(msg.getMetadata().get("method"), "Web request method is missing in the metadata of a WebRequest message");
                return pathTest.test(path) && methodTest.test(method);
            };
        }).test(message);
    }

    private WebRequest(Builder builder) {
        super(builder.payload(), Metadata.of((Object[])new Object[]{"url", builder.url(), "method", builder.method().name(), "headers", builder.headers()}));
        this.path = builder.url();
        this.method = builder.method();
        this.headers = builder.headers();
    }

    @ConstructorProperties(value={"payload", "metadata", "messageId", "timestamp"})
    WebRequest(Object payload, Metadata metadata, String messageId, Instant timestamp) {
        super(payload, metadata, messageId, timestamp);
        this.path = WebRequest.getUrl(metadata);
        this.method = WebRequest.getMethod(metadata);
        this.headers = WebRequest.getHeaders(metadata);
    }

    public WebRequest(Message m) {
        this(m.getPayload(), m.getMetadata(), m.getMessageId(), m.getTimestamp());
    }

    @Override
    public SerializedMessage serialize(Serializer serializer) {
        return this.headers.getOrDefault("Content-Type", List.of()).stream().findFirst().map(format -> new SerializedMessage(serializer.serialize(this.getPayload(), (String)format), this.getMetadata(), this.getMessageId(), Long.valueOf(this.getTimestamp().toEpochMilli()))).orElseGet(() -> super.serialize(serializer));
    }

    @Override
    public WebRequest withMetadata(Metadata metadata) {
        return new WebRequest(super.withMetadata(metadata));
    }

    @Override
    public WebRequest withPayload(Object payload) {
        return new WebRequest(super.withPayload(payload));
    }

    public static String getUrl(Metadata metadata) {
        return Optional.ofNullable(metadata.get("url")).map(u -> u.startsWith("/") ? u : "/" + u).orElseThrow(() -> new IllegalStateException("WebRequest is malformed: url is missing"));
    }

    public static HttpRequestMethod getMethod(Metadata metadata) {
        return Optional.ofNullable(metadata.get("method")).map(m -> {
            try {
                return HttpRequestMethod.valueOf(m);
            }
            catch (Exception e) {
                throw new IllegalStateException("WebRequest is malformed: unrecognized http method");
            }
        }).orElseThrow(() -> new IllegalStateException("WebRequest is malformed: http method is missing"));
    }

    public static Map<String, List<String>> getHeaders(Metadata metadata) {
        return Optional.ofNullable((Map)metadata.get("headers", Map.class)).orElse(Collections.emptyMap());
    }

    @NonNull
    public String getPath() {
        return this.path;
    }

    @NonNull
    public HttpRequestMethod getMethod() {
        return this.method;
    }

    @NonNull
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebRequest)) {
            return false;
        }
        WebRequest other = (WebRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        HttpRequestMethod this$method = this.getMethod();
        HttpRequestMethod other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        Map<String, List<String>> this$headers = this.getHeaders();
        Map<String, List<String>> other$headers = other.getHeaders();
        return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WebRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        HttpRequestMethod $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        Map<String, List<String>> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "WebRequest(super=" + super.toString() + ", path=" + this.getPath() + ", method=" + this.getMethod() + ", headers=" + this.getHeaders() + ")";
    }

    public static class Builder {
        private String url;
        private HttpRequestMethod method;
        private Map<String, List<String>> headers = new HashMap<String, List<String>>();
        private Object payload;

        public Builder header(String key, String value) {
            this.headers.computeIfAbsent(key, k -> new ArrayList()).add(value);
            return this;
        }

        public Builder contentType(String contentType) {
            return this.header("Content-Type", contentType);
        }

        public Builder payload(Object payload) {
            this.payload = payload;
            if (!this.headers().containsKey("Content-Type")) {
                if (payload instanceof String) {
                    return this.contentType("text/plain");
                }
                if (payload instanceof byte[]) {
                    return this.contentType("application/octet-stream");
                }
            }
            return this;
        }

        public WebRequest build() {
            return new WebRequest(this);
        }

        public String url() {
            return this.url;
        }

        public HttpRequestMethod method() {
            return this.method;
        }

        public Map<String, List<String>> headers() {
            return this.headers;
        }

        public Object payload() {
            return this.payload;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder method(HttpRequestMethod method) {
            this.method = method;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$url = this.url();
            String other$url = other.url();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            HttpRequestMethod this$method = this.method();
            HttpRequestMethod other$method = other.method();
            if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
                return false;
            }
            Map<String, List<String>> this$headers = this.headers();
            Map<String, List<String>> other$headers = other.headers();
            if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
                return false;
            }
            Object this$payload = this.payload();
            Object other$payload = other.payload();
            return !(this$payload == null ? other$payload != null : !this$payload.equals(other$payload));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Builder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $url = this.url();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            HttpRequestMethod $method = this.method();
            result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
            Map<String, List<String>> $headers = this.headers();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            Object $payload = this.payload();
            result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
            return result;
        }

        public String toString() {
            return "WebRequest.Builder(url=" + this.url() + ", method=" + this.method() + ", headers=" + this.headers() + ", payload=" + this.payload() + ")";
        }
    }
}

