/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.web;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import io.fluxcapacitor.javaclient.publishing.GatewayException;
import io.fluxcapacitor.javaclient.publishing.ResultGateway;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import io.fluxcapacitor.javaclient.web.WebResponseMapper;
import java.beans.ConstructorProperties;
import java.util.concurrent.CompletableFuture;

public class WebResponseGateway
implements ResultGateway {
    private final GatewayClient client;
    private final Serializer serializer;
    private final DispatchInterceptor dispatchInterceptor;
    private final WebResponseMapper webResponseMapper;

    @Override
    public CompletableFuture<Void> respond(Object payload, Metadata metadata, String target, int requestId, Guarantee guarantee) {
        try {
            Message message = this.dispatchInterceptor.interceptDispatch(this.webResponseMapper.map(payload, metadata), MessageType.WEBRESPONSE);
            SerializedMessage serializedMessage = this.dispatchInterceptor.modifySerializedMessage(message.serialize(this.serializer), message, MessageType.WEBRESPONSE);
            serializedMessage.setTarget(target);
            serializedMessage.setRequestId(Integer.valueOf(requestId));
            return this.client.send(guarantee, serializedMessage).asCompletableFuture();
        }
        catch (Exception e) {
            throw new GatewayException(String.format("Failed to send response %s", payload), e);
        }
    }

    @ConstructorProperties(value={"client", "serializer", "dispatchInterceptor", "webResponseMapper"})
    public WebResponseGateway(GatewayClient client, Serializer serializer, DispatchInterceptor dispatchInterceptor, WebResponseMapper webResponseMapper) {
        this.client = client;
        this.serializer = serializer;
        this.dispatchInterceptor = dispatchInterceptor;
        this.webResponseMapper = webResponseMapper;
    }
}

