/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common;

import io.fluxcapacitor.common.api.HasMetadata;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.publishing.routing.RoutingKey;
import io.fluxcapacitor.javaclient.scheduling.Schedule;
import java.util.Optional;
import org.slf4j.LoggerFactory;

public interface HasMessage
extends HasMetadata {
    public Message toMessage();

    default public Optional<String> computeRoutingKey() {
        Message m = this.toMessage();
        String routingValue = null;
        if (m.getPayload() != null) {
            Class<?> payloadType = m.getPayload().getClass();
            RoutingKey typeAnnotation = payloadType.getAnnotation(RoutingKey.class);
            if (typeAnnotation != null) {
                routingValue = this.getMetadata().get((Object)typeAnnotation.metadataKey());
                if (routingValue == null) {
                    LoggerFactory.getLogger(HasMessage.class).warn("Did not find metadata routingValue for {} for routing key of message {} (id {})", new Object[]{typeAnnotation.metadataKey(), payloadType, m.getMessageId()});
                } else {
                    return Optional.of(routingValue);
                }
            }
            routingValue = ReflectionUtils.getAnnotatedPropertyValue(m.getPayload(), RoutingKey.class).map(Object::toString).orElse(null);
        }
        if (routingValue == null && m instanceof Schedule) {
            routingValue = ((Schedule)m).getScheduleId();
        }
        return Optional.ofNullable(routingValue);
    }
}

