/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.serialization;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.serialization.JsonUtils;
import io.fluxcapacitor.javaclient.common.HasMessage;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingObject;
import io.fluxcapacitor.javaclient.common.serialization.MessageFormatter;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.scheduling.Schedule;
import io.fluxcapacitor.javaclient.tracking.IndexUtils;
import io.fluxcapacitor.javaclient.web.WebRequest;
import io.fluxcapacitor.javaclient.web.WebResponse;
import java.time.Instant;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeserializingMessage
implements HasMessage {
    private static final Logger log = LoggerFactory.getLogger(DeserializingMessage.class);
    public static MessageFormatter messageFormatter = MessageFormatter.DEFAULT;
    private static final ThreadLocal<Set<Consumer<Throwable>>> batchCompletionHandlers = new ThreadLocal();
    private static final ThreadLocal<Map<Object, Object>> batchResources = new ThreadLocal();
    private static final ThreadLocal<DeserializingMessage> current = new ThreadLocal();
    private final DeserializingObject<byte[], SerializedMessage> delegate;
    private final MessageType messageType;
    private Message message;
    private final transient Serializer serializer;
    private SerializedMessage serializedMessage;

    public DeserializingMessage(SerializedMessage message, Function<Class<?>, Object> payload, MessageType messageType) {
        this(new DeserializingObject<byte[], SerializedMessage>(message, payload), messageType);
    }

    public DeserializingMessage(DeserializingObject<byte[], SerializedMessage> delegate, MessageType messageType) {
        this.delegate = delegate;
        this.messageType = messageType;
        this.serializer = null;
    }

    public DeserializingMessage(@NonNull Message message, MessageType messageType, Serializer serializer) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.messageType = messageType;
        this.message = message;
        this.serializer = serializer;
        this.delegate = null;
    }

    protected DeserializingMessage(@NonNull DeserializingMessage input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        this.messageType = input.messageType;
        this.message = input.message;
        this.serializer = input.serializer;
        this.delegate = input.delegate;
        this.serializedMessage = input.serializedMessage;
    }

    public void run(Consumer<DeserializingMessage> task) {
        this.apply(m -> {
            task.accept((DeserializingMessage)m);
            return null;
        });
    }

    public <T> T apply(Function<DeserializingMessage, T> action) {
        return DeserializingMessage.handleBatch(Stream.of(this)).map(action).collect(Collectors.toList()).get(0);
    }

    @Override
    public Message toMessage() {
        if (this.message == null) {
            this.message = this.asMessage();
        }
        return this.message;
    }

    private Message asMessage() {
        Message message = new Message(this.getPayload(), this.getMetadata(), this.getMessageId(), this.getTimestamp());
        switch (this.messageType) {
            case SCHEDULE: {
                return new Schedule(message);
            }
            case WEBREQUEST: {
                return new WebRequest(message);
            }
            case WEBRESPONSE: {
                return new WebResponse(message);
            }
        }
        return message;
    }

    public Metadata getMetadata() {
        return Optional.ofNullable(this.delegate).map(DeserializingObject::getSerializedObject).map(SerializedMessage::getMetadata).or(() -> Optional.ofNullable(this.message).map(Message::getMetadata)).orElse(null);
    }

    public String getMessageId() {
        return Optional.ofNullable(this.delegate).map(DeserializingObject::getSerializedObject).map(SerializedMessage::getMessageId).or(() -> Optional.ofNullable(this.message).map(Message::getMessageId)).orElse(null);
    }

    public Long getIndex() {
        return Optional.ofNullable(this.delegate).map(DeserializingObject::getSerializedObject).map(SerializedMessage::getIndex).orElseGet(() -> this.message instanceof Schedule ? Long.valueOf(IndexUtils.indexFromTimestamp(((Schedule)this.message).getDeadline())) : null);
    }

    public Instant getTimestamp() {
        return Optional.ofNullable(this.delegate).map(DeserializingObject::getSerializedObject).map(SerializedMessage::getTimestamp).map(Instant::ofEpochMilli).or(() -> Optional.ofNullable(this.message).map(Message::getTimestamp)).orElse(null);
    }

    public boolean isDeserialized() {
        return Optional.ofNullable(this.delegate).map(DeserializingObject::isDeserialized).orElse(true);
    }

    public <V> V getPayload() {
        return Optional.ofNullable(this.delegate).map(DeserializingObject::getPayload).or(() -> Optional.ofNullable(this.message).map(Message::getPayload)).orElse(null);
    }

    public <V> V getPayloadAs(Class<V> type) {
        return Optional.ofNullable(this.delegate).map(d -> d.getPayloadAs(type)).or(() -> Optional.ofNullable(this.message).map(m -> JsonUtils.convertValue(m.getPayload(), (Class)type))).orElse(null);
    }

    public Class<?> getPayloadClass() {
        return Optional.ofNullable(this.delegate).map(DeserializingObject::getPayloadClass).or(() -> Optional.ofNullable(this.message).map(Message::getPayloadClass)).orElse(null);
    }

    public String getType() {
        return Optional.ofNullable(this.delegate).map(DeserializingObject::getType).or(() -> Optional.ofNullable(this.message).map(m -> m.getPayloadClass().getName())).orElse(null);
    }

    public SerializedMessage getSerializedObject() {
        if (this.delegate != null) {
            return this.delegate.getSerializedObject();
        }
        if (this.serializedMessage == null) {
            this.serializedMessage = this.message.serialize(this.serializer);
        }
        return this.serializedMessage;
    }

    public static DeserializingMessage getCurrent() {
        return current.get();
    }

    public String toString() {
        return (String)messageFormatter.apply(this);
    }

    public static Stream<DeserializingMessage> handleBatch(Stream<DeserializingMessage> batch) {
        return StreamSupport.stream(new MessageSpliterator(batch.spliterator()), false);
    }

    public static void whenBatchCompletes(Consumer<Throwable> handler) {
        if (current.get() == null) {
            handler.accept(null);
        } else {
            if (batchCompletionHandlers.get() == null) {
                batchCompletionHandlers.set(new LinkedHashSet());
            }
            batchCompletionHandlers.get().add(handler);
        }
    }

    public static <K, V> V computeForBatch(K key, BiFunction<? super K, ? super V, ? extends V> function) {
        return DeserializingMessage.getBatchResources().compute(key, function);
    }

    public static <K, V> V computeForBatchIfAbsent(K key, Function<? super K, ? extends V> function) {
        return DeserializingMessage.getBatchResources().computeIfAbsent(key, function);
    }

    public static <V> V getBatchResource(Object key) {
        return (V)DeserializingMessage.getBatchResources().get(key);
    }

    public static <V> V getBatchResourceOrDefault(Object key, V defaultValue) {
        return (V)DeserializingMessage.getBatchResources().getOrDefault(key, defaultValue);
    }

    private static Map<Object, Object> getBatchResources() {
        if (batchResources.get() == null) {
            batchResources.set(new HashMap());
        }
        return batchResources.get();
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeserializingMessage)) {
            return false;
        }
        DeserializingMessage other = (DeserializingMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DeserializingObject<byte[], SerializedMessage> this$delegate = this.delegate;
        DeserializingObject<byte[], SerializedMessage> other$delegate = other.delegate;
        if (this$delegate == null ? other$delegate != null : !this$delegate.equals(other$delegate)) {
            return false;
        }
        MessageType this$messageType = this.getMessageType();
        MessageType other$messageType = other.getMessageType();
        if (this$messageType == null ? other$messageType != null : !this$messageType.equals(other$messageType)) {
            return false;
        }
        Message this$message = this.message;
        Message other$message = other.message;
        if (this$message == null ? other$message != null : !((Object)this$message).equals(other$message)) {
            return false;
        }
        SerializedMessage this$serializedMessage = this.serializedMessage;
        SerializedMessage other$serializedMessage = other.serializedMessage;
        return !(this$serializedMessage == null ? other$serializedMessage != null : !this$serializedMessage.equals(other$serializedMessage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeserializingMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DeserializingObject<byte[], SerializedMessage> $delegate = this.delegate;
        result = result * 59 + ($delegate == null ? 43 : $delegate.hashCode());
        MessageType $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : $messageType.hashCode());
        Message $message = this.message;
        result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
        SerializedMessage $serializedMessage = this.serializedMessage;
        result = result * 59 + ($serializedMessage == null ? 43 : $serializedMessage.hashCode());
        return result;
    }

    protected static class MessageSpliterator
    extends Spliterators.AbstractSpliterator<DeserializingMessage> {
        private final Spliterator<DeserializingMessage> upStream;

        public MessageSpliterator(Spliterator<DeserializingMessage> upStream) {
            super(upStream.estimateSize(), upStream.characteristics());
            this.upStream = upStream;
        }

        @Override
        public boolean tryAdvance(Consumer<? super DeserializingMessage> action) {
            boolean hadNext;
            try {
                hadNext = this.upStream.tryAdvance((? super T d) -> {
                    DeserializingMessage previous = DeserializingMessage.getCurrent();
                    try {
                        current.set((DeserializingMessage)d);
                        action.accept((DeserializingMessage)d);
                    }
                    finally {
                        current.set(previous);
                    }
                });
            }
            catch (Throwable e) {
                this.onBatchCompletion(e);
                throw e;
            }
            if (!hadNext && DeserializingMessage.getCurrent() == null) {
                this.onBatchCompletion(null);
            }
            return hadNext;
        }

        protected void onBatchCompletion(Throwable error) {
            try {
                Optional.ofNullable(batchCompletionHandlers.get()).ifPresent(handlers -> {
                    batchCompletionHandlers.remove();
                    handlers.forEach(h -> h.accept(error));
                });
            }
            finally {
                batchResources.remove();
                batchCompletionHandlers.remove();
            }
        }
    }
}

